/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.metadata.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.UnionDataSource;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.metadata.metadata.AllColumnIncluderator;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.joda.time.Interval;

public class SegmentMetadataQuery
extends BaseQuery<SegmentAnalysis> {
    public static final byte[] ANALYSIS_TYPES_CACHE_PREFIX = new byte[]{-1};
    public static final Interval DEFAULT_INTERVAL = new Interval(-4611686018427387904L, 0x3FFFFFFFFFFFFFFFL);
    public static final EnumSet<AnalysisType> DEFAULT_ANALYSIS_TYPES = EnumSet.of(AnalysisType.CARDINALITY, AnalysisType.SIZE, AnalysisType.INTERVAL, AnalysisType.MINMAX);
    private final ColumnIncluderator toInclude;
    private final boolean merge;
    private final boolean usingDefaultInterval;
    private final EnumSet<AnalysisType> analysisTypes;
    private final boolean lenientAggregatorMerge;

    @JsonCreator
    public SegmentMetadataQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="toInclude") ColumnIncluderator toInclude, @JsonProperty(value="merge") Boolean merge, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="analysisTypes") EnumSet<AnalysisType> analysisTypes, @JsonProperty(value="usingDefaultInterval") Boolean useDefaultInterval, @JsonProperty(value="lenientAggregatorMerge") Boolean lenientAggregatorMerge) {
        super(dataSource, querySegmentSpec == null ? new MultipleIntervalSegmentSpec(Arrays.asList(DEFAULT_INTERVAL)) : querySegmentSpec, false, context);
        this.usingDefaultInterval = querySegmentSpec == null ? true : (useDefaultInterval == null ? false : useDefaultInterval);
        this.toInclude = toInclude == null ? new AllColumnIncluderator() : toInclude;
        this.merge = merge == null ? false : merge;
        this.analysisTypes = analysisTypes == null ? DEFAULT_ANALYSIS_TYPES : analysisTypes;
        Preconditions.checkArgument(dataSource instanceof TableDataSource || dataSource instanceof UnionDataSource, "SegmentMetadataQuery only supports table or union datasource");
        this.lenientAggregatorMerge = lenientAggregatorMerge == null ? false : lenientAggregatorMerge;
    }

    @JsonProperty
    public ColumnIncluderator getToInclude() {
        return this.toInclude;
    }

    @JsonProperty
    public boolean isMerge() {
        return this.merge;
    }

    @JsonProperty
    public boolean isUsingDefaultInterval() {
        return this.usingDefaultInterval;
    }

    @Override
    public boolean hasFilters() {
        return false;
    }

    @Override
    public DimFilter getFilter() {
        return null;
    }

    @Override
    public String getType() {
        return "segmentMetadata";
    }

    @JsonProperty
    public EnumSet<AnalysisType> getAnalysisTypes() {
        return this.analysisTypes;
    }

    @JsonProperty
    public boolean isLenientAggregatorMerge() {
        return this.lenientAggregatorMerge;
    }

    public boolean analyzingInterval() {
        return this.analysisTypes.contains((Object)AnalysisType.INTERVAL);
    }

    public boolean hasAggregators() {
        return this.analysisTypes.contains((Object)AnalysisType.AGGREGATORS);
    }

    public boolean hasTimestampSpec() {
        return this.analysisTypes.contains((Object)AnalysisType.TIMESTAMPSPEC);
    }

    public boolean hasQueryGranularity() {
        return this.analysisTypes.contains((Object)AnalysisType.QUERYGRANULARITY);
    }

    public boolean hasRollup() {
        return this.analysisTypes.contains((Object)AnalysisType.ROLLUP);
    }

    public boolean hasMinMax() {
        return this.analysisTypes.contains((Object)AnalysisType.MINMAX);
    }

    public byte[] getAnalysisTypesCacheKey() {
        int size = 1;
        ArrayList<byte[]> typeBytesList = Lists.newArrayListWithExpectedSize(this.analysisTypes.size());
        for (AnalysisType analysisType : this.analysisTypes) {
            byte[] bytes = analysisType.getCacheKey();
            typeBytesList.add(bytes);
            size += bytes.length;
        }
        ByteBuffer bytes = ByteBuffer.allocate(size);
        bytes.put(ANALYSIS_TYPES_CACHE_PREFIX);
        for (byte[] typeBytes : typeBytesList) {
            bytes.put(typeBytes);
        }
        return bytes.array();
    }

    @Override
    public Query<SegmentAnalysis> withOverriddenContext(Map<String, Object> contextOverride) {
        return new SegmentMetadataQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.toInclude, this.merge, this.computeOverridenContext(contextOverride), this.analysisTypes, this.usingDefaultInterval, this.lenientAggregatorMerge);
    }

    @Override
    public Query<SegmentAnalysis> withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new SegmentMetadataQuery(this.getDataSource(), spec, this.toInclude, this.merge, this.getContext(), this.analysisTypes, this.usingDefaultInterval, this.lenientAggregatorMerge);
    }

    @Override
    public Query<SegmentAnalysis> withDataSource(DataSource dataSource) {
        return new SegmentMetadataQuery(dataSource, this.getQuerySegmentSpec(), this.toInclude, this.merge, this.getContext(), this.analysisTypes, this.usingDefaultInterval, this.lenientAggregatorMerge);
    }

    public Query<SegmentAnalysis> withColumns(ColumnIncluderator includerator) {
        return new SegmentMetadataQuery(this.getDataSource(), this.getQuerySegmentSpec(), includerator, this.merge, this.getContext(), this.analysisTypes, this.usingDefaultInterval, this.lenientAggregatorMerge);
    }

    public String toString() {
        return "SegmentMetadataQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", toInclude=" + this.toInclude + ", merge=" + this.merge + ", usingDefaultInterval=" + this.usingDefaultInterval + ", analysisTypes=" + this.analysisTypes + ", lenientAggregatorMerge=" + this.lenientAggregatorMerge + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SegmentMetadataQuery that = (SegmentMetadataQuery)o;
        return this.merge == that.merge && this.usingDefaultInterval == that.usingDefaultInterval && this.lenientAggregatorMerge == that.lenientAggregatorMerge && Objects.equals(this.toInclude, that.toInclude) && Objects.equals(this.analysisTypes, that.analysisTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.toInclude, this.merge, this.usingDefaultInterval, this.analysisTypes, this.lenientAggregatorMerge);
    }

    public static enum AnalysisType {
        CARDINALITY,
        SIZE,
        INTERVAL,
        AGGREGATORS,
        MINMAX,
        TIMESTAMPSPEC,
        QUERYGRANULARITY,
        ROLLUP;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static AnalysisType fromString(String name) {
            return AnalysisType.valueOf(name.toUpperCase());
        }

        public byte[] getCacheKey() {
            return new byte[]{(byte)this.ordinal()};
        }
    }
}

