/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.strategy;

import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.common.guava.nary.BinaryFn;
import org.apache.hive.druid.io.druid.collections.BlockingPool;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.granularity.QueryGranularities;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.guice.annotations.Merging;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.ResultMergeQueryRunner;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.GroupByBinaryFnV2;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.GroupByMergingQueryRunnerV2;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.GroupByQueryEngineV2;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.GroupByRowProcessor;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategy;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.joda.time.DateTime;

public class GroupByStrategyV2
implements GroupByStrategy {
    public static final String CTX_KEY_FUDGE_TIMESTAMP = "fudgeTimestamp";
    private final DruidProcessingConfig processingConfig;
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final StupidPool<ByteBuffer> bufferPool;
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final ObjectMapper spillMapper;
    private final QueryWatcher queryWatcher;

    @Inject
    public GroupByStrategyV2(DruidProcessingConfig processingConfig, Supplier<GroupByQueryConfig> configSupplier, @Global StupidPool<ByteBuffer> bufferPool, @Merging BlockingPool<ByteBuffer> mergeBufferPool, @Smile ObjectMapper spillMapper, QueryWatcher queryWatcher) {
        this.processingConfig = processingConfig;
        this.configSupplier = configSupplier;
        this.bufferPool = bufferPool;
        this.mergeBufferPool = mergeBufferPool;
        this.spillMapper = spillMapper;
        this.queryWatcher = queryWatcher;
    }

    public static DateTime getUniversalTimestamp(GroupByQuery query) {
        QueryGranularity gran = query.getGranularity();
        String timestampStringFromContext = query.getContextValue(CTX_KEY_FUDGE_TIMESTAMP, "");
        if (!timestampStringFromContext.isEmpty()) {
            return new DateTime(Long.parseLong(timestampStringFromContext));
        }
        if (QueryGranularities.ALL.equals(gran)) {
            long timeStart = query.getIntervals().get(0).getStartMillis();
            return new DateTime((Object)gran.iterable(timeStart, timeStart + 1L).iterator().next());
        }
        return null;
    }

    @Override
    public Sequence<Row> mergeResults(QueryRunner<Row> baseRunner, final GroupByQuery query, Map<String, Object> responseContext) {
        ResultMergeQueryRunner<Row> mergingQueryRunner = new ResultMergeQueryRunner<Row>(baseRunner){

            @Override
            protected Ordering<Row> makeOrdering(Query<Row> queryParam) {
                return ((GroupByQuery)queryParam).getRowOrdering(true);
            }

            @Override
            protected BinaryFn<Row, Row, Row> createMergeFn(Query<Row> queryParam) {
                return new GroupByBinaryFnV2((GroupByQuery)queryParam);
            }
        };
        DateTime fudgeTimestamp = GroupByStrategyV2.getUniversalTimestamp(query);
        return query.applyLimit(Sequences.map(mergingQueryRunner.run(new GroupByQuery(query.getDataSource(), query.getQuerySegmentSpec(), query.getDimFilter(), query.getGranularity(), query.getDimensions(), query.getAggregatorSpecs(), ImmutableList.of(), null, null, query.getContext()).withOverriddenContext(ImmutableMap.of("finalize", false, "groupByStrategy", "v2", CTX_KEY_FUDGE_TIMESTAMP, fudgeTimestamp == null ? "" : String.valueOf(fudgeTimestamp.getMillis()))), responseContext), new Function<Row, Row>(){

            @Override
            public Row apply(Row row) {
                Map<String, Object> newMap;
                if (query.getPostAggregatorSpecs().isEmpty()) {
                    return row;
                }
                if (query.getPostAggregatorSpecs().isEmpty()) {
                    newMap = ((MapBasedRow)row).getEvent();
                } else {
                    newMap = Maps.newLinkedHashMap(((MapBasedRow)row).getEvent());
                    for (PostAggregator postAggregator : query.getPostAggregatorSpecs()) {
                        newMap.put(postAggregator.getName(), postAggregator.compute(newMap));
                    }
                }
                return new MapBasedRow(row.getTimestamp(), newMap);
            }
        }));
    }

    @Override
    public Sequence<Row> processSubqueryResult(GroupByQuery subquery, GroupByQuery query, Sequence<Row> subqueryResult) {
        final Sequence<Row> results = GroupByRowProcessor.process(query, subqueryResult, this.configSupplier.get(), this.mergeBufferPool, this.spillMapper);
        return this.mergeResults(new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(Query<Row> query, Map<String, Object> responseContext) {
                return results;
            }
        }, query, null);
    }

    @Override
    public QueryRunner<Row> mergeRunners(ListeningExecutorService exec, Iterable<QueryRunner<Row>> queryRunners) {
        return new GroupByMergingQueryRunnerV2(this.configSupplier.get(), exec, this.queryWatcher, queryRunners, this.processingConfig.getNumThreads(), this.mergeBufferPool, this.spillMapper);
    }

    @Override
    public Sequence<Row> process(GroupByQuery query, StorageAdapter storageAdapter) {
        return GroupByQueryEngineV2.process(query, storageAdapter, this.bufferPool, this.configSupplier.get());
    }
}

