/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.orderby;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.LimitSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.hive.druid.io.druid.query.groupby.orderby.TopNSequence;
import org.apache.hive.druid.io.druid.query.ordering.StringComparator;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;

public class DefaultLimitSpec
implements LimitSpec {
    private static final byte CACHE_KEY = 1;
    private final List<OrderByColumnSpec> columns;
    private final int limit;

    @JsonCreator
    public DefaultLimitSpec(@JsonProperty(value="columns") List<OrderByColumnSpec> columns, @JsonProperty(value="limit") Integer limit) {
        this.columns = columns == null ? ImmutableList.of() : columns;
        this.limit = limit == null ? Integer.MAX_VALUE : limit;
        Preconditions.checkArgument(this.limit > 0, "limit[%s] must be >0", limit);
    }

    @JsonProperty
    public List<OrderByColumnSpec> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public int getLimit() {
        return this.limit;
    }

    @Override
    public Function<Sequence<Row>, Sequence<Row>> build(List<DimensionSpec> dimensions, List<AggregatorFactory> aggs, List<PostAggregator> postAggs) {
        boolean sortingNeeded = false;
        if (dimensions.size() < this.columns.size()) {
            sortingNeeded = true;
        }
        HashSet<String> aggAndPostAggNames = Sets.newHashSet();
        for (AggregatorFactory agg : aggs) {
            aggAndPostAggNames.add(agg.getName());
        }
        for (PostAggregator postAgg : postAggs) {
            aggAndPostAggNames.add(postAgg.getName());
        }
        if (!sortingNeeded) {
            for (int i = 0; i < this.columns.size(); ++i) {
                OrderByColumnSpec columnSpec = this.columns.get(i);
                if (columnSpec.getDirection() == OrderByColumnSpec.Direction.ASCENDING && columnSpec.getDimensionComparator().equals(StringComparators.LEXICOGRAPHIC) && columnSpec.getDimension().equals(dimensions.get(i).getOutputName()) && !aggAndPostAggNames.contains(columnSpec.getDimension())) continue;
                sortingNeeded = true;
                break;
            }
        }
        if (!sortingNeeded) {
            return this.limit == Integer.MAX_VALUE ? Functions.identity() : new LimitingFn(this.limit);
        }
        Ordering<Row> ordering = this.makeComparator(dimensions, aggs, postAggs);
        if (this.limit == Integer.MAX_VALUE) {
            return new SortingFn(ordering);
        }
        return new TopNFunction(ordering, this.limit);
    }

    @Override
    public LimitSpec merge(LimitSpec other) {
        return this;
    }

    private Ordering<Row> makeComparator(List<DimensionSpec> dimensions, List<AggregatorFactory> aggs, List<PostAggregator> postAggs) {
        Ordering<Row> ordering = new Ordering<Row>(){

            @Override
            public int compare(Row left, Row right) {
                return Longs.compare(left.getTimestampFromEpoch(), right.getTimestampFromEpoch());
            }
        };
        HashMap<String, DimensionSpec> dimensionsMap = Maps.newHashMap();
        for (DimensionSpec dimensionSpec : dimensions) {
            dimensionsMap.put(dimensionSpec.getOutputName(), dimensionSpec);
        }
        HashMap<String, AggregatorFactory> aggregatorsMap = Maps.newHashMap();
        for (AggregatorFactory agg : aggs) {
            aggregatorsMap.put(agg.getName(), agg);
        }
        HashMap<String, PostAggregator> hashMap = Maps.newHashMap();
        for (PostAggregator postAgg : postAggs) {
            hashMap.put(postAgg.getName(), postAgg);
        }
        for (OrderByColumnSpec columnSpec : this.columns) {
            String columnName = columnSpec.getDimension();
            Ordering<Row> nextOrdering = null;
            if (hashMap.containsKey(columnName)) {
                nextOrdering = this.metricOrdering(columnName, ((PostAggregator)hashMap.get(columnName)).getComparator());
            } else if (aggregatorsMap.containsKey(columnName)) {
                nextOrdering = this.metricOrdering(columnName, ((AggregatorFactory)aggregatorsMap.get(columnName)).getComparator());
            } else if (dimensionsMap.containsKey(columnName)) {
                nextOrdering = this.dimensionOrdering(columnName, columnSpec.getDimensionComparator());
            }
            if (nextOrdering == null) {
                throw new ISE("Unknown column in order clause[%s]", columnSpec);
            }
            switch (columnSpec.getDirection()) {
                case DESCENDING: {
                    nextOrdering = nextOrdering.reverse();
                }
            }
            ordering = ordering.compound(nextOrdering);
        }
        return ordering;
    }

    private Ordering<Row> metricOrdering(final String column, final Comparator comparator) {
        return new Ordering<Row>(){

            @Override
            public int compare(Row left, Row right) {
                return comparator.compare(left.getRaw(column), right.getRaw(column));
            }
        };
    }

    private Ordering<Row> dimensionOrdering(final String dimension, StringComparator comparator) {
        return Ordering.from(comparator).nullsFirst().onResultOf(new Function<Row, String>(){

            @Override
            public String apply(Row input) {
                List<String> dimList = input.getDimension(dimension);
                return dimList.isEmpty() ? null : dimList.get(0);
            }
        });
    }

    public String toString() {
        return "DefaultLimitSpec{columns='" + this.columns + '\'' + ", limit=" + this.limit + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLimitSpec that = (DefaultLimitSpec)o;
        if (this.limit != that.limit) {
            return false;
        }
        return !(this.columns != null ? !this.columns.equals(that.columns) : that.columns != null);
    }

    public int hashCode() {
        int result = this.columns != null ? this.columns.hashCode() : 0;
        result = 31 * result + this.limit;
        return result;
    }

    @Override
    public byte[] getCacheKey() {
        byte[][] columnBytes = new byte[this.columns.size()][];
        int columnsBytesSize = 0;
        int index = 0;
        for (OrderByColumnSpec column : this.columns) {
            columnBytes[index] = column.getCacheKey();
            columnsBytesSize += columnBytes[index].length;
            ++index;
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + columnsBytesSize + 4).put((byte)1);
        for (byte[] columnByte : columnBytes) {
            buffer.put(columnByte);
        }
        buffer.put(Ints.toByteArray(this.limit));
        return buffer.array();
    }

    private static class TopNFunction
    implements Function<Sequence<Row>, Sequence<Row>> {
        private final Ordering<Row> ordering;
        private final int limit;

        public TopNFunction(Ordering<Row> ordering, int limit) {
            this.ordering = ordering;
            this.limit = limit;
        }

        @Override
        public Sequence<Row> apply(Sequence<Row> input) {
            return new TopNSequence<Row>(input, this.ordering, this.limit);
        }
    }

    private static class SortingFn
    implements Function<Sequence<Row>, Sequence<Row>> {
        private final Ordering<Row> ordering;

        public SortingFn(Ordering<Row> ordering) {
            this.ordering = ordering;
        }

        @Override
        public Sequence<Row> apply(@Nullable Sequence<Row> input) {
            return Sequences.sort(input, this.ordering);
        }
    }

    private static class LimitingFn
    implements Function<Sequence<Row>, Sequence<Row>> {
        private int limit;

        public LimitingFn(int limit) {
            this.limit = limit;
        }

        @Override
        public Sequence<Row> apply(Sequence<Row> input) {
            return Sequences.limit(input, this.limit);
        }
    }
}

