/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Groupers;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;

public class BufferGrouper<KeyType extends Comparable<KeyType>>
implements Grouper<KeyType> {
    private static final Logger log = new Logger(BufferGrouper.class);
    private static final int MIN_INITIAL_BUCKETS = 4;
    private static final int DEFAULT_INITIAL_BUCKETS = 1024;
    private static final float DEFAULT_MAX_LOAD_FACTOR = 0.7f;
    private static final int HASH_SIZE = 4;
    private final ByteBuffer buffer;
    private final Grouper.KeySerde<KeyType> keySerde;
    private final int keySize;
    private final BufferAggregator[] aggregators;
    private final int[] aggregatorOffsets;
    private final int initialBuckets;
    private final int bucketSize;
    private final int tableArenaSize;
    private final int bufferGrouperMaxSize;
    private final float maxLoadFactor;
    private ByteBuffer tableBuffer;
    private int tableStart;
    private int buckets;
    private int size;
    private int maxSize;

    public BufferGrouper(ByteBuffer buffer, Grouper.KeySerde<KeyType> keySerde, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, int bufferGrouperMaxSize, float maxLoadFactor, int initialBuckets) {
        this.buffer = buffer;
        this.keySerde = keySerde;
        this.keySize = keySerde.keySize();
        this.aggregators = new BufferAggregator[aggregatorFactories.length];
        this.aggregatorOffsets = new int[aggregatorFactories.length];
        this.bufferGrouperMaxSize = bufferGrouperMaxSize;
        this.maxLoadFactor = maxLoadFactor > 0.0f ? maxLoadFactor : 0.7f;
        int n = this.initialBuckets = initialBuckets > 0 ? Math.max(4, initialBuckets) : 1024;
        if (this.maxLoadFactor >= 1.0f) {
            throw new IAE("Invalid maxLoadFactor[%f], must be < 1.0", Float.valueOf(maxLoadFactor));
        }
        int offset = 4 + this.keySize;
        for (int i = 0; i < aggregatorFactories.length; ++i) {
            this.aggregators[i] = aggregatorFactories[i].factorizeBuffered(columnSelectorFactory);
            this.aggregatorOffsets[i] = offset;
            offset += aggregatorFactories[i].getMaxIntermediateSize();
        }
        this.bucketSize = offset;
        this.tableArenaSize = buffer.capacity() / (this.bucketSize + 4) * this.bucketSize;
        this.reset();
    }

    @Override
    public boolean aggregate(KeyType key, int keyHash) {
        int i;
        ByteBuffer keyBuffer = this.keySerde.toByteBuffer(key);
        if (keyBuffer == null) {
            return false;
        }
        Preconditions.checkArgument(keyBuffer.remaining() == this.keySize, "keySerde.toByteBuffer(key).remaining[%s] != keySerde.keySize[%s], buffer was the wrong size?!", keyBuffer.remaining(), this.keySize);
        int bucket = BufferGrouper.findBucket(this.tableBuffer, this.buckets, this.bucketSize, this.size < Math.min(this.maxSize, this.bufferGrouperMaxSize), keyBuffer, this.keySize, keyHash);
        if (bucket < 0) {
            if (this.size < this.bufferGrouperMaxSize) {
                this.growIfPossible();
                bucket = BufferGrouper.findBucket(this.tableBuffer, this.buckets, this.bucketSize, this.size < this.maxSize, keyBuffer, this.keySize, keyHash);
            }
            if (bucket < 0) {
                return false;
            }
        }
        int offset = bucket * this.bucketSize;
        if (!this.isUsed(bucket)) {
            this.tableBuffer.position(offset);
            this.tableBuffer.putInt(keyHash | Integer.MIN_VALUE);
            this.tableBuffer.put(keyBuffer);
            for (i = 0; i < this.aggregators.length; ++i) {
                this.aggregators[i].init(this.tableBuffer, offset + this.aggregatorOffsets[i]);
            }
            this.buffer.putInt(this.tableArenaSize + this.size * 4, offset);
            ++this.size;
        }
        for (i = 0; i < this.aggregators.length; ++i) {
            this.aggregators[i].aggregate(this.tableBuffer, offset + this.aggregatorOffsets[i]);
        }
        return true;
    }

    @Override
    public boolean aggregate(KeyType key) {
        return this.aggregate(key, Groupers.hash(key));
    }

    @Override
    public void reset() {
        int nextTableStart;
        this.size = 0;
        this.buckets = Math.min(this.tableArenaSize / this.bucketSize, this.initialBuckets);
        this.maxSize = this.maxSizeForBuckets(this.buckets);
        if (this.buckets < 1) {
            throw new IAE("Not enough capacity for even one row! Need[%,d] but have[%,d].", this.bucketSize + 4, this.buffer.capacity());
        }
        this.tableStart = this.tableArenaSize - this.buckets * this.bucketSize;
        int nextBuckets = this.buckets * 2;
        while ((nextTableStart = this.tableStart - nextBuckets * this.bucketSize) > this.tableArenaSize / 2) {
            this.tableStart = nextTableStart;
            nextBuckets *= 2;
        }
        if (this.tableStart < this.tableArenaSize / 2) {
            this.tableStart = 0;
        }
        ByteBuffer bufferDup = this.buffer.duplicate();
        bufferDup.position(this.tableStart);
        bufferDup.limit(this.tableStart + this.buckets * this.bucketSize);
        this.tableBuffer = bufferDup.slice();
        for (int i = 0; i < this.buckets; ++i) {
            this.tableBuffer.put(i * this.bucketSize, (byte)0);
        }
        this.keySerde.reset();
    }

    @Override
    public Iterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        if (sorted) {
            final AbstractList<Integer> wrappedOffsets = new AbstractList<Integer>(){

                @Override
                public Integer get(int index) {
                    return BufferGrouper.this.buffer.getInt(BufferGrouper.this.tableArenaSize + index * 4);
                }

                @Override
                public Integer set(int index, Integer element) {
                    Integer oldValue = this.get(index);
                    BufferGrouper.this.buffer.putInt(BufferGrouper.this.tableArenaSize + index * 4, element);
                    return oldValue;
                }

                @Override
                public int size() {
                    return BufferGrouper.this.size;
                }
            };
            final Grouper.KeyComparator comparator = this.keySerde.comparator();
            Collections.sort(wrappedOffsets, new Comparator<Integer>(){

                @Override
                public int compare(Integer lhs, Integer rhs) {
                    return comparator.compare(BufferGrouper.this.tableBuffer, BufferGrouper.this.tableBuffer, lhs + 4, rhs + 4);
                }
            });
            return new Iterator<Grouper.Entry<KeyType>>(){
                int curr = 0;

                @Override
                public boolean hasNext() {
                    return this.curr < BufferGrouper.this.size;
                }

                @Override
                public Grouper.Entry<KeyType> next() {
                    return BufferGrouper.this.bucketEntryForOffset((Integer)wrappedOffsets.get(this.curr++));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<Grouper.Entry<KeyType>>(){
            int curr = 0;

            @Override
            public boolean hasNext() {
                return this.curr < BufferGrouper.this.size;
            }

            @Override
            public Grouper.Entry<KeyType> next() {
                int offset = BufferGrouper.this.buffer.getInt(BufferGrouper.this.tableArenaSize + this.curr * 4);
                Grouper.Entry entry = BufferGrouper.this.bucketEntryForOffset(offset);
                ++this.curr;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() {
        for (BufferAggregator aggregator : this.aggregators) {
            try {
                aggregator.close();
            }
            catch (Exception e) {
                log.warn(e, "Could not close aggregator, skipping.", aggregator);
            }
        }
    }

    private boolean isUsed(int bucket) {
        return (this.tableBuffer.get(bucket * this.bucketSize) & 0x80) == 128;
    }

    private Grouper.Entry<KeyType> bucketEntryForOffset(int bucketOffset) {
        Comparable key = (Comparable)this.keySerde.fromByteBuffer(this.tableBuffer, bucketOffset + 4);
        Object[] values = new Object[this.aggregators.length];
        for (int i = 0; i < this.aggregators.length; ++i) {
            values[i] = this.aggregators[i].get(this.tableBuffer, bucketOffset + this.aggregatorOffsets[i]);
        }
        return new Grouper.Entry<Comparable>(key, values);
    }

    private void growIfPossible() {
        int newMaxSize;
        int newBuckets;
        int newTableStart;
        if (this.tableStart == 0) {
            return;
        }
        if (this.tableStart + this.buckets * 3 * this.bucketSize > this.tableArenaSize) {
            newTableStart = 0;
            newBuckets = this.tableStart / this.bucketSize;
            newMaxSize = this.maxSizeForBuckets(newBuckets);
        } else {
            newTableStart = this.tableStart + this.tableBuffer.limit();
            newBuckets = this.buckets * 2;
            newMaxSize = this.maxSizeForBuckets(newBuckets);
        }
        if (newBuckets < this.buckets) {
            throw new ISE("WTF?! newBuckets[%,d] < buckets[%,d]", newBuckets, this.buckets);
        }
        ByteBuffer newTableBuffer = this.buffer.duplicate();
        newTableBuffer.position(newTableStart);
        newTableBuffer.limit(newTableStart + newBuckets * this.bucketSize);
        newTableBuffer = newTableBuffer.slice();
        int newSize = 0;
        for (int i = 0; i < newBuckets; ++i) {
            newTableBuffer.put(i * this.bucketSize, (byte)0);
        }
        ByteBuffer entryBuffer = this.tableBuffer.duplicate();
        ByteBuffer keyBuffer = this.tableBuffer.duplicate();
        for (int oldBucket = 0; oldBucket < this.buckets; ++oldBucket) {
            if (!this.isUsed(oldBucket)) continue;
            entryBuffer.limit((oldBucket + 1) * this.bucketSize);
            entryBuffer.position(oldBucket * this.bucketSize);
            keyBuffer.limit(entryBuffer.position() + 4 + this.keySize);
            keyBuffer.position(entryBuffer.position() + 4);
            int keyHash = entryBuffer.getInt(entryBuffer.position()) & Integer.MAX_VALUE;
            int newBucket = BufferGrouper.findBucket(newTableBuffer, newBuckets, this.bucketSize, true, keyBuffer, this.keySize, keyHash);
            if (newBucket < 0) {
                throw new ISE("WTF?! Couldn't find a bucket while resizing?!", new Object[0]);
            }
            newTableBuffer.position(newBucket * this.bucketSize);
            newTableBuffer.put(entryBuffer);
            this.buffer.putInt(this.tableArenaSize + newSize * 4, newBucket * this.bucketSize);
            ++newSize;
        }
        this.buckets = newBuckets;
        this.maxSize = newMaxSize;
        this.tableBuffer = newTableBuffer;
        this.tableStart = newTableStart;
        if (this.size != newSize) {
            throw new ISE("WTF?! size[%,d] != newSize[%,d] after resizing?!", this.size, this.maxSize);
        }
    }

    private int maxSizeForBuckets(int buckets) {
        return Math.max(1, (int)((float)buckets * this.maxLoadFactor));
    }

    private static int findBucket(ByteBuffer tableBuffer, int buckets, int bucketSize, boolean allowNewBucket, ByteBuffer keyBuffer, int keySize, int keyHash) {
        int startBucket;
        int bucket = startBucket = keyHash % buckets;
        block0: while (true) {
            int bucketOffset;
            if ((tableBuffer.get(bucketOffset = bucket * bucketSize) & 0x80) == 0) {
                return allowNewBucket ? bucket : -1;
            }
            int i = bucketOffset + 4;
            for (int j = keyBuffer.position(); j < keyBuffer.position() + keySize; ++j) {
                if (tableBuffer.get(i) != keyBuffer.get(j)) {
                    if (++bucket == buckets) {
                        bucket = 0;
                    }
                    if (bucket != startBucket) continue block0;
                    return -1;
                }
                ++i;
            }
            break;
        }
        return bucket;
    }
}

