/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import java.nio.ByteBuffer;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.metamx.collections.spatial.search.Bound;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.segment.filter.SpatialFilter;

public class SpatialDimFilter
implements DimFilter {
    private final String dimension;
    private final Bound bound;

    @JsonCreator
    public SpatialDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="bound") Bound bound) {
        Preconditions.checkArgument(dimension != null, "dimension must not be null");
        Preconditions.checkArgument(bound != null, "bound must not be null");
        this.dimension = dimension;
        this.bound = bound;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimBytes = StringUtils.toUtf8(this.dimension);
        byte[] boundBytes = this.bound.getCacheKey();
        return ByteBuffer.allocate(2 + dimBytes.length + boundBytes.length).put((byte)8).put(dimBytes).put((byte)-1).put(boundBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public Bound getBound() {
        return this.bound;
    }

    @Override
    public Filter toFilter() {
        return new SpatialFilter(this.dimension, this.bound);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpatialDimFilter that = (SpatialDimFilter)o;
        if (this.bound != null ? !this.bound.equals(that.bound) : that.bound != null) {
            return false;
        }
        return !(this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.bound != null ? this.bound.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SpatialDimFilter{dimension='" + this.dimension + '\'' + ", bound=" + this.bound + '}';
    }
}

