/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.BoundType;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.google.common.collect.TreeRangeSet;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.ordering.StringComparator;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.segment.filter.BoundFilter;

public class BoundDimFilter
implements DimFilter {
    private final String dimension;
    private final String upper;
    private final String lower;
    private final boolean lowerStrict;
    private final boolean upperStrict;
    private final ExtractionFn extractionFn;
    private final StringComparator ordering;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;

    @JsonCreator
    public BoundDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="lower") String lower, @JsonProperty(value="upper") String upper, @JsonProperty(value="lowerStrict") Boolean lowerStrict, @JsonProperty(value="upperStrict") Boolean upperStrict, @Deprecated @JsonProperty(value="alphaNumeric") Boolean alphaNumeric, @JsonProperty(value="extractionFn") ExtractionFn extractionFn, @JsonProperty(value="ordering") StringComparator ordering) {
        this.dimension = Preconditions.checkNotNull(dimension, "dimension can not be null");
        Preconditions.checkState(lower != null || upper != null, "lower and upper can not be null at the same time");
        this.upper = upper;
        this.lower = lower;
        this.lowerStrict = lowerStrict == null ? false : lowerStrict;
        boolean bl = this.upperStrict = upperStrict == null ? false : upperStrict;
        if (ordering == null) {
            this.ordering = alphaNumeric == null || !alphaNumeric.booleanValue() ? StringComparators.LEXICOGRAPHIC : StringComparators.ALPHANUMERIC;
        } else {
            this.ordering = ordering;
            if (alphaNumeric != null) {
                boolean orderingIsAlphanumeric = this.ordering.equals(StringComparators.ALPHANUMERIC);
                Preconditions.checkState(alphaNumeric == orderingIsAlphanumeric, "mismatch between alphanumeric and ordering property");
            }
        }
        this.extractionFn = extractionFn;
        this.longPredicateSupplier = this.makeLongPredicateSupplier();
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getUpper() {
        return this.upper;
    }

    @JsonProperty
    public String getLower() {
        return this.lower;
    }

    @JsonProperty
    public boolean isLowerStrict() {
        return this.lowerStrict;
    }

    @JsonProperty
    public boolean isUpperStrict() {
        return this.upperStrict;
    }

    public boolean hasLowerBound() {
        return this.lower != null;
    }

    public boolean hasUpperBound() {
        return this.upper != null;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @JsonProperty
    public StringComparator getOrdering() {
        return this.ordering;
    }

    public Supplier<DruidLongPredicate> getLongPredicateSupplier() {
        return this.longPredicateSupplier;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.getDimension());
        byte[] lowerBytes = this.getLower() == null ? new byte[]{} : StringUtils.toUtf8(this.getLower());
        byte[] upperBytes = this.getUpper() == null ? new byte[]{} : StringUtils.toUtf8(this.getUpper());
        byte boundType = 1;
        if (this.getLower() == null) {
            boundType = 2;
        } else if (this.getUpper() == null) {
            boundType = 3;
        }
        byte lowerStrictByte = !this.isLowerStrict() ? (byte)0 : 1;
        byte upperStrictByte = !this.isUpperStrict() ? (byte)0 : 1;
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        byte[] orderingBytes = this.ordering.getCacheKey();
        ByteBuffer boundCacheBuffer = ByteBuffer.allocate(9 + dimensionBytes.length + upperBytes.length + lowerBytes.length + extractionFnBytes.length + orderingBytes.length);
        boundCacheBuffer.put((byte)10).put(boundType).put(upperStrictByte).put(lowerStrictByte).put((byte)-1).put(dimensionBytes).put((byte)-1).put(upperBytes).put((byte)-1).put(lowerBytes).put((byte)-1).put(extractionFnBytes).put((byte)-1).put(orderingBytes);
        return boundCacheBuffer.array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new BoundFilter(this);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null || !this.ordering.equals(StringComparators.LEXICOGRAPHIC)) {
            return null;
        }
        TreeRangeSet<String> retSet = TreeRangeSet.create();
        Range<String> range = this.getLower() == null ? (this.isUpperStrict() ? Range.lessThan(this.getUpper()) : Range.atMost(this.getUpper())) : (this.getUpper() == null ? (this.isLowerStrict() ? Range.greaterThan(this.getLower()) : Range.atLeast(this.getLower())) : Range.range(this.getLower(), this.isLowerStrict() ? BoundType.OPEN : BoundType.CLOSED, this.getUpper(), this.isUpperStrict() ? BoundType.OPEN : BoundType.CLOSED));
        retSet.add(range);
        return retSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundDimFilter that = (BoundDimFilter)o;
        if (this.isLowerStrict() != that.isLowerStrict()) {
            return false;
        }
        if (this.isUpperStrict() != that.isUpperStrict()) {
            return false;
        }
        if (!this.getDimension().equals(that.getDimension())) {
            return false;
        }
        if (this.getUpper() != null ? !this.getUpper().equals(that.getUpper()) : that.getUpper() != null) {
            return false;
        }
        if (this.getLower() != null ? !this.getLower().equals(that.getLower()) : that.getLower() != null) {
            return false;
        }
        if (this.getExtractionFn() != null ? !this.getExtractionFn().equals(that.getExtractionFn()) : that.getExtractionFn() != null) {
            return false;
        }
        return this.getOrdering().equals(that.getOrdering());
    }

    public int hashCode() {
        int result = this.getDimension().hashCode();
        result = 31 * result + (this.getUpper() != null ? this.getUpper().hashCode() : 0);
        result = 31 * result + (this.getLower() != null ? this.getLower().hashCode() : 0);
        result = 31 * result + (this.isLowerStrict() ? 1 : 0);
        result = 31 * result + (this.isUpperStrict() ? 1 : 0);
        result = 31 * result + (this.getExtractionFn() != null ? this.getExtractionFn().hashCode() : 0);
        result = 31 * result + this.getOrdering().hashCode();
        return result;
    }

    private Supplier<DruidLongPredicate> makeLongPredicateSupplier() {
        return new Supplier<DruidLongPredicate>(){
            private final Object initLock = new Object();
            private volatile boolean longsInitialized = false;
            private volatile boolean hasLowerLongBoundVolatile;
            private volatile boolean hasUpperLongBoundVolatile;
            private volatile long lowerLongBoundVolatile;
            private volatile long upperLongBoundVolatile;

            @Override
            public DruidLongPredicate get() {
                this.initLongData();
                return new DruidLongPredicate(){
                    private final boolean hasLowerLongBound;
                    private final boolean hasUpperLongBound;
                    private final long lowerLongBound;
                    private final long upperLongBound;
                    {
                        this.hasLowerLongBound = hasLowerLongBoundVolatile;
                        this.hasUpperLongBound = hasUpperLongBoundVolatile;
                        this.lowerLongBound = this.hasLowerLongBound ? lowerLongBoundVolatile : 0L;
                        this.upperLongBound = this.hasUpperLongBound ? upperLongBoundVolatile : 0L;
                    }

                    @Override
                    public boolean applyLong(long input) {
                        int lowerComparing = 1;
                        int upperComparing = 1;
                        if (this.hasLowerLongBound) {
                            lowerComparing = Long.compare(input, this.lowerLongBound);
                        }
                        if (this.hasUpperLongBound) {
                            upperComparing = Long.compare(this.upperLongBound, input);
                        }
                        if (BoundDimFilter.this.lowerStrict && BoundDimFilter.this.upperStrict) {
                            return lowerComparing > 0 && upperComparing > 0;
                        }
                        if (BoundDimFilter.this.lowerStrict) {
                            return lowerComparing > 0 && upperComparing >= 0;
                        }
                        if (BoundDimFilter.this.upperStrict) {
                            return lowerComparing >= 0 && upperComparing > 0;
                        }
                        return lowerComparing >= 0 && upperComparing >= 0;
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void initLongData() {
                if (this.longsInitialized) {
                    return;
                }
                Object object = this.initLock;
                synchronized (object) {
                    if (this.longsInitialized) {
                        return;
                    }
                    Long lowerLong = Longs.tryParse(Strings.nullToEmpty(BoundDimFilter.this.lower));
                    if (BoundDimFilter.this.hasLowerBound() && lowerLong != null) {
                        this.hasLowerLongBoundVolatile = true;
                        this.lowerLongBoundVolatile = lowerLong;
                    } else {
                        this.hasLowerLongBoundVolatile = false;
                    }
                    Long upperLong = Longs.tryParse(Strings.nullToEmpty(BoundDimFilter.this.upper));
                    if (BoundDimFilter.this.hasUpperBound() && upperLong != null) {
                        this.hasUpperLongBoundVolatile = true;
                        this.upperLongBoundVolatile = upperLong;
                    } else {
                        this.hasUpperLongBoundVolatile = false;
                    }
                    this.longsInitialized = true;
                }
            }
        };
    }
}

