/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.post;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptPostAggregator
implements PostAggregator {
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return ((Double)o).compareTo((Double)o1);
        }
    };
    private final String name;
    private final List<String> fieldNames;
    private final String function;
    private final Function fn;

    private static Function compile(String function) {
        final ContextFactory contextFactory = ContextFactory.getGlobal();
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(9);
        final ScriptableObject scope = context.initStandardObjects();
        final org.mozilla.javascript.Function fn = context.compileFunction((Scriptable)scope, function, "fn", 1, null);
        Context.exit();
        return new Function(){

            @Override
            public double apply(Object[] args) {
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = contextFactory.enterContext();
                }
                return Context.toNumber((Object)fn.call(cx, (Scriptable)scope, (Scriptable)scope, args));
            }
        };
    }

    @JsonCreator
    public JavaScriptPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="function") String function, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkNotNull(name, "Must have a valid, non-null post-aggregator name");
        Preconditions.checkNotNull(fieldNames, "Must have a valid, non-null fieldNames");
        Preconditions.checkNotNull(function, "Must have a valid, non-null function");
        this.name = name;
        this.fieldNames = fieldNames;
        this.function = function;
        this.fn = config.isDisabled() ? null : JavaScriptPostAggregator.compile(function);
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet(this.fieldNames);
    }

    @Override
    public Comparator getComparator() {
        return COMPARATOR;
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        if (this.fn == null) {
            throw new ISE("JavaScript is disabled", new Object[0]);
        }
        Object[] args = new Object[this.fieldNames.size()];
        int i = 0;
        for (String field : this.fieldNames) {
            args[i++] = combinedAggregators.get(field);
        }
        return this.fn.apply(args);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptPostAggregator that = (JavaScriptPostAggregator)o;
        if (this.fieldNames != null ? !this.fieldNames.equals(that.fieldNames) : that.fieldNames != null) {
            return false;
        }
        if (this.fn != null ? !this.fn.equals(that.fn) : that.fn != null) {
            return false;
        }
        if (this.function != null ? !this.function.equals(that.function) : that.function != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fieldNames != null ? this.fieldNames.hashCode() : 0);
        result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
        result = 31 * result + (this.fn != null ? this.fn.hashCode() : 0);
        return result;
    }

    private static interface Function {
        public double apply(Object[] var1);
    }
}

