/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.io.Closeable;
import java.util.Map;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.com.metamx.common.guava.ResourceClosingSequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.segment.ReferenceCountingSegment;

public class ReferenceCountingSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunnerFactory<T, Query<T>> factory;
    private final ReferenceCountingSegment adapter;
    private final SegmentDescriptor descriptor;

    public ReferenceCountingSegmentQueryRunner(QueryRunnerFactory<T, Query<T>> factory, ReferenceCountingSegment adapter, SegmentDescriptor descriptor) {
        this.factory = factory;
        this.adapter = adapter;
        this.descriptor = descriptor;
    }

    @Override
    public Sequence<T> run(Query<T> query, Map<String, Object> responseContext) {
        Closeable closeable = this.adapter.increment();
        if (closeable != null) {
            try {
                Sequence<T> baseSequence = this.factory.createRunner(this.adapter).run(query, responseContext);
                return new ResourceClosingSequence<T>(baseSequence, closeable);
            }
            catch (RuntimeException e) {
                CloseQuietly.close(closeable);
                throw e;
            }
        }
        return new ReportTimelineMissingSegmentQueryRunner<T>(this.descriptor).run(query, responseContext);
    }
}

