/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.math.expr;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.io.druid.math.expr.Expr;

interface Function {
    public String name();

    public Number apply(List<Expr> var1, Map<String, Number> var2);

    public static class ConditionFunc
    implements Function {
        @Override
        public String name() {
            return "if";
        }

        @Override
        public Number apply(List<Expr> args, Map<String, Number> bindings) {
            if (args.size() != 3) {
                throw new RuntimeException("function 'if' needs 3 argument");
            }
            Number x = args.get(0).eval(bindings);
            if (x instanceof Long) {
                return x.longValue() > 0L ? (Number)args.get(1).eval(bindings) : (Number)args.get(2).eval(bindings);
            }
            return x.doubleValue() > 0.0 ? (Number)args.get(1).eval(bindings) : (Number)args.get(2).eval(bindings);
        }
    }

    public static class Scalb
    extends DoubleParam {
        @Override
        public String name() {
            return "scalb";
        }

        @Override
        protected Number eval(Number x, Number y) {
            return Math.scalb(x.doubleValue(), y.intValue());
        }
    }

    public static class Pow
    extends DoubleParam {
        @Override
        public String name() {
            return "pow";
        }

        @Override
        protected Number eval(Number x, Number y) {
            return Math.pow(x.doubleValue(), y.doubleValue());
        }
    }

    public static class NextAfter
    extends DoubleParam {
        @Override
        public String name() {
            return "nextAfter";
        }

        @Override
        protected Number eval(Number x, Number y) {
            return Math.nextAfter(x.doubleValue(), y.doubleValue());
        }
    }

    public static class Min
    extends DoubleParam {
        @Override
        public String name() {
            return "min";
        }

        @Override
        protected Number eval(Number x, Number y) {
            if (x instanceof Long && y instanceof Long) {
                return Math.min(x.longValue(), y.longValue());
            }
            return Double.compare(x.doubleValue(), y.doubleValue()) <= 0 ? (Number)x : (Number)y;
        }
    }

    public static class Max
    extends DoubleParam {
        @Override
        public String name() {
            return "max";
        }

        @Override
        protected Number eval(Number x, Number y) {
            if (x instanceof Long && y instanceof Long) {
                return Math.max(x.longValue(), y.longValue());
            }
            return Double.compare(x.doubleValue(), y.doubleValue()) >= 0 ? (Number)x : (Number)y;
        }
    }

    public static class Remainder
    extends DoubleParam {
        @Override
        public String name() {
            return "remainder";
        }

        @Override
        protected Number eval(Number x, Number y) {
            return Math.IEEEremainder(x.doubleValue(), y.doubleValue());
        }
    }

    public static class Hypot
    extends DoubleParam {
        @Override
        public String name() {
            return "hypot";
        }

        @Override
        protected Number eval(Number x, Number y) {
            return Math.hypot(x.doubleValue(), y.doubleValue());
        }
    }

    public static class CopySign
    extends DoubleParam {
        @Override
        public String name() {
            return "copySign";
        }

        @Override
        protected Number eval(Number x, Number y) {
            return Math.copySign(x.doubleValue(), y.doubleValue());
        }
    }

    public static class Atan2
    extends DoubleParam {
        @Override
        public String name() {
            return "atan2";
        }

        @Override
        protected Number eval(Number x, Number y) {
            return Math.atan2(x.doubleValue(), y.doubleValue());
        }
    }

    public static class Ulp
    extends SingleParam {
        @Override
        public String name() {
            return "ulp";
        }

        @Override
        protected Number eval(Number x) {
            return Math.ulp(x.doubleValue());
        }
    }

    public static class ToRadians
    extends SingleParam {
        @Override
        public String name() {
            return "toRadians";
        }

        @Override
        protected Number eval(Number x) {
            return Math.toRadians(x.doubleValue());
        }
    }

    public static class ToDegrees
    extends SingleParam {
        @Override
        public String name() {
            return "toDegrees";
        }

        @Override
        protected Number eval(Number x) {
            return Math.toDegrees(x.doubleValue());
        }
    }

    public static class Tanh
    extends SingleParam {
        @Override
        public String name() {
            return "tanh";
        }

        @Override
        protected Number eval(Number x) {
            return Math.tanh(x.doubleValue());
        }
    }

    public static class Tan
    extends SingleParam {
        @Override
        public String name() {
            return "tan";
        }

        @Override
        protected Number eval(Number x) {
            return Math.tan(x.doubleValue());
        }
    }

    public static class Sqrt
    extends SingleParam {
        @Override
        public String name() {
            return "sqrt";
        }

        @Override
        protected Number eval(Number x) {
            return Math.sqrt(x.doubleValue());
        }
    }

    public static class Sinh
    extends SingleParam {
        @Override
        public String name() {
            return "sinh";
        }

        @Override
        protected Number eval(Number x) {
            return Math.sinh(x.doubleValue());
        }
    }

    public static class Sin
    extends SingleParam {
        @Override
        public String name() {
            return "sin";
        }

        @Override
        protected Number eval(Number x) {
            return Math.sin(x.doubleValue());
        }
    }

    public static class Signum
    extends SingleParam {
        @Override
        public String name() {
            return "signum";
        }

        @Override
        protected Number eval(Number x) {
            return Math.signum(x.doubleValue());
        }
    }

    public static class Round
    extends SingleParam {
        @Override
        public String name() {
            return "round";
        }

        @Override
        protected Number eval(Number x) {
            return Math.round(x.doubleValue());
        }
    }

    public static class Rint
    extends SingleParam {
        @Override
        public String name() {
            return "rint";
        }

        @Override
        protected Number eval(Number x) {
            return Math.rint(x.doubleValue());
        }
    }

    public static class NextUp
    extends SingleParam {
        @Override
        public String name() {
            return "nextUp";
        }

        @Override
        protected Number eval(Number x) {
            return Math.nextUp(x.doubleValue());
        }
    }

    public static class Log1p
    extends SingleParam {
        @Override
        public String name() {
            return "log1p";
        }

        @Override
        protected Number eval(Number x) {
            return Math.log1p(x.doubleValue());
        }
    }

    public static class Log10
    extends SingleParam {
        @Override
        public String name() {
            return "log10";
        }

        @Override
        protected Number eval(Number x) {
            return Math.log10(x.doubleValue());
        }
    }

    public static class Log
    extends SingleParam {
        @Override
        public String name() {
            return "log";
        }

        @Override
        protected Number eval(Number x) {
            return Math.log(x.doubleValue());
        }
    }

    public static class GetExponent
    extends SingleParam {
        @Override
        public String name() {
            return "getExponent";
        }

        @Override
        protected Number eval(Number x) {
            return Math.getExponent(x.doubleValue());
        }
    }

    public static class Floor
    extends SingleParam {
        @Override
        public String name() {
            return "floor";
        }

        @Override
        protected Number eval(Number x) {
            return Math.floor(x.doubleValue());
        }
    }

    public static class Expm1
    extends SingleParam {
        @Override
        public String name() {
            return "expm1";
        }

        @Override
        protected Number eval(Number x) {
            return Math.expm1(x.doubleValue());
        }
    }

    public static class Exp
    extends SingleParam {
        @Override
        public String name() {
            return "exp";
        }

        @Override
        protected Number eval(Number x) {
            return Math.exp(x.doubleValue());
        }
    }

    public static class Cosh
    extends SingleParam {
        @Override
        public String name() {
            return "cosh";
        }

        @Override
        protected Number eval(Number x) {
            return Math.cosh(x.doubleValue());
        }
    }

    public static class Cos
    extends SingleParam {
        @Override
        public String name() {
            return "cos";
        }

        @Override
        protected Number eval(Number x) {
            return Math.cos(x.doubleValue());
        }
    }

    public static class Ceil
    extends SingleParam {
        @Override
        public String name() {
            return "ceil";
        }

        @Override
        protected Number eval(Number x) {
            return Math.ceil(x.doubleValue());
        }
    }

    public static class Cbrt
    extends SingleParam {
        @Override
        public String name() {
            return "cbrt";
        }

        @Override
        protected Number eval(Number x) {
            return Math.cbrt(x.doubleValue());
        }
    }

    public static class Atan
    extends SingleParam {
        @Override
        public String name() {
            return "atan";
        }

        @Override
        protected Number eval(Number x) {
            return Math.atan(x.doubleValue());
        }
    }

    public static class Asin
    extends SingleParam {
        @Override
        public String name() {
            return "asin";
        }

        @Override
        protected Number eval(Number x) {
            return Math.asin(x.doubleValue());
        }
    }

    public static class Acos
    extends SingleParam {
        @Override
        public String name() {
            return "acos";
        }

        @Override
        protected Number eval(Number x) {
            return Math.acos(x.doubleValue());
        }
    }

    public static class Abs
    extends SingleParam {
        @Override
        public String name() {
            return "abs";
        }

        @Override
        protected Number eval(Number x) {
            return x instanceof Long ? (double)Math.abs(x.longValue()) : Math.abs(x.doubleValue());
        }
    }

    public static abstract class DoubleParam
    implements Function {
        @Override
        public Number apply(List<Expr> args, Map<String, Number> bindings) {
            if (args.size() != 2) {
                throw new RuntimeException("function '" + this.name() + "' needs 1 argument");
            }
            Expr expr1 = args.get(0);
            Expr expr2 = args.get(1);
            return this.eval(expr1.eval(bindings), expr2.eval(bindings));
        }

        protected abstract Number eval(Number var1, Number var2);
    }

    public static abstract class SingleParam
    implements Function {
        @Override
        public Number apply(List<Expr> args, Map<String, Number> bindings) {
            if (args.size() != 1) {
                throw new RuntimeException("function '" + this.name() + "' needs 1 argument");
            }
            Expr expr = args.get(0);
            return this.eval(expr.eval(bindings));
        }

        protected abstract Number eval(Number var1);
    }
}

