/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.granularity;

import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.io.druid.granularity.DurationGranularity;
import org.apache.hive.druid.io.druid.granularity.QueryGranularities;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;

public abstract class QueryGranularity {
    public abstract long next(long var1);

    public abstract long truncate(long var1);

    public abstract byte[] cacheKey();

    public abstract DateTime toDateTime(long var1);

    public abstract Iterable<Long> iterable(long var1, long var3);

    @JsonCreator
    public static QueryGranularity fromString(String str) {
        String name = str.toUpperCase();
        if (name.equals("ALL")) {
            return QueryGranularities.ALL;
        }
        if (name.equals("NONE")) {
            return QueryGranularities.NONE;
        }
        if (QueryGranularities.CALENDRIC_GRANULARITIES.containsKey(name)) {
            return QueryGranularities.CALENDRIC_GRANULARITIES.get(name);
        }
        return new DurationGranularity(QueryGranularity.convertValue(str), 0L);
    }

    private static long convertValue(Object o) {
        if (o instanceof String) {
            return MillisIn.valueOf(((String)o).toUpperCase()).millis;
        }
        if (o instanceof ReadableDuration) {
            return ((ReadableDuration)o).getMillis();
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new IAE("Cannot convert [%s] to QueryGranularity", o.getClass());
    }

    public static QueryGranularity mergeQueryGranularities(List<QueryGranularity> toMerge) {
        if (toMerge == null || toMerge.size() == 0) {
            return null;
        }
        QueryGranularity result = toMerge.get(0);
        for (int i = 1; i < toMerge.size(); ++i) {
            if (Objects.equals(result, toMerge.get(i))) continue;
            return null;
        }
        return result;
    }

    private static enum MillisIn {
        SECOND(1000L),
        MINUTE(60000L),
        FIFTEEN_MINUTE(900000L),
        THIRTY_MINUTE(1800000L),
        HOUR(3600000L),
        DAY(86400000L);

        private final long millis;

        private MillisIn(long millis) {
            this.millis = millis;
        }
    }
}

