/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.metamx.common.parsers.ParseException;
import org.apache.hive.druid.com.metamx.common.parsers.Parser;
import org.apache.hive.druid.io.druid.data.input.ByteBufferInputRowParser;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;

public class StringInputRowParser
implements ByteBufferInputRowParser {
    private static final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    private final ParseSpec parseSpec;
    private final MapInputRowParser mapParser;
    private final Parser<String, Object> parser;
    private final Charset charset;
    private CharBuffer chars = null;

    @JsonCreator
    public StringInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="encoding") String encoding) {
        this.parseSpec = parseSpec;
        this.mapParser = new MapInputRowParser(parseSpec);
        this.parser = parseSpec.makeParser();
        this.charset = encoding != null ? Charset.forName(encoding) : DEFAULT_CHARSET;
    }

    @Deprecated
    public StringInputRowParser(ParseSpec parseSpec) {
        this(parseSpec, null);
    }

    @Override
    public InputRow parse(ByteBuffer input) {
        return this.parseMap(this.buildStringKeyMap(input));
    }

    @Override
    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @JsonProperty
    public String getEncoding() {
        return this.charset.name();
    }

    @Override
    public StringInputRowParser withParseSpec(ParseSpec parseSpec) {
        return new StringInputRowParser(parseSpec, this.getEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> buildStringKeyMap(ByteBuffer input) {
        Map<String, Object> theMap;
        CoderResult coderResult;
        int payloadSize = input.remaining();
        if (this.chars == null || this.chars.remaining() < payloadSize) {
            this.chars = CharBuffer.allocate(payloadSize);
        }
        if ((coderResult = this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(input, this.chars, true)).isUnderflow()) {
            this.chars.flip();
            try {
                theMap = this.parseString(this.chars.toString());
            }
            finally {
                this.chars.clear();
            }
        } else {
            throw new ParseException("Failed with CoderResult[%s]", coderResult);
        }
        return theMap;
    }

    private Map<String, Object> parseString(String inputString) {
        return this.parser.parse(inputString);
    }

    @Override
    public InputRow parse(String input) {
        return this.parseMap(this.parseString(input));
    }

    private InputRow parseMap(Map<String, Object> theMap) {
        return this.mapParser.parse(theMap);
    }
}

