/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.io.LineIterator;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.data.input.Firehose;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.io.druid.utils.Runnables;

public class FileIteratingFirehose
implements Firehose {
    private final Iterator<LineIterator> lineIterators;
    private final StringInputRowParser parser;
    private LineIterator lineIterator = null;

    public FileIteratingFirehose(Iterator<LineIterator> lineIterators, StringInputRowParser parser) {
        this.lineIterators = lineIterators;
        this.parser = parser;
    }

    @Override
    public boolean hasMore() {
        while ((this.lineIterator == null || !this.lineIterator.hasNext()) && this.lineIterators.hasNext()) {
            this.lineIterator = this.lineIterators.next();
        }
        return this.lineIterator != null && this.lineIterator.hasNext();
    }

    @Override
    public InputRow nextRow() {
        try {
            if (this.lineIterator == null || !this.lineIterator.hasNext()) {
                if (this.lineIterator != null) {
                    this.lineIterator.close();
                }
                this.lineIterator = this.lineIterators.next();
            }
            return this.parser.parse(this.lineIterator.next());
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public Runnable commit() {
        return Runnables.getNoopRunnable();
    }

    @Override
    public void close() throws IOException {
        if (this.lineIterator != null) {
            this.lineIterator.close();
        }
    }
}

