/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl;

import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.metamx.common.parsers.CSVParser;
import org.apache.hive.druid.com.metamx.common.parsers.Parser;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;

public class CSVParseSpec
extends ParseSpec {
    private final String listDelimiter;
    private final List<String> columns;

    @JsonCreator
    public CSVParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="columns") List<String> columns) {
        super(timestampSpec, dimensionsSpec);
        this.listDelimiter = listDelimiter;
        Preconditions.checkNotNull(columns, "columns");
        for (String column : columns) {
            Preconditions.checkArgument(!column.contains(","), "Column[%s] has a comma, it cannot", column);
        }
        this.columns = columns;
        this.verify(dimensionsSpec.getDimensionNames());
    }

    @JsonProperty
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public void verify(List<String> usedCols) {
        for (String columnName : usedCols) {
            Preconditions.checkArgument(this.columns.contains(columnName), "column[%s] not in columns.", columnName);
        }
    }

    @Override
    public Parser<String, Object> makeParser() {
        return new CSVParser(Optional.fromNullable(this.listDelimiter), this.columns);
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new CSVParseSpec(spec, this.getDimensionsSpec(), this.listDelimiter, this.columns);
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new CSVParseSpec(this.getTimestampSpec(), spec, this.listDelimiter, this.columns);
    }

    public ParseSpec withColumns(List<String> cols) {
        return new CSVParseSpec(this.getTimestampSpec(), this.getDimensionsSpec(), this.listDelimiter, cols);
    }
}

