/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator.cache;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.utils.ThreadUtils;
import org.apache.hive.druid.io.druid.curator.cache.PathChildrenCacheFactory;

public class SimplePathChildrenCacheFactory
implements PathChildrenCacheFactory {
    private final boolean cacheData;
    private final boolean compressed;
    private final ExecutorService exec;

    public SimplePathChildrenCacheFactory(boolean cacheData, boolean compressed, ExecutorService exec) {
        this.cacheData = cacheData;
        this.compressed = compressed;
        this.exec = exec;
    }

    @Override
    public PathChildrenCache make(CuratorFramework curator, String path) {
        return new PathChildrenCache(curator, path, this.cacheData, this.compressed, this.exec);
    }

    public static class Builder {
        private static final ThreadFactory defaultThreadFactory = ThreadUtils.newThreadFactory((String)"PathChildrenCache");
        private boolean cacheData = true;
        private boolean compressed = false;
        private ExecutorService exec = Executors.newSingleThreadExecutor(defaultThreadFactory);

        public Builder withCacheData(boolean cacheData) {
            this.cacheData = cacheData;
            return this;
        }

        public Builder withCompressed(boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public Builder withExecutorService(ExecutorService exec) {
            this.exec = exec;
            return this;
        }

        public SimplePathChildrenCacheFactory build() {
            return new SimplePathChildrenCacheFactory(this.cacheData, this.compressed, this.exec);
        }
    }
}

