/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.IOException;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.curator.CuratorConfig;
import org.apache.hive.druid.io.druid.curator.PotentiallyGzippedCompressionProvider;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class CuratorModule
implements Module {
    private static final Logger log = new Logger(CuratorModule.class);

    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "druid.zk.service", CuratorConfig.class);
    }

    @Provides
    @LazySingleton
    public CuratorFramework makeCurator(CuratorConfig config, Lifecycle lifecycle) throws IOException {
        final CuratorFramework framework = CuratorFrameworkFactory.builder().connectString(config.getZkHosts()).sessionTimeoutMs(config.getZkSessionTimeoutMs().intValue()).retryPolicy((RetryPolicy)new BoundedExponentialBackoffRetry(1000, 45000, 30)).compressionProvider((CompressionProvider)new PotentiallyGzippedCompressionProvider(config.getEnableCompression())).aclProvider((ACLProvider)(config.getEnableAcl() ? new SecuredACLProvider() : new DefaultACLProvider())).build();
        lifecycle.addHandler(new Lifecycle.Handler(){

            @Override
            public void start() throws Exception {
                log.info("Starting Curator", new Object[0]);
                framework.start();
            }

            @Override
            public void stop() {
                log.info("Stopping Curator", new Object[0]);
                framework.close();
            }
        });
        return framework;
    }

    class SecuredACLProvider
    implements ACLProvider {
        SecuredACLProvider() {
        }

        public List<ACL> getDefaultAcl() {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }

        public List<ACL> getAclForPath(String path) {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }
    }
}

