/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;

public class StupidPool<T> {
    private static final Logger log = new Logger(StupidPool.class);
    private final Supplier<T> generator;
    private final Queue<T> objects = new ConcurrentLinkedQueue<T>();
    private final int objectsCacheMaxCount;

    public StupidPool(Supplier<T> generator) {
        this.generator = generator;
        this.objectsCacheMaxCount = Integer.MAX_VALUE;
    }

    public StupidPool(Supplier<T> generator, int objectsCacheMaxCount) {
        this.generator = generator;
        this.objectsCacheMaxCount = objectsCacheMaxCount;
    }

    public ResourceHolder<T> take() {
        T obj = this.objects.poll();
        return obj == null ? new ObjectResourceHolder(this.generator.get()) : new ObjectResourceHolder(obj);
    }

    private class ObjectResourceHolder
    implements ResourceHolder<T> {
        private AtomicBoolean closed = new AtomicBoolean(false);
        private final T object;

        public ObjectResourceHolder(T object) {
            this.object = object;
        }

        @Override
        public T get() {
            if (this.closed.get()) {
                throw new ISE("Already Closed!", new Object[0]);
            }
            return this.object;
        }

        @Override
        public void close() {
            if (!this.closed.compareAndSet(false, true)) {
                log.warn(new ISE("Already Closed!", new Object[0]), "Already closed", new Object[0]);
                return;
            }
            if (StupidPool.this.objects.size() < StupidPool.this.objectsCacheMaxCount) {
                if (!StupidPool.this.objects.offer(this.object)) {
                    log.warn(new ISE("Queue offer failed", new Object[0]), "Could not offer object [%s] back into the queue", this.object);
                }
            } else {
                log.debug("cache num entries is exceeding max limit [%s]", StupidPool.this.objectsCacheMaxCount);
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (!this.closed.get()) {
                    log.warn("Not closed!  Object was[%s]. Allowing gc to prevent leak.", this.object);
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

