/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.PeekingIterator;
import org.apache.hive.druid.com.metamx.common.guava.nary.BinaryFn;

public class CombiningIterator<InType>
implements Iterator<InType> {
    private final PeekingIterator<InType> it;
    private final Comparator<InType> comparator;
    private final BinaryFn<InType, InType, InType> fn;

    public static <InType> CombiningIterator<InType> create(Iterator<InType> it, Comparator<InType> comparator, BinaryFn<InType, InType, InType> fn) {
        return new CombiningIterator<InType>(it, comparator, fn);
    }

    public CombiningIterator(Iterator<InType> it, Comparator<InType> comparator, BinaryFn<InType, InType, InType> fn) {
        this.it = Iterators.peekingIterator(it);
        this.comparator = comparator;
        this.fn = fn;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public InType next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object res = null;
        while (this.hasNext()) {
            if (res == null) {
                res = this.fn.apply(this.it.next(), null);
                continue;
            }
            if (this.comparator.compare(res, this.it.peek()) != 0) break;
            res = this.fn.apply(res, this.it.next());
        }
        return (InType)res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

