/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.client.DruidDataSource;
import org.apache.hive.druid.io.druid.client.DruidServerConfig;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class DruidServer
implements Comparable {
    public static final int DEFAULT_PRIORITY = 0;
    public static final int DEFAULT_NUM_REPLICANTS = 2;
    public static final String DEFAULT_TIER = "_default_tier";
    private static final Logger log = new Logger(DruidServer.class);
    private final Object lock = new Object();
    private final ConcurrentMap<String, DruidDataSource> dataSources;
    private final ConcurrentMap<String, DataSegment> segments;
    private final DruidServerMetadata metadata;
    private volatile long currSize;

    public DruidServer(DruidNode node, DruidServerConfig config, String type) {
        this(node.getHostAndPort(), node.getHostAndPort(), config.getMaxSize(), type, config.getTier(), 0);
    }

    @JsonCreator
    public DruidServer(@JsonProperty(value="name") String name, @JsonProperty(value="host") String host, @JsonProperty(value="maxSize") long maxSize, @JsonProperty(value="type") String type, @JsonProperty(value="tier") String tier, @JsonProperty(value="priority") int priority) {
        this.metadata = new DruidServerMetadata(name, host, maxSize, type, tier, priority);
        this.dataSources = new ConcurrentHashMap<String, DruidDataSource>();
        this.segments = new ConcurrentHashMap<String, DataSegment>();
    }

    public String getName() {
        return this.metadata.getName();
    }

    public DruidServerMetadata getMetadata() {
        return this.metadata;
    }

    public String getHost() {
        return this.metadata.getHost();
    }

    public long getCurrSize() {
        return this.currSize;
    }

    public long getMaxSize() {
        return this.metadata.getMaxSize();
    }

    public String getType() {
        return this.metadata.getType();
    }

    public String getTier() {
        return this.metadata.getTier();
    }

    public boolean isAssignable() {
        return this.metadata.isAssignable();
    }

    public int getPriority() {
        return this.metadata.getPriority();
    }

    public Map<String, DataSegment> getSegments() {
        return Collections.unmodifiableMap(this.segments);
    }

    public DataSegment getSegment(String segmentName) {
        return (DataSegment)this.segments.get(segmentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidServer addDataSegment(String segmentId, DataSegment segment) {
        Object object = this.lock;
        synchronized (object) {
            DataSegment shouldNotExist = (DataSegment)this.segments.get(segmentId);
            if (shouldNotExist != null) {
                log.warn("Asked to add data segment that already exists!? server[%s], segment[%s]", this.getName(), segmentId);
                return this;
            }
            String dataSourceName = segment.getDataSource();
            DruidDataSource dataSource = (DruidDataSource)this.dataSources.get(dataSourceName);
            if (dataSource == null) {
                dataSource = new DruidDataSource(dataSourceName, ImmutableMap.of("client", "side"));
                this.dataSources.put(dataSourceName, dataSource);
            }
            dataSource.addSegment(segmentId, segment);
            this.segments.put(segmentId, segment);
            this.currSize += segment.getSize();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidServer addDataSegments(DruidServer server) {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry entry : server.segments.entrySet()) {
                this.addDataSegment((String)entry.getKey(), (DataSegment)entry.getValue());
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidServer removeDataSegment(String segmentId) {
        Object object = this.lock;
        synchronized (object) {
            DataSegment segment = (DataSegment)this.segments.get(segmentId);
            if (segment == null) {
                log.warn("Asked to remove data segment that doesn't exist!? server[%s], segment[%s]", this.getName(), segmentId);
                return this;
            }
            DruidDataSource dataSource = (DruidDataSource)this.dataSources.get(segment.getDataSource());
            if (dataSource == null) {
                log.warn("Asked to remove data segment from dataSource[%s] that doesn't exist, but the segment[%s] exists!?!?!?! wtf?  server[%s]", segment.getDataSource(), segmentId, this.getName());
                return this;
            }
            dataSource.removePartition(segmentId);
            this.segments.remove(segmentId);
            this.currSize -= segment.getSize();
            if (dataSource.isEmpty()) {
                this.dataSources.remove(dataSource.getName());
            }
        }
        return this;
    }

    public DruidDataSource getDataSource(String dataSource) {
        return (DruidDataSource)this.dataSources.get(dataSource);
    }

    public Iterable<DruidDataSource> getDataSources() {
        return this.dataSources.values();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidServer that = (DruidServer)o;
        return !(this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null);
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public String toString() {
        return this.metadata.toString();
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return 1;
        }
        return this.getName().compareTo(((DruidServer)o).getName());
    }

    public ImmutableDruidServer toImmutableDruidServer() {
        return new ImmutableDruidServer(this.metadata, this.currSize, ImmutableMap.copyOf(Maps.transformValues(this.dataSources, new Function<DruidDataSource, ImmutableDruidDataSource>(){

            @Override
            public ImmutableDruidDataSource apply(DruidDataSource input) {
                return input.toImmutableDruidDataSource();
            }
        })), ImmutableMap.copyOf(this.segments));
    }
}

