/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.guava;

import java.io.Closeable;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.com.metamx.common.guava.ResourceClosingYielder;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;

public class ResourceClosingSequence<T>
implements Sequence<T> {
    private final Sequence<T> baseSequence;
    private final Closeable closeable;

    public ResourceClosingSequence(Sequence<T> baseSequence, Closeable closeable) {
        this.baseSequence = baseSequence;
        this.closeable = closeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
        try {
            OutType OutType = this.baseSequence.accumulate(initValue, accumulator);
            return OutType;
        }
        finally {
            CloseQuietly.close(this.closeable);
        }
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        Yielder<OutType> baseYielder;
        try {
            baseYielder = this.baseSequence.toYielder(initValue, accumulator);
        }
        catch (RuntimeException e) {
            CloseQuietly.close(this.closeable);
            throw e;
        }
        return new ResourceClosingYielder<OutType>(baseYielder, this.closeable);
    }
}

