/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.wrappers.matrix;

import it.uniroma3.mat.extendedset.intset.IntSet;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.NoSuchElementException;

public class BinaryMatrix
implements Cloneable,
Comparable<BinaryMatrix> {
    private final List<IntSet> rows = new ArrayList<IntSet>();
    private final IntSet template;
    private final int[] resultCache = new int[2];

    public BinaryMatrix(IntSet template) {
        this.template = template;
    }

    public IntSet emptyRow() {
        return this.template.empty();
    }

    private void fixRows() {
        int last = this.rows.size() - 1;
        while (last >= 0 && this.rows.get(last) == null) {
            this.rows.remove(last--);
        }
    }

    public BinaryMatrix intersection(BinaryMatrix other) {
        BinaryMatrix res = this.empty();
        int rowCount = Math.min(this.rows.size(), other.rows.size());
        for (int i = 0; i < rowCount; ++i) {
            IntSet s1 = this.rows.get(i);
            IntSet s2 = other.rows.get(i);
            if (s1 == null || s2 == null) {
                res.rows.add(null);
            } else {
                IntSet r = s1.intersection(s2);
                if (r.isEmpty()) {
                    res.rows.add(null);
                } else {
                    res.rows.add(r);
                }
            }
            assert (res.rows.get(i) == null || !res.rows.get(i).isEmpty());
        }
        res.fixRows();
        return res;
    }

    public BinaryMatrix union(BinaryMatrix other) {
        IntSet s;
        int i;
        BinaryMatrix res = this.empty();
        int rowCount = Math.min(this.rows.size(), other.rows.size());
        for (i = 0; i < rowCount; ++i) {
            IntSet s1 = this.rows.get(i);
            IntSet s2 = other.rows.get(i);
            if (s1 == null) {
                if (s2 == null) {
                    res.rows.add(null);
                } else {
                    res.rows.add(s2.clone());
                }
            } else if (s2 == null) {
                res.rows.add(s1.clone());
            } else {
                res.rows.add(s1.union(s2));
            }
            assert (res.rows.get(i) == null || !res.rows.get(i).isEmpty());
        }
        while (i < this.rows.size()) {
            s = this.rows.get(i);
            res.rows.add(s == null ? null : s.clone());
            assert (res.rows.get(i) == null || !res.rows.get(i).isEmpty());
            ++i;
        }
        while (i < other.rows.size()) {
            s = other.rows.get(i);
            res.rows.add(s == null ? null : s.clone());
            assert (res.rows.get(i) == null || !res.rows.get(i).isEmpty());
            ++i;
        }
        return res;
    }

    public BinaryMatrix difference(BinaryMatrix other) {
        int i;
        BinaryMatrix res = this.empty();
        int rowCount = Math.min(this.rows.size(), other.rows.size());
        for (i = 0; i < rowCount; ++i) {
            IntSet s1 = this.rows.get(i);
            IntSet s2 = other.rows.get(i);
            if (s1 == null) {
                res.rows.add(null);
            } else if (s2 == null) {
                res.rows.add(s1.clone());
            } else {
                IntSet r = s1.difference(s2);
                res.rows.add(r.isEmpty() ? null : r);
            }
            assert (res.rows.get(i) == null || !res.rows.get(i).isEmpty());
        }
        while (i < this.rows.size()) {
            IntSet s = this.rows.get(i);
            res.rows.add(s == null ? null : s.clone());
            assert (res.rows.get(i) == null || !res.rows.get(i).isEmpty());
            ++i;
        }
        res.fixRows();
        return res;
    }

    public BinaryMatrix symmetricDifference(BinaryMatrix other) {
        IntSet s;
        int i;
        BinaryMatrix res = this.empty();
        int rowCount = Math.min(this.rows.size(), other.rows.size());
        for (i = 0; i < rowCount; ++i) {
            IntSet s1 = this.rows.get(i);
            IntSet s2 = other.rows.get(i);
            if (s1 == null) {
                if (s2 == null) {
                    res.rows.add(null);
                } else {
                    res.rows.add(s2.clone());
                }
            } else if (s2 == null) {
                res.rows.add(s1.clone());
            } else {
                res.rows.add(s1.symmetricDifference(s2));
            }
            assert (res.rows.get(i) == null || !res.rows.get(i).isEmpty());
        }
        while (i < this.rows.size()) {
            s = this.rows.get(i);
            res.rows.add(s == null ? null : s.clone());
            assert (res.rows.get(i) == null || !res.rows.get(i).isEmpty());
            ++i;
        }
        while (i < other.rows.size()) {
            s = other.rows.get(i);
            res.rows.add(s == null ? null : s.clone());
            assert (res.rows.get(i) == null || !res.rows.get(i).isEmpty());
            ++i;
        }
        res.fixRows();
        return res;
    }

    public BinaryMatrix complemented() {
        BinaryMatrix res = this.empty();
        int maxCol = this.maxCol();
        for (int i = 0; i < this.rows.size(); ++i) {
            IntSet s = this.rows.get(i);
            if (s == null) {
                s = this.template.empty();
                s.fill(0, maxCol);
            } else {
                s.add(maxCol + 1);
                s.complemented();
                if (s.isEmpty()) {
                    s = null;
                }
            }
            res.rows.add(s);
        }
        res.fixRows();
        return res;
    }

    public void complement() {
        int maxCol = this.maxCol();
        for (int i = 0; i < this.rows.size(); ++i) {
            IntSet s = this.rows.get(i);
            if (s == null) {
                s = this.template.empty();
                s.fill(0, maxCol - 1);
                this.rows.set(i, s);
                continue;
            }
            s.add(maxCol + 1);
            s.complement();
            if (!s.isEmpty()) continue;
            this.rows.set(i, null);
        }
        this.fixRows();
    }

    public boolean containsAny(BinaryMatrix other) {
        int rowCount = Math.min(this.rows.size(), other.rows.size());
        for (int i = 0; i < rowCount; ++i) {
            IntSet s1 = this.rows.get(i);
            IntSet s2 = other.rows.get(i);
            if (s1 == null || s2 == null || !s1.containsAny(s2)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAtLeast(BinaryMatrix other, int minCells) {
        if (minCells < 1) {
            throw new IllegalArgumentException();
        }
        int size = this.size();
        if (size < minCells || other == null || other.isEmpty() || this.isEmpty()) {
            return false;
        }
        if (this == other) {
            return size >= minCells;
        }
        int res = 0;
        int last = Math.min(this.rows.size(), other.rows.size()) - 1;
        for (int i = 0; i < last; ++i) {
            IntSet s1 = this.rows.get(i);
            IntSet s2 = other.rows.get(i);
            if (s1 == null || s2 == null || (res += s1.intersectionSize(s2)) < minCells) continue;
            return true;
        }
        IntSet l1 = this.rows.get(last);
        IntSet l2 = other.rows.get(last);
        if (l1 == null || l2 == null) {
            return false;
        }
        return l1.containsAtLeast(l2, minCells - res);
    }

    public int intersectionSize(BinaryMatrix other) {
        int res = 0;
        int rowCount = Math.min(this.rows.size(), other.rows.size());
        for (int i = 0; i < rowCount; ++i) {
            IntSet s1 = this.rows.get(i);
            IntSet s2 = other.rows.get(i);
            if (s1 == null || s2 == null) continue;
            res += s1.intersectionSize(s2);
        }
        return res;
    }

    public int unionSize(BinaryMatrix other) {
        return other == null ? this.size() : this.size() + other.size() - this.intersectionSize(other);
    }

    public int symmetricDifferenceSize(BinaryMatrix other) {
        return other == null ? this.size() : this.size() + other.size() - 2 * this.intersectionSize(other);
    }

    public int differenceSize(BinaryMatrix other) {
        return other == null ? this.size() : this.size() - this.intersectionSize(other);
    }

    public int complementSize() {
        int maxCol = this.maxCol();
        int res = 0;
        for (int i = 0; i < this.rows.size(); ++i) {
            IntSet s = this.rows.get(i);
            res += maxCol + 1;
            if (s == null) continue;
            res -= s.size();
        }
        return res;
    }

    public BinaryMatrix empty() {
        return new BinaryMatrix(this.template);
    }

    public BinaryMatrix clone() {
        BinaryMatrix res = this.empty();
        for (IntSet r : this.rows) {
            res.rows.add(r == null ? null : r.clone());
        }
        return res;
    }

    public double bitmapCompressionRatio() {
        throw new UnsupportedOperationException("TODO");
    }

    public double collectionCompressionRatio() {
        throw new UnsupportedOperationException("TODO");
    }

    public CellIterator iterator() {
        if (this.isEmpty()) {
            return new CellIterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public int[] next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new IllegalStateException();
                }

                @Override
                public void skipAllBefore(int row, int col) {
                }
            };
        }
        return new CellIterator(){
            int curRow = 0;
            IntSet.IntIterator curRowItr;
            private final int[] itrResultCache = new int[2];
            {
                while (BinaryMatrix.this.rows.get(this.curRow) == null) {
                    ++this.curRow;
                }
                this.curRowItr = ((IntSet)BinaryMatrix.this.rows.get(this.curRow)).iterator();
                this.itrResultCache[0] = this.curRow;
            }

            @Override
            public int[] next() {
                if (!this.curRowItr.hasNext()) {
                    IntSet s;
                    while ((s = (IntSet)BinaryMatrix.this.rows.get(++this.curRow)) == null) {
                    }
                    this.curRowItr = s.iterator();
                    this.itrResultCache[0] = this.curRow;
                }
                this.itrResultCache[1] = this.curRowItr.next();
                return this.itrResultCache;
            }

            @Override
            public boolean hasNext() {
                return this.curRow < BinaryMatrix.this.rows.size() - 1 || this.curRowItr.hasNext();
            }

            @Override
            public void skipAllBefore(int row, int col) {
                throw new UnsupportedOperationException("TODO");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("TODO");
            }
        };
    }

    public CellIterator descendingIterator() {
        if (this.isEmpty()) {
            return new CellIterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public int[] next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new IllegalStateException();
                }

                @Override
                public void skipAllBefore(int row, int col) {
                }
            };
        }
        return new CellIterator(){
            final int minRow;
            int curRow;
            IntSet.IntIterator curRowItr;
            private final int[] itrResultCache;
            {
                this.curRow = BinaryMatrix.this.rows.size() - 1;
                this.itrResultCache = new int[2];
                int m = 0;
                while (BinaryMatrix.this.rows.get(m) == null) {
                    ++m;
                }
                this.minRow = m;
                this.curRowItr = ((IntSet)BinaryMatrix.this.rows.get(this.curRow)).descendingIterator();
                this.itrResultCache[0] = this.curRow;
            }

            @Override
            public int[] next() {
                if (!this.curRowItr.hasNext()) {
                    IntSet s;
                    while ((s = (IntSet)BinaryMatrix.this.rows.get(--this.curRow)) == null) {
                    }
                    this.curRowItr = s.descendingIterator();
                    this.itrResultCache[0] = this.curRow;
                }
                this.itrResultCache[1] = this.curRowItr.next();
                return this.itrResultCache;
            }

            @Override
            public boolean hasNext() {
                return this.curRow > this.minRow || this.curRowItr.hasNext();
            }

            @Override
            public void skipAllBefore(int row, int col) {
                throw new UnsupportedOperationException("TODO");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("TODO");
            }
        };
    }

    public String debugInfo() {
        if (this.isEmpty()) {
            return "empty";
        }
        StringBuilder s = new StringBuilder();
        Formatter f = new Formatter(s);
        String format = String.format("%%%dd) ", (int)Math.log10(this.rows.size()) + 1);
        for (int i = 0; i < this.rows.size(); ++i) {
            f.format(format, i);
            s.append(this.rows.get(i) == null ? "-" : this.rows.get(i).toString());
            s.append('\n');
        }
        return s.toString();
    }

    public void fill(int fromRow, int fromCol, int toRow, int toCol) {
        int r;
        if (fromRow > toRow) {
            throw new IndexOutOfBoundsException("fromRow: " + fromRow + " > toRow: " + toRow);
        }
        if (fromCol > toCol) {
            throw new IndexOutOfBoundsException("fromCol: " + fromCol + " > toCol: " + toCol);
        }
        for (r = this.rows.size(); r <= toRow; ++r) {
            this.rows.add(null);
        }
        for (r = fromRow; r <= toRow; ++r) {
            IntSet s = this.rows.get(r);
            if (s == null) {
                s = this.template.empty();
                this.rows.set(r, s);
            }
            s.fill(fromCol, toCol);
        }
    }

    public void clear(int fromRow, int fromCol, int toRow, int toCol) {
        if (fromRow > toRow) {
            throw new IndexOutOfBoundsException("fromRow: " + fromRow + " > toRow: " + toRow);
        }
        if (fromCol > toCol) {
            throw new IndexOutOfBoundsException("fromCol: " + fromCol + " > toCol: " + toCol);
        }
        for (int r = Math.min(toRow, this.rows.size() - 1); r >= fromRow; --r) {
            IntSet s = this.rows.get(r);
            if (s == null) continue;
            s.clear(fromCol, toCol);
            if (!s.isEmpty()) continue;
            this.rows.set(r, null);
        }
        this.fixRows();
    }

    public void flip(int row, int col) {
        while (row >= this.rows.size()) {
            this.rows.add(null);
        }
        IntSet r = this.rows.get(row);
        if (r == null) {
            r = this.template.empty();
            this.rows.set(row, r);
        }
        r.flip(col);
        if (r.isEmpty()) {
            this.rows.set(row, null);
            this.fixRows();
        }
    }

    public int[] get(int i) {
        for (int r = 0; r < this.rows.size(); ++r) {
            IntSet s = this.rows.get(r);
            if (s == null) continue;
            int ss = s.size();
            if (ss <= i) {
                i -= ss;
                continue;
            }
            this.resultCache[0] = r;
            this.resultCache[1] = s.get(i);
            return this.resultCache;
        }
        throw new NoSuchElementException();
    }

    public int indexOf(int row, int col) {
        if (row >= this.rows.size() || this.rows.get(row) == null) {
            return -1;
        }
        int res = this.rows.get(row).indexOf(col);
        if (res == -1) {
            return -1;
        }
        for (int r = 0; r < row; ++r) {
            IntSet s = this.rows.get(r);
            if (s == null) continue;
            res += s.size();
        }
        return res;
    }

    public BinaryMatrix convert(boolean[][] a) {
        throw new UnsupportedOperationException("TODO");
    }

    public int[] first() {
        IntSet s;
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int i = 0;
        while ((s = this.rows.get(i)) == null) {
            ++i;
        }
        this.resultCache[0] = i;
        this.resultCache[1] = s.first();
        return this.resultCache;
    }

    public int[] last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.resultCache[0] = this.rows.size() - 1;
        this.resultCache[1] = this.rows.get(this.rows.size() - 1).last();
        return this.resultCache;
    }

    public int size() {
        int res = 0;
        for (IntSet s : this.rows) {
            if (s == null) continue;
            res += s.size();
        }
        return res;
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public boolean contains(int row, int col) {
        return row >= 0 && col >= 0 && row < this.rows.size() && this.rows.get(row) != null && this.rows.get(row).contains(col);
    }

    public boolean add(int row, int col) {
        while (row >= this.rows.size()) {
            this.rows.add(null);
        }
        IntSet r = this.rows.get(row);
        if (r == null) {
            r = this.template.empty();
            this.rows.set(row, r);
        }
        return r.add(col);
    }

    public boolean addAll(int row, IntSet cols) {
        while (row >= this.rows.size()) {
            this.rows.add(null);
        }
        IntSet r = this.rows.get(row);
        if (r == null) {
            r = this.template.empty();
            this.rows.set(row, r);
        }
        return r.addAll(cols);
    }

    public boolean addAll(IntSet rowSet, int col) {
        if (rowSet == null || rowSet.isEmpty()) {
            return false;
        }
        int l = rowSet.last();
        while (l >= this.rows.size()) {
            this.rows.add(null);
        }
        boolean res = false;
        IntSet.IntIterator itr = rowSet.iterator();
        while (itr.hasNext()) {
            int r = itr.next();
            IntSet s = this.rows.get(r);
            if (s == null) {
                this.rows.set(r, this.template.convert(col));
                res = true;
                continue;
            }
            res |= s.add(col);
        }
        return res;
    }

    public boolean addAll(IntSet rowSet, IntSet colSet) {
        if (rowSet == null || rowSet.isEmpty() || colSet == null || colSet.isEmpty()) {
            return false;
        }
        int l = rowSet.last();
        while (l >= this.rows.size()) {
            this.rows.add(null);
        }
        boolean res = false;
        IntSet.IntIterator itr = rowSet.iterator();
        while (itr.hasNext()) {
            int row = itr.next();
            IntSet cols = this.rows.get(row);
            if (cols == null) {
                IntSet newCols = this.template.empty();
                newCols.addAll(colSet);
                this.rows.set(row, newCols);
                res = true;
                continue;
            }
            res |= cols.addAll(colSet);
        }
        return res;
    }

    public boolean remove(int row, int col) {
        if (row < 0 || col < 0 || row >= this.rows.size()) {
            return false;
        }
        IntSet r = this.rows.get(row);
        if (r == null) {
            return false;
        }
        if (r.remove(col)) {
            if (r.isEmpty()) {
                this.rows.set(row, null);
                this.fixRows();
            }
            return true;
        }
        return false;
    }

    public boolean removeAll(int row, IntSet cols) {
        if (row < 0 || row >= this.rows.size()) {
            return false;
        }
        IntSet r = this.rows.get(row);
        if (r == null) {
            return false;
        }
        if (r.removeAll(cols)) {
            if (r.isEmpty()) {
                this.rows.set(row, null);
                this.fixRows();
            }
            return true;
        }
        return false;
    }

    public boolean removeAll(IntSet rowSet, int col) {
        if (rowSet == null || rowSet.isEmpty()) {
            return false;
        }
        boolean res = false;
        IntSet.IntIterator itr = rowSet.iterator();
        while (itr.hasNext()) {
            int r = itr.next();
            IntSet s = this.rows.get(r);
            if (s == null) continue;
            res |= s.remove(col);
            if (!s.isEmpty()) continue;
            this.rows.set(r, null);
        }
        if (res) {
            this.fixRows();
        }
        return res;
    }

    public boolean removeAll(IntSet rowSet, IntSet colSet) {
        if (rowSet == null || rowSet.isEmpty() || colSet == null || colSet.isEmpty()) {
            return false;
        }
        boolean res = false;
        IntSet.IntIterator itr = rowSet.iterator();
        while (itr.hasNext()) {
            int r = itr.next();
            IntSet s = this.rows.get(r);
            if (s == null) continue;
            res |= s.removeAll(colSet);
            if (!s.isEmpty()) continue;
            this.rows.set(r, null);
        }
        if (res) {
            this.fixRows();
        }
        return res;
    }

    public boolean retainAll(int row, IntSet cols) {
        if (this.isEmpty()) {
            return false;
        }
        if (row < 0 || row >= this.rows.size()) {
            this.clear();
            return true;
        }
        IntSet r = this.rows.get(row);
        if (r == null) {
            this.clear();
            return true;
        }
        boolean res = false;
        for (int i = 0; i < this.rows.size(); ++i) {
            IntSet r1;
            if (i == row || (r1 = this.rows.get(i)) == null) continue;
            res = true;
            this.rows.set(i, null);
        }
        this.fixRows();
        return res |= r.retainAll(cols);
    }

    public boolean retainAll(IntSet rowSet, int col) {
        if (this.isEmpty()) {
            return false;
        }
        if (rowSet == null || rowSet.isEmpty()) {
            this.clear();
            return false;
        }
        boolean res = false;
        IntSet.IntIterator itr = rowSet.iterator();
        int i = 0;
        int r = itr.next();
        do {
            IntSet rr;
            if ((rr = this.rows.get(i)) == null) {
                ++i;
                continue;
            }
            if (i < r) {
                this.rows.set(i, null);
                res = true;
                ++i;
                continue;
            }
            if (i > r) {
                r = itr.next();
                continue;
            }
            if (!rr.contains(col)) {
                this.rows.set(i, null);
                res = true;
            } else if (rr.size() > 1) {
                rr.clear();
                rr.add(col);
                res = true;
            }
            ++i;
            r = itr.next();
        } while (i < this.rows.size() && itr.hasNext());
        res |= i < this.rows.size();
        while (i < this.rows.size()) {
            this.rows.set(i, null);
            ++i;
        }
        if (res) {
            this.fixRows();
        }
        return res;
    }

    public boolean retainAll(IntSet rowSet, IntSet colSet) {
        if (this.isEmpty()) {
            return false;
        }
        if (rowSet == null || rowSet.isEmpty() || colSet == null || colSet.isEmpty()) {
            this.clear();
            return false;
        }
        boolean res = false;
        IntSet.IntIterator itr = rowSet.iterator();
        int i = 0;
        int r = itr.next();
        do {
            IntSet rr;
            if ((rr = this.rows.get(i)) == null) {
                ++i;
                continue;
            }
            if (i < r) {
                this.rows.set(i, null);
                res = true;
                ++i;
                continue;
            }
            if (i > r) {
                r = itr.next();
                continue;
            }
            res |= rr.retainAll(colSet);
            if (rr.isEmpty()) {
                this.rows.set(i, null);
            }
            ++i;
            r = itr.next();
        } while (i < this.rows.size() && itr.hasNext());
        res |= i < this.rows.size();
        while (i < this.rows.size()) {
            this.rows.set(i, null);
            ++i;
        }
        if (res) {
            this.fixRows();
        }
        return res;
    }

    public boolean containsAll(BinaryMatrix other) {
        if (other == null || other.isEmpty() || other == this) {
            return true;
        }
        if (this.isEmpty() || this.rows.size() < other.rows.size()) {
            return false;
        }
        for (int i = 0; i < other.rows.size(); ++i) {
            IntSet s1 = this.rows.get(i);
            IntSet s2 = other.rows.get(i);
            if (s2 == null || s1 != null && s1.containsAll(s2)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntSet rowSet, IntSet colSet) {
        if (rowSet == null || rowSet.isEmpty() || colSet == null || colSet.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        IntSet.IntIterator itr = rowSet.iterator();
        while (itr.hasNext()) {
            int i = itr.next();
            IntSet cols = this.rows.get(i);
            if (cols != null && cols.containsAll(colSet)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(int row, IntSet colSet) {
        if (colSet == null || colSet.isEmpty()) {
            return true;
        }
        if (this.isEmpty() || row < 0 || row >= this.rows.size()) {
            return false;
        }
        IntSet cols = this.rows.get(row);
        return cols != null && cols.containsAll(colSet);
    }

    public boolean containsAll(IntSet rowSet, int col) {
        if (rowSet == null || rowSet.isEmpty()) {
            return true;
        }
        if (this.isEmpty() || col < 0) {
            return false;
        }
        IntSet.IntIterator itr = rowSet.iterator();
        while (itr.hasNext()) {
            int i = itr.next();
            IntSet cols = this.rows.get(i);
            if (cols != null && cols.contains(col)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(BinaryMatrix other) {
        int i;
        boolean res = false;
        int rowCount = Math.min(this.rows.size(), other.rows.size());
        for (i = 0; i < rowCount; ++i) {
            IntSet s1 = this.rows.get(i);
            IntSet s2 = other.rows.get(i);
            if (s2 == null) continue;
            if (s1 == null) {
                this.rows.set(i, s2.clone());
                res = true;
            } else {
                res |= s1.addAll(s2);
            }
            assert (this.rows.get(i) == null || !this.rows.get(i).isEmpty());
        }
        res |= i < other.rows.size();
        while (i < other.rows.size()) {
            IntSet s = other.rows.get(i);
            this.rows.add(s == null ? null : s.clone());
            assert (this.rows.get(i) == null || !this.rows.get(i).isEmpty());
            ++i;
        }
        return res;
    }

    public boolean retainAll(BinaryMatrix other) {
        int i;
        boolean res = false;
        int rowCount = Math.min(this.rows.size(), other.rows.size());
        for (i = 0; i < rowCount; ++i) {
            IntSet s1 = this.rows.get(i);
            IntSet s2 = other.rows.get(i);
            if (s1 == null) continue;
            if (s2 == null) {
                this.rows.set(i, null);
                res = true;
            } else {
                res |= s1.retainAll(s2);
                if (s1.isEmpty()) {
                    this.rows.set(i, null);
                }
            }
            assert (this.rows.get(i) == null || !this.rows.get(i).isEmpty());
        }
        res |= i < this.rows.size();
        while (i < this.rows.size()) {
            this.rows.set(i, null);
            ++i;
        }
        if (res) {
            this.fixRows();
        }
        return res;
    }

    public boolean removeAll(BinaryMatrix other) {
        int i;
        boolean res = false;
        int rowCount = Math.min(this.rows.size(), other.rows.size());
        for (i = 0; i < rowCount; ++i) {
            IntSet s1 = this.rows.get(i);
            IntSet s2 = other.rows.get(i);
            if (s1 == null || s2 == null) continue;
            res |= s1.removeAll(s2);
            if (s1.isEmpty()) {
                this.rows.set(i, null);
            }
            assert (this.rows.get(i) == null || !this.rows.get(i).isEmpty());
        }
        if (i < this.rows.size()) {
            return res;
        }
        if (res) {
            this.fixRows();
        }
        return res;
    }

    public void clear() {
        this.rows.clear();
    }

    public boolean[][] toArray() {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean[][] toArray(boolean[][] a) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public int compareTo(BinaryMatrix o) {
        throw new UnsupportedOperationException("TODO");
    }

    public IntSet getRow(int row) {
        if (row < 0) {
            throw new IllegalArgumentException("negative row index: " + row);
        }
        if (row >= this.rows.size()) {
            return this.template.empty();
        }
        IntSet res = this.rows.get(row);
        if (res == null) {
            return this.template.empty();
        }
        return res.clone();
    }

    public IntSet getCol(int col) {
        if (col < 0) {
            throw new IllegalArgumentException("negative column index: " + col);
        }
        IntSet res = this.template.empty();
        for (int row = 0; row < this.rows.size(); ++row) {
            IntSet r = this.rows.get(row);
            if (r == null || !r.contains(col)) continue;
            res.add(row);
        }
        return res;
    }

    public BinaryMatrix transposed() {
        BinaryMatrix res = this.empty();
        for (int row = 0; row < this.rows.size(); ++row) {
            IntSet r = this.rows.get(row);
            if (r == null) continue;
            IntSet.IntIterator itr = r.iterator();
            while (itr.hasNext()) {
                res.add(itr.next(), row);
            }
        }
        return res;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        int maxCol = this.maxCol();
        s.append('+');
        for (int i = 0; i <= maxCol; ++i) {
            s.append('-');
        }
        s.append("+\n");
        for (IntSet row : this.rows) {
            s.append('|');
            int col = 0;
            if (row != null) {
                IntSet.IntIterator itr = row.iterator();
                while (itr.hasNext()) {
                    int c = itr.next();
                    while (col++ < c) {
                        s.append(' ');
                    }
                    s.append('*');
                }
            }
            while (col++ <= maxCol) {
                s.append(' ');
            }
            s.append("|\n");
        }
        s.append('+');
        for (int i = 0; i <= maxCol; ++i) {
            s.append('-');
        }
        s.append("+\n");
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BinaryMatrix)) {
            return false;
        }
        return this.rows.equals(((BinaryMatrix)obj).rows);
    }

    public int hashCode() {
        int h = 1;
        for (IntSet s : this.rows) {
            h = (h << 5) - h;
            if (s == null) continue;
            h += s.hashCode();
        }
        return h;
    }

    public int maxRow() {
        return this.rows.size() - 1;
    }

    public int maxCol() {
        int res = 0;
        for (IntSet row : this.rows) {
            if (row == null) continue;
            assert (!row.isEmpty());
            res = Math.max(res, row.last());
        }
        return res;
    }

    public IntSet involvedRows() {
        IntSet res = this.template.empty();
        for (int i = 0; i < this.rows.size(); ++i) {
            if (this.rows.get(i) == null) continue;
            res.add(i);
        }
        return res;
    }

    public IntSet involvedCols() {
        IntSet res = this.template.empty();
        for (int i = 0; i < this.rows.size(); ++i) {
            res.addAll(this.rows.get(i));
        }
        return res;
    }

    public static interface CellIterator {
        public boolean hasNext();

        public int[] next();

        public void remove();

        public void skipAllBefore(int var1, int var2);
    }
}

