/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.intset;

import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.intset.ConciseSetUtils;
import it.uniroma3.mat.extendedset.intset.IntSet;
import it.uniroma3.mat.extendedset.utilities.IntList;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.hive.druid.com.google.common.collect.UnmodifiableIterator;

public class ImmutableConciseSet {
    private static final int CHUNK_SIZE = 10000;
    private final IntBuffer words;
    private final int lastWordIndex;
    private final int size;

    public static ImmutableConciseSet newImmutableFromMutable(ConciseSet conciseSet) {
        if (conciseSet == null || conciseSet.isEmpty()) {
            return new ImmutableConciseSet();
        }
        return new ImmutableConciseSet(IntBuffer.wrap(conciseSet.getWords()));
    }

    public static int compareInts(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static ImmutableConciseSet union(ImmutableConciseSet ... sets) {
        return ImmutableConciseSet.union(Arrays.asList(sets));
    }

    public static ImmutableConciseSet union(Iterable<ImmutableConciseSet> sets) {
        return ImmutableConciseSet.union(sets.iterator());
    }

    public static ImmutableConciseSet union(Iterator<ImmutableConciseSet> sets) {
        ImmutableConciseSet partialResults = ImmutableConciseSet.doUnion(Iterators.limit(sets, 10000));
        while (sets.hasNext()) {
            UnmodifiableIterator<ImmutableConciseSet> partialIter = Iterators.singletonIterator(partialResults);
            partialResults = ImmutableConciseSet.doUnion(Iterators.concat(partialIter, Iterators.limit(sets, 10000)));
        }
        return partialResults;
    }

    public static ImmutableConciseSet intersection(ImmutableConciseSet ... sets) {
        return ImmutableConciseSet.intersection(Arrays.asList(sets));
    }

    public static ImmutableConciseSet intersection(Iterable<ImmutableConciseSet> sets) {
        return ImmutableConciseSet.intersection(sets.iterator());
    }

    public static ImmutableConciseSet intersection(Iterator<ImmutableConciseSet> sets) {
        ImmutableConciseSet partialResults = ImmutableConciseSet.doIntersection(Iterators.limit(sets, 10000));
        while (sets.hasNext()) {
            UnmodifiableIterator<ImmutableConciseSet> partialIter = Iterators.singletonIterator(partialResults);
            partialResults = ImmutableConciseSet.doIntersection(Iterators.concat(Iterators.limit(sets, 10000), partialIter));
        }
        return partialResults;
    }

    public static ImmutableConciseSet complement(ImmutableConciseSet set) {
        return ImmutableConciseSet.doComplement(set);
    }

    public static ImmutableConciseSet complement(ImmutableConciseSet set, int length) {
        int lastWord;
        if (length <= 0) {
            return new ImmutableConciseSet();
        }
        if (set == null || set.isEmpty()) {
            int leftoverBits = length % 31;
            int onesBlocks = length / 31;
            int[] words = onesBlocks > 0 ? (leftoverBits > 0 ? new int[]{0x40000000 | onesBlocks - 1, ConciseSetUtils.onesUntil(leftoverBits)} : new int[]{0x40000000 | onesBlocks - 1}) : (leftoverBits > 0 ? new int[]{ConciseSetUtils.onesUntil(leftoverBits)} : new int[]{});
            ConciseSet newSet = new ConciseSet(words, false);
            return ImmutableConciseSet.newImmutableFromMutable(newSet);
        }
        IntList retVal = new IntList();
        int endIndex = length - 1;
        int wordsWalked = 0;
        int last = 0;
        WordIterator iter = set.newWordIterator();
        while (iter.hasNext()) {
            int word = iter.next();
            wordsWalked = iter.wordsWalked;
            if (ConciseSetUtils.isLiteral(word)) {
                retVal.add(Integer.MIN_VALUE | ~word);
                continue;
            }
            retVal.add(0x40000000 ^ word);
        }
        last = set.getLast();
        int distFromLastWordBoundary = ConciseSetUtils.maxLiteralLengthModulus(last);
        int distToNextWordBoundary = 31 - distFromLastWordBoundary - 1;
        int diff = endIndex - (last = last < 0 ? 0 : last + distToNextWordBoundary);
        if (diff > 0) {
            if (diff <= 31) {
                retVal.add(-1);
            } else {
                int endIndexWordCount = ConciseSetUtils.maxLiteralLengthDivision(endIndex);
                retVal.add(0x40000000 | endIndexWordCount - wordsWalked - 1);
                retVal.add(-1);
            }
        }
        if (ConciseSetUtils.isLiteral(lastWord = retVal.get(retVal.length() - 1))) {
            lastWord = ConciseSetUtils.clearBitsAfterInLastWord(lastWord, ConciseSetUtils.maxLiteralLengthModulus(endIndex));
        }
        retVal.set(retVal.length() - 1, lastWord);
        ImmutableConciseSet.trimZeros(retVal);
        if (retVal.isEmpty()) {
            return new ImmutableConciseSet();
        }
        return ImmutableConciseSet.compact(new ImmutableConciseSet(IntBuffer.wrap(retVal.toArray())));
    }

    public static ImmutableConciseSet compact(ImmutableConciseSet set) {
        IntList retVal = new IntList();
        WordIterator itr = set.newWordIterator();
        while (itr.hasNext()) {
            ImmutableConciseSet.addAndCompact(retVal, itr.next());
        }
        return new ImmutableConciseSet(IntBuffer.wrap(retVal.toArray()));
    }

    private static void addAndCompact(IntList set, int wordToAdd) {
        int length = set.length();
        if (set.isEmpty()) {
            set.add(wordToAdd);
            return;
        }
        int last = set.get(length - 1);
        int newWord = 0;
        if (ConciseSetUtils.isAllOnesLiteral(last)) {
            if (ConciseSetUtils.isAllOnesLiteral(wordToAdd)) {
                newWord = 0x40000001;
            } else if (ConciseSetUtils.isOneSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                newWord = wordToAdd + 1;
            }
        } else if (ConciseSetUtils.isOneSequence(last)) {
            if (ConciseSetUtils.isAllOnesLiteral(wordToAdd)) {
                newWord = last + 1;
            } else if (ConciseSetUtils.isOneSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                newWord = last + ConciseSetUtils.getSequenceNumWords(wordToAdd);
            }
        } else if (ConciseSetUtils.isAllZerosLiteral(last)) {
            if (ConciseSetUtils.isAllZerosLiteral(wordToAdd)) {
                newWord = 1;
            } else if (ConciseSetUtils.isZeroSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                newWord = wordToAdd + 1;
            }
        } else if (ConciseSetUtils.isZeroSequence(last)) {
            if (ConciseSetUtils.isAllZerosLiteral(wordToAdd)) {
                newWord = last + 1;
            } else if (ConciseSetUtils.isZeroSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                newWord = last + ConciseSetUtils.getSequenceNumWords(wordToAdd);
            }
        } else if (ConciseSetUtils.isLiteralWithSingleOneBit(last)) {
            int position = Integer.numberOfTrailingZeros(last) + 1;
            if (ConciseSetUtils.isAllZerosLiteral(wordToAdd)) {
                newWord = 1 | position << 25;
            } else if (ConciseSetUtils.isZeroSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                newWord = wordToAdd + 1 | position << 25;
            }
        } else if (ConciseSetUtils.isLiteralWithSingleZeroBit(last)) {
            int position = Integer.numberOfTrailingZeros(~last) + 1;
            if (ConciseSetUtils.isAllOnesLiteral(wordToAdd)) {
                newWord = 0x40000001 | position << 25;
            } else if (ConciseSetUtils.isOneSequence(wordToAdd) && ConciseSetUtils.getFlippedBit(wordToAdd) == -1) {
                newWord = wordToAdd + 1 | position << 25;
            }
        }
        if (newWord != 0) {
            set.set(length - 1, newWord);
        } else {
            set.add(wordToAdd);
        }
    }

    private static ImmutableConciseSet doUnion(Iterator<ImmutableConciseSet> sets) {
        IntList retVal = new IntList();
        MinMaxPriorityQueue theQ = MinMaxPriorityQueue.orderedBy(new Comparator<WordHolder>(){

            @Override
            public int compare(WordHolder h1, WordHolder h2) {
                int s2;
                int w1 = h1.getWord();
                int w2 = h2.getWord();
                int s1 = h1.getIterator().startIndex;
                if (s1 != (s2 = h2.getIterator().startIndex)) {
                    return ImmutableConciseSet.compareInts(s1, s2);
                }
                if (ConciseSetUtils.isOneSequence(w1)) {
                    if (ConciseSetUtils.isOneSequence(w2)) {
                        return -ImmutableConciseSet.compareInts(ConciseSetUtils.getSequenceNumWords(w1), ConciseSetUtils.getSequenceNumWords(w2));
                    }
                    return -1;
                }
                if (ConciseSetUtils.isLiteral(w1)) {
                    if (ConciseSetUtils.isOneSequence(w2)) {
                        return 1;
                    }
                    if (ConciseSetUtils.isLiteral(w2)) {
                        return 0;
                    }
                    return -1;
                }
                if (!ConciseSetUtils.isZeroSequence(w2)) {
                    return 1;
                }
                return ImmutableConciseSet.compareInts(ConciseSetUtils.getSequenceNumWords(w1), ConciseSetUtils.getSequenceNumWords(w2));
            }
        }).create();
        while (sets.hasNext()) {
            ImmutableConciseSet set = sets.next();
            if (set == null || set.isEmpty()) continue;
            WordIterator itr = set.newWordIterator();
            theQ.add(new WordHolder(itr.next(), itr));
        }
        int currIndex = 0;
        while (!theQ.isEmpty()) {
            WordHolder nextVal;
            ArrayList<WordHolder> wordsToAdd = Lists.newArrayList();
            WordHolder curr = (WordHolder)theQ.poll();
            int word = curr.getWord();
            WordIterator itr = curr.getIterator();
            if (currIndex < itr.startIndex) {
                ImmutableConciseSet.addAndCompact(retVal, itr.startIndex - currIndex - 1);
                currIndex = itr.startIndex;
            }
            if (ConciseSetUtils.isOneSequence(word)) {
                int flipBitLiteral = ConciseSetUtils.getLiteralFromOneSeqFlipBit(word);
                nextVal = (WordHolder)theQ.peek();
                while (nextVal != null && nextVal.getIterator().startIndex < itr.wordsWalked) {
                    WordHolder entry = (WordHolder)theQ.poll();
                    int w = entry.getWord();
                    WordIterator i = entry.getIterator();
                    if (i.startIndex == itr.startIndex) {
                        flipBitLiteral = ConciseSetUtils.isOneSequence(w) ? (flipBitLiteral |= ConciseSetUtils.getLiteralFromOneSeqFlipBit(w)) : (ConciseSetUtils.isLiteral(w) ? (flipBitLiteral |= w) : (flipBitLiteral |= ConciseSetUtils.getLiteralFromZeroSeqFlipBit(w)));
                    }
                    i.advanceTo(itr.wordsWalked);
                    if (i.hasNext()) {
                        wordsToAdd.add(new WordHolder(i.next(), i));
                    }
                    nextVal = (WordHolder)theQ.peek();
                }
                int newWord = word & 0xC1FFFFFF;
                if (flipBitLiteral != -1) {
                    int position = Integer.numberOfTrailingZeros(flipBitLiteral ^= 0xFFFFFFFF) + 1;
                    newWord |= position << 25;
                }
                ImmutableConciseSet.addAndCompact(retVal, newWord);
                currIndex = itr.wordsWalked;
                if (itr.hasNext()) {
                    wordsToAdd.add(new WordHolder(itr.next(), itr));
                }
            } else if (ConciseSetUtils.isLiteral(word)) {
                WordHolder nextVal2 = (WordHolder)theQ.peek();
                while (nextVal2 != null && nextVal2.getIterator().startIndex == itr.startIndex) {
                    WordHolder entry = (WordHolder)theQ.poll();
                    int w = entry.getWord();
                    WordIterator i = entry.getIterator();
                    if (ConciseSetUtils.isLiteral(w)) {
                        word |= w;
                    } else {
                        int flipBitLiteral = ConciseSetUtils.getLiteralFromZeroSeqFlipBit(w);
                        if (flipBitLiteral != Integer.MIN_VALUE) {
                            word |= flipBitLiteral;
                            i.advanceTo(itr.wordsWalked);
                        }
                    }
                    if (i.hasNext()) {
                        wordsToAdd.add(new WordHolder(i.next(), i));
                    }
                    nextVal2 = (WordHolder)theQ.peek();
                }
                ImmutableConciseSet.addAndCompact(retVal, word);
                ++currIndex;
                if (itr.hasNext()) {
                    wordsToAdd.add(new WordHolder(itr.next(), itr));
                }
            } else {
                nextVal = (WordHolder)theQ.peek();
                while (nextVal != null && nextVal.getIterator().startIndex == itr.startIndex) {
                    WordHolder entry = (WordHolder)theQ.poll();
                    int w = entry.getWord();
                    WordIterator i = entry.getIterator();
                    int flipBitLiteral = ConciseSetUtils.getLiteralFromZeroSeqFlipBit(w);
                    if (flipBitLiteral != Integer.MIN_VALUE) {
                        wordsToAdd.add(new WordHolder(flipBitLiteral, i));
                    } else if (i.hasNext()) {
                        wordsToAdd.add(new WordHolder(i.next(), i));
                    }
                    nextVal = (WordHolder)theQ.peek();
                }
                int flipBitLiteral = ConciseSetUtils.getLiteralFromZeroSeqFlipBit(word);
                if (flipBitLiteral != Integer.MIN_VALUE) {
                    wordsToAdd.add(new WordHolder(flipBitLiteral, itr));
                } else if (itr.hasNext()) {
                    wordsToAdd.add(new WordHolder(itr.next(), itr));
                }
            }
            theQ.addAll(wordsToAdd);
        }
        if (retVal.isEmpty()) {
            return new ImmutableConciseSet();
        }
        return new ImmutableConciseSet(IntBuffer.wrap(retVal.toArray()));
    }

    public static ImmutableConciseSet doIntersection(Iterator<ImmutableConciseSet> sets) {
        IntList retVal = new IntList();
        MinMaxPriorityQueue theQ = MinMaxPriorityQueue.orderedBy(new Comparator<WordHolder>(){

            @Override
            public int compare(WordHolder h1, WordHolder h2) {
                int s2;
                int w1 = h1.getWord();
                int w2 = h2.getWord();
                int s1 = h1.getIterator().startIndex;
                if (s1 != (s2 = h2.getIterator().startIndex)) {
                    return ImmutableConciseSet.compareInts(s1, s2);
                }
                if (ConciseSetUtils.isZeroSequence(w1)) {
                    if (ConciseSetUtils.isZeroSequence(w2)) {
                        return -ImmutableConciseSet.compareInts(ConciseSetUtils.getSequenceNumWords(w1), ConciseSetUtils.getSequenceNumWords(w2));
                    }
                    return -1;
                }
                if (ConciseSetUtils.isLiteral(w1)) {
                    if (ConciseSetUtils.isZeroSequence(w2)) {
                        return 1;
                    }
                    if (ConciseSetUtils.isLiteral(w2)) {
                        return 0;
                    }
                    return -1;
                }
                if (!ConciseSetUtils.isOneSequence(w2)) {
                    return 1;
                }
                return ImmutableConciseSet.compareInts(ConciseSetUtils.getSequenceNumWords(w1), ConciseSetUtils.getSequenceNumWords(w2));
            }
        }).create();
        while (sets.hasNext()) {
            ImmutableConciseSet set = sets.next();
            if (set == null || set.isEmpty()) {
                return new ImmutableConciseSet();
            }
            WordIterator itr = set.newWordIterator();
            theQ.add(new WordHolder(itr.next(), itr));
        }
        int currIndex = 0;
        int wordsWalkedAtSequenceEnd = Integer.MAX_VALUE;
        while (!theQ.isEmpty()) {
            WordHolder nextVal;
            int flipBitLiteral;
            ArrayList<WordHolder> wordsToAdd = Lists.newArrayList();
            WordHolder curr = (WordHolder)theQ.poll();
            int word = curr.getWord();
            WordIterator itr = curr.getIterator();
            if (itr.startIndex >= wordsWalkedAtSequenceEnd) break;
            if (currIndex < itr.startIndex) {
                ImmutableConciseSet.addAndCompact(retVal, 0x40000000 | itr.startIndex - currIndex - 1);
                currIndex = itr.startIndex;
            }
            if (ConciseSetUtils.isZeroSequence(word)) {
                flipBitLiteral = ConciseSetUtils.getLiteralFromZeroSeqFlipBit(word);
                nextVal = (WordHolder)theQ.peek();
                while (nextVal != null && nextVal.getIterator().startIndex < itr.wordsWalked) {
                    WordHolder entry = (WordHolder)theQ.poll();
                    int w = entry.getWord();
                    WordIterator i = entry.getIterator();
                    if (i.startIndex == itr.startIndex) {
                        flipBitLiteral = ConciseSetUtils.isZeroSequence(w) ? (flipBitLiteral &= ConciseSetUtils.getLiteralFromZeroSeqFlipBit(w)) : (ConciseSetUtils.isLiteral(w) ? (flipBitLiteral &= w) : (flipBitLiteral &= ConciseSetUtils.getLiteralFromOneSeqFlipBit(w)));
                    }
                    i.advanceTo(itr.wordsWalked);
                    if (i.hasNext()) {
                        wordsToAdd.add(new WordHolder(i.next(), i));
                    } else {
                        wordsWalkedAtSequenceEnd = Math.min(i.wordsWalked, wordsWalkedAtSequenceEnd);
                    }
                    nextVal = (WordHolder)theQ.peek();
                }
                int newWord = word & 0xC1FFFFFF;
                if (flipBitLiteral != Integer.MIN_VALUE) {
                    int position = Integer.numberOfTrailingZeros(flipBitLiteral) + 1;
                    newWord = word & 0xC1FFFFFF | position << 25;
                }
                ImmutableConciseSet.addAndCompact(retVal, newWord);
                currIndex = itr.wordsWalked;
                if (itr.hasNext()) {
                    wordsToAdd.add(new WordHolder(itr.next(), itr));
                } else {
                    wordsWalkedAtSequenceEnd = Math.min(itr.wordsWalked, wordsWalkedAtSequenceEnd);
                }
            } else if (ConciseSetUtils.isLiteral(word)) {
                WordHolder nextVal2 = (WordHolder)theQ.peek();
                while (nextVal2 != null && nextVal2.getIterator().startIndex == itr.startIndex) {
                    WordHolder entry = (WordHolder)theQ.poll();
                    int w = entry.getWord();
                    WordIterator i = entry.getIterator();
                    if (ConciseSetUtils.isLiteral(w)) {
                        word &= w;
                    } else {
                        int flipBitLiteral2 = ConciseSetUtils.getLiteralFromOneSeqFlipBit(w);
                        if (flipBitLiteral2 != -1) {
                            word &= flipBitLiteral2;
                            i.advanceTo(itr.wordsWalked);
                        }
                    }
                    if (i.hasNext()) {
                        wordsToAdd.add(new WordHolder(i.next(), i));
                    } else {
                        wordsWalkedAtSequenceEnd = Math.min(i.wordsWalked, wordsWalkedAtSequenceEnd);
                    }
                    nextVal2 = (WordHolder)theQ.peek();
                }
                ImmutableConciseSet.addAndCompact(retVal, word);
                ++currIndex;
                if (itr.hasNext()) {
                    wordsToAdd.add(new WordHolder(itr.next(), itr));
                } else {
                    wordsWalkedAtSequenceEnd = Math.min(itr.wordsWalked, wordsWalkedAtSequenceEnd);
                }
            } else {
                nextVal = (WordHolder)theQ.peek();
                while (nextVal != null && nextVal.getIterator().startIndex == itr.startIndex) {
                    WordHolder entry = (WordHolder)theQ.poll();
                    int w = entry.getWord();
                    WordIterator i = entry.getIterator();
                    flipBitLiteral = ConciseSetUtils.getLiteralFromOneSeqFlipBit(w);
                    if (flipBitLiteral != -1) {
                        wordsToAdd.add(new WordHolder(flipBitLiteral, i));
                    } else if (i.hasNext()) {
                        wordsToAdd.add(new WordHolder(i.next(), i));
                    } else {
                        wordsWalkedAtSequenceEnd = Math.min(i.wordsWalked, wordsWalkedAtSequenceEnd);
                    }
                    nextVal = (WordHolder)theQ.peek();
                }
                flipBitLiteral = ConciseSetUtils.getLiteralFromOneSeqFlipBit(word);
                if (flipBitLiteral != -1) {
                    wordsToAdd.add(new WordHolder(flipBitLiteral, itr));
                } else if (itr.hasNext()) {
                    wordsToAdd.add(new WordHolder(itr.next(), itr));
                } else {
                    wordsWalkedAtSequenceEnd = Math.min(itr.wordsWalked, wordsWalkedAtSequenceEnd);
                }
            }
            theQ.addAll(wordsToAdd);
        }
        if (currIndex < wordsWalkedAtSequenceEnd) {
            ImmutableConciseSet.addAndCompact(retVal, 0x40000000 | wordsWalkedAtSequenceEnd - currIndex - 1);
        }
        if (retVal.isEmpty()) {
            return new ImmutableConciseSet();
        }
        return new ImmutableConciseSet(IntBuffer.wrap(retVal.toArray()));
    }

    public static ImmutableConciseSet doComplement(ImmutableConciseSet set) {
        if (set == null || set.isEmpty()) {
            return new ImmutableConciseSet();
        }
        IntList retVal = new IntList();
        WordIterator iter = set.newWordIterator();
        while (iter.hasNext()) {
            int word = iter.next();
            if (ConciseSetUtils.isLiteral(word)) {
                retVal.add(Integer.MIN_VALUE | ~word);
                continue;
            }
            retVal.add(0x40000000 ^ word);
        }
        int lastWord = retVal.get(retVal.length() - 1);
        if (ConciseSetUtils.isLiteral(lastWord)) {
            lastWord = ConciseSetUtils.clearBitsAfterInLastWord(lastWord, ConciseSetUtils.maxLiteralLengthModulus(set.getLast()));
        }
        retVal.set(retVal.length() - 1, lastWord);
        ImmutableConciseSet.trimZeros(retVal);
        if (retVal.isEmpty()) {
            return new ImmutableConciseSet();
        }
        return new ImmutableConciseSet(IntBuffer.wrap(retVal.toArray()));
    }

    private static void trimZeros(IntList set) {
        int last = set.length() - 1;
        do {
            int w;
            if ((w = set.get(last)) == Integer.MIN_VALUE) {
                set.set(last, 0);
                --last;
                continue;
            }
            if (ConciseSetUtils.isZeroSequence(w)) {
                if (ConciseSetUtils.isSequenceWithNoBits(w)) {
                    set.set(last, 0);
                    --last;
                    continue;
                }
                set.set(last, ConciseSetUtils.getLiteral(w, false));
                return;
            }
            return;
        } while (!set.isEmpty() && last != -1);
    }

    public ImmutableConciseSet() {
        this.words = null;
        this.lastWordIndex = -1;
        this.size = 0;
    }

    public ImmutableConciseSet(ByteBuffer byteBuffer) {
        this.words = byteBuffer.asIntBuffer();
        this.lastWordIndex = this.words.capacity() - 1;
        this.size = this.calcSize();
    }

    public ImmutableConciseSet(IntBuffer buffer) {
        this.words = buffer;
        this.lastWordIndex = this.words == null || buffer.capacity() == 0 ? -1 : this.words.capacity() - 1;
        this.size = this.calcSize();
    }

    public byte[] toBytes() {
        if (this.words == null) {
            return new byte[0];
        }
        ByteBuffer buf = ByteBuffer.allocate(this.words.capacity() * 4);
        buf.asIntBuffer().put(this.words.asReadOnlyBuffer());
        return buf.array();
    }

    public int getLastWordIndex() {
        return this.lastWordIndex;
    }

    private int calcSize() {
        int retVal = 0;
        for (int i = 0; i <= this.lastWordIndex; ++i) {
            int w = this.words.get(i);
            if (ConciseSetUtils.isLiteral(w)) {
                retVal += ConciseSetUtils.getLiteralBitCount(w);
                continue;
            }
            if (ConciseSetUtils.isZeroSequence(w)) {
                if (ConciseSetUtils.isSequenceWithNoBits(w)) continue;
                ++retVal;
                continue;
            }
            retVal += ConciseSetUtils.maxLiteralLengthMultiplication(ConciseSetUtils.getSequenceCount(w) + 1);
            if (ConciseSetUtils.isSequenceWithNoBits(w)) continue;
            --retVal;
        }
        return retVal;
    }

    public int size() {
        return this.size;
    }

    public int getLast() {
        if (this.isEmpty()) {
            return -1;
        }
        int last = 0;
        for (int i = 0; i <= this.lastWordIndex; ++i) {
            int w = this.words.get(i);
            if (ConciseSetUtils.isLiteral(w)) {
                last += 31;
                continue;
            }
            last += ConciseSetUtils.maxLiteralLengthMultiplication(ConciseSetUtils.getSequenceCount(w) + 1);
        }
        int w = this.words.get(this.lastWordIndex);
        last = ConciseSetUtils.isLiteral(w) ? (last -= Integer.numberOfLeadingZeros(ConciseSetUtils.getLiteralBits(w))) : --last;
        return last;
    }

    public boolean contains(int integer) {
        if (this.isEmpty()) {
            return false;
        }
        IntSet.IntIterator intIterator = this.iterator();
        intIterator.skipAllBefore(integer);
        return intIterator.hasNext() && intIterator.next() == integer;
    }

    public int get(int i) {
        if (i < 0) {
            throw new IndexOutOfBoundsException();
        }
        int firstSetBitInWord = 0;
        int position = i;
        int setBitsInCurrentWord = 0;
        for (int j = 0; j <= this.lastWordIndex; ++j) {
            int w = this.words.get(j);
            if (ConciseSetUtils.isLiteral(w)) {
                setBitsInCurrentWord = ConciseSetUtils.getLiteralBitCount(w);
                if (position < setBitsInCurrentWord) {
                    int currSetBitInWord = -1;
                    while (position >= 0) {
                        currSetBitInWord = Integer.numberOfTrailingZeros(w & -1 << currSetBitInWord + 1);
                        --position;
                    }
                    return firstSetBitInWord + currSetBitInWord;
                }
                firstSetBitInWord += 31;
            } else {
                int sequenceLength = ConciseSetUtils.maxLiteralLengthMultiplication(ConciseSetUtils.getSequenceCount(w) + 1);
                if (ConciseSetUtils.isOneSequence(w)) {
                    if (ConciseSetUtils.isSequenceWithNoBits(w)) {
                        setBitsInCurrentWord = sequenceLength;
                        if (position < setBitsInCurrentWord) {
                            return firstSetBitInWord + position;
                        }
                    } else {
                        setBitsInCurrentWord = sequenceLength - 1;
                        if (position < setBitsInCurrentWord) {
                            return firstSetBitInWord + position + (position < ConciseSetUtils.getFlippedBit(w) ? 0 : 1);
                        }
                    }
                } else if (ConciseSetUtils.isSequenceWithNoBits(w)) {
                    setBitsInCurrentWord = 0;
                } else {
                    setBitsInCurrentWord = 1;
                    if (position == 0) {
                        return firstSetBitInWord + ConciseSetUtils.getFlippedBit(w);
                    }
                }
                firstSetBitInWord += sequenceLength;
            }
            position -= setBitsInCurrentWord;
        }
        throw new IndexOutOfBoundsException(Integer.toString(i));
    }

    public int compareTo(ImmutableConciseSet other) {
        return this.words.asReadOnlyBuffer().compareTo(other.words.asReadOnlyBuffer());
    }

    private boolean isEmpty() {
        return this.words == null || this.words.limit() == 0;
    }

    public String toString() {
        IntSet.IntIterator itr = this.iterator();
        if (!itr.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            sb.append(itr.next());
            if (!itr.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    public IntSet.IntIterator iterator() {
        if (this.isEmpty()) {
            return new IntSet.IntIterator(){

                @Override
                public void skipAllBefore(int element) {
                }

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public int next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public IntSet.IntIterator clone() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new BitIterator();
    }

    public WordIterator newWordIterator() {
        return new WordIterator();
    }

    private static class WordHolder {
        private final int word;
        private final WordIterator iterator;

        public WordHolder(int word, WordIterator iterator) {
            this.word = word;
            this.iterator = iterator;
        }

        public int getWord() {
            return this.word;
        }

        public WordIterator getIterator() {
            return this.iterator;
        }
    }

    public class WordIterator
    implements Iterator {
        private int startIndex = -1;
        private int wordsWalked = 0;
        private int currWord;
        private int nextWord;
        private int currRow = -1;
        private volatile boolean hasNextWord = false;

        WordIterator() {
        }

        public void advanceTo(int endCount) {
            while (this.hasNext() && this.wordsWalked < endCount) {
                this.next();
            }
            if (this.wordsWalked <= endCount) {
                return;
            }
            this.nextWord = this.currWord & 0xC1000000 | this.wordsWalked - endCount - 1;
            this.startIndex = endCount;
            this.hasNextWord = true;
        }

        @Override
        public boolean hasNext() {
            if (ImmutableConciseSet.this.isEmpty()) {
                return false;
            }
            if (this.hasNextWord) {
                return true;
            }
            return this.currRow < ImmutableConciseSet.this.words.capacity() - 1;
        }

        public Integer next() {
            if (this.hasNextWord) {
                this.currWord = this.nextWord;
                this.hasNextWord = false;
                return new Integer(this.currWord);
            }
            this.currWord = ImmutableConciseSet.this.words.get(++this.currRow);
            if (ConciseSetUtils.isLiteral(this.currWord)) {
                this.startIndex = this.wordsWalked++;
            } else {
                this.startIndex = this.wordsWalked;
                this.wordsWalked += ConciseSetUtils.getSequenceNumWords(this.currWord);
            }
            return new Integer(this.currWord);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class BitIterator
    implements IntSet.IntIterator {
        final ConciseSetUtils.LiteralAndZeroFillExpander litExp;
        final ConciseSetUtils.OneFillExpander oneExp;
        ConciseSetUtils.WordExpander exp;
        int nextIndex = 0;
        int nextOffset = 0;

        private BitIterator() {
            this.litExp = ConciseSetUtils.newLiteralAndZeroFillExpander();
            this.oneExp = ConciseSetUtils.newOneFillExpander();
            this.nextWord();
        }

        private BitIterator(ConciseSetUtils.LiteralAndZeroFillExpander litExp, ConciseSetUtils.OneFillExpander oneExp, ConciseSetUtils.WordExpander exp, int nextIndex, int nextOffset) {
            this.litExp = litExp;
            this.oneExp = oneExp;
            this.exp = exp;
            this.nextIndex = nextIndex;
            this.nextOffset = nextOffset;
        }

        @Override
        public boolean hasNext() {
            while (!this.exp.hasNext()) {
                if (this.nextIndex > ImmutableConciseSet.this.lastWordIndex) {
                    return false;
                }
                this.nextWord();
            }
            return true;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.exp.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void skipAllBefore(int element) {
            while (true) {
                this.exp.skipAllBefore(element);
                if (this.exp.hasNext() || this.nextIndex > ImmutableConciseSet.this.lastWordIndex) {
                    return;
                }
                this.nextWord();
            }
        }

        @Override
        public IntSet.IntIterator clone() {
            return new BitIterator((ConciseSetUtils.LiteralAndZeroFillExpander)this.litExp.clone(), (ConciseSetUtils.OneFillExpander)this.oneExp.clone(), this.exp.clone(), this.nextIndex, this.nextOffset);
        }

        private void nextWord() {
            int word = ImmutableConciseSet.this.words.get(this.nextIndex++);
            this.exp = ConciseSetUtils.isOneSequence(word) ? this.oneExp : this.litExp;
            this.exp.reset(this.nextOffset, word, true);
            this.nextOffset = ConciseSetUtils.isLiteral(word) ? (this.nextOffset += 31) : (this.nextOffset += ConciseSetUtils.maxLiteralLengthMultiplication(ConciseSetUtils.getSequenceCount(word) + 1));
        }
    }
}

