/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.hive.druid.org.apache.calcite.materialize.Lattice;
import org.apache.hive.druid.org.apache.calcite.materialize.TileKey;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptLattice;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.SubstitutionVisitor;
import org.apache.hive.druid.org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.hive.druid.org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.AggregateCall;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.impl.StarTable;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAggFunction;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.mapping.AbstractSourceMapping;

public class AggregateStarTableRule
extends RelOptRule {
    public static final AggregateStarTableRule INSTANCE = new AggregateStarTableRule(AggregateStarTableRule.operand(Aggregate.class, null, Aggregate.IS_SIMPLE, AggregateStarTableRule.some(AggregateStarTableRule.operand(StarTable.StarTableScan.class, AggregateStarTableRule.none()), new RelOptRuleOperand[0])), "AggregateStarTableRule");
    public static final AggregateStarTableRule INSTANCE2 = new AggregateStarTableRule(AggregateStarTableRule.operand(Aggregate.class, null, Aggregate.IS_SIMPLE, AggregateStarTableRule.operand(Project.class, AggregateStarTableRule.operand(StarTable.StarTableScan.class, AggregateStarTableRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "AggregateStarTableRule:project"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Aggregate aggregate2;
            Project project2;
            Aggregate aggregate = (Aggregate)call.rel(0);
            Project project = (Project)call.rel(1);
            StarTable.StarTableScan scan = (StarTable.StarTableScan)call.rel(2);
            RelNode rel = AggregateProjectMergeRule.apply(call, aggregate, project);
            if (rel instanceof Aggregate) {
                project2 = null;
                aggregate2 = (Aggregate)rel;
            } else if (rel instanceof Project) {
                project2 = (Project)rel;
                aggregate2 = (Aggregate)project2.getInput();
            } else {
                return;
            }
            this.apply(call, project2, aggregate2, scan);
        }
    };

    private AggregateStarTableRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        StarTable.StarTableScan scan = (StarTable.StarTableScan)call.rel(1);
        this.apply(call, null, aggregate, scan);
    }

    protected void apply(RelOptRuleCall call, Project postProject, final Aggregate aggregate, StarTable.StarTableScan scan) {
        RelOptCluster cluster = scan.getCluster();
        RelOptTable table = scan.getTable();
        RelOptLattice lattice = call.getPlanner().getLattice(table);
        final List<Lattice.Measure> measures = lattice.lattice.toMeasures(aggregate.getAggCallList());
        Pair<CalciteSchema.TableEntry, TileKey> pair = lattice.getAggregate(call.getPlanner(), aggregate.getGroupSet(), measures);
        if (pair == null) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        CalciteSchema.TableEntry tableEntry = (CalciteSchema.TableEntry)pair.left;
        final TileKey tileKey = (TileKey)pair.right;
        RelMetadataQuery mq = RelMetadataQuery.instance();
        double rowCount = aggregate.estimateRowCount(mq);
        Table aggregateTable = tableEntry.getTable();
        RelDataType aggregateTableRowType = aggregateTable.getRowType(cluster.getTypeFactory());
        RelOptTableImpl aggregateRelOptTable = RelOptTableImpl.create(table.getRelOptSchema(), aggregateTableRowType, tableEntry, rowCount);
        relBuilder.push(aggregateRelOptTable.toRel(RelOptUtil.getContext(cluster)));
        if (tileKey == null) {
            if (CalcitePrepareImpl.DEBUG) {
                System.out.println("Using materialization " + aggregateRelOptTable.getQualifiedName() + " (exact match)");
            }
        } else if (!tileKey.dimensions.equals(aggregate.getGroupSet())) {
            if (CalcitePrepareImpl.DEBUG) {
                System.out.println("Using materialization " + aggregateRelOptTable.getQualifiedName() + ", rolling up " + tileKey.dimensions + " to " + aggregate.getGroupSet());
            }
            assert (tileKey.dimensions.contains(aggregate.getGroupSet()));
            ArrayList<AggregateCall> aggCalls = Lists.newArrayList();
            ImmutableBitSet.Builder groupSet = ImmutableBitSet.builder();
            Iterator<Object> iterator = aggregate.getGroupSet().iterator();
            while (iterator.hasNext()) {
                int key = iterator.next();
                groupSet.set(tileKey.dimensions.indexOf(key));
            }
            for (AggregateCall aggCall : aggregate.getAggCallList()) {
                AggregateCall copy = AggregateStarTableRule.rollUp(groupSet.cardinality(), relBuilder, aggCall, tileKey);
                if (copy == null) {
                    return;
                }
                aggCalls.add(copy);
            }
            relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), false, groupSet.build(), null, aggCalls));
        } else if (!tileKey.measures.equals(measures)) {
            if (CalcitePrepareImpl.DEBUG) {
                System.out.println("Using materialization " + aggregateRelOptTable.getQualifiedName() + ", right granularity, but different measures " + aggregate.getAggCallList());
            }
            relBuilder.project(relBuilder.fields(new AbstractSourceMapping(tileKey.dimensions.cardinality() + tileKey.measures.size(), aggregate.getRowType().getFieldCount()){

                @Override
                public int getSourceOpt(int source) {
                    assert (aggregate.getIndicatorCount() == 0);
                    if (source < aggregate.getGroupCount()) {
                        int in = tileKey.dimensions.nth(source);
                        return aggregate.getGroupSet().indexOf(in);
                    }
                    Lattice.Measure measure = (Lattice.Measure)measures.get(source - aggregate.getGroupCount());
                    int i = tileKey.measures.indexOf(measure);
                    assert (i >= 0);
                    return tileKey.dimensions.cardinality() + i;
                }
            }.inverse()));
        }
        if (postProject != null) {
            relBuilder.push(postProject.copy(postProject.getTraitSet(), ImmutableList.of(relBuilder.peek())));
        }
        call.transformTo(relBuilder.build());
    }

    private static AggregateCall rollUp(int groupCount, RelBuilder relBuilder, AggregateCall aggregateCall, TileKey tileKey) {
        block4: {
            SqlAggFunction roll;
            if (aggregateCall.isDistinct()) {
                return null;
            }
            SqlAggFunction aggregation = aggregateCall.getAggregation();
            Pair<SqlAggFunction, List<Integer>> seek = Pair.of(aggregation, aggregateCall.getArgList());
            int offset = tileKey.dimensions.cardinality();
            ImmutableList<Lattice.Measure> measures = tileKey.measures;
            int i = AggregateStarTableRule.find(measures, seek);
            if (i >= 0 && (roll = SubstitutionVisitor.getRollup(aggregation)) != null) {
                return AggregateCall.create(roll, false, ImmutableList.of(Integer.valueOf(offset + i)), -1, groupCount, relBuilder.peek(), null, aggregateCall.name);
            }
            ArrayList<Integer> newArgs = Lists.newArrayList();
            for (Integer arg : aggregateCall.getArgList()) {
                int z = tileKey.dimensions.indexOf(arg);
                if (z >= 0) {
                    newArgs.add(z);
                    continue;
                }
                break block4;
            }
            return AggregateCall.create(aggregation, false, newArgs, -1, groupCount, relBuilder.peek(), null, aggregateCall.name);
        }
        return null;
    }

    private static int find(ImmutableList<Lattice.Measure> measures, Pair<SqlAggFunction, List<Integer>> seek) {
        for (int i = 0; i < measures.size(); ++i) {
            Lattice.Measure measure = (Lattice.Measure)measures.get(i);
            if (!measure.agg.equals(seek.left) || !measure.argOrdinals().equals(seek.right)) continue;
            return i;
        }
        return -1;
    }
}

