/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.plan;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;

public class Strong {
    private final ImmutableBitSet nullColumns;

    private Strong(ImmutableBitSet nullColumns) {
        this.nullColumns = nullColumns;
    }

    public static Strong of(ImmutableBitSet nullColumns) {
        return new Strong(nullColumns);
    }

    public static boolean is(RexNode node, ImmutableBitSet nullColumns) {
        return Strong.of(nullColumns).strong(node);
    }

    private boolean strong(RexNode node) {
        switch (node.getKind()) {
            case LITERAL: {
                return ((RexLiteral)node).getValue() == null;
            }
            case IS_TRUE: 
            case IS_NOT_NULL: 
            case AND: 
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return this.anyStrong(((RexCall)node).getOperands());
            }
            case OR: {
                return this.allStrong(((RexCall)node).getOperands());
            }
            case INPUT_REF: {
                return this.nullColumns.get(((RexInputRef)node).getIndex());
            }
        }
        return false;
    }

    private boolean allStrong(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (this.strong(operand)) continue;
            return false;
        }
        return true;
    }

    private boolean anyStrong(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (!this.strong(operand)) continue;
            return true;
        }
        return false;
    }
}

