/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.materialize;

import java.util.concurrent.ExecutionException;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.cache.CacheBuilder;
import org.apache.hive.druid.com.google.common.cache.CacheLoader;
import org.apache.hive.druid.com.google.common.cache.LoadingCache;
import org.apache.hive.druid.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.hive.druid.org.apache.calcite.materialize.Lattice;
import org.apache.hive.druid.org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.hive.druid.org.apache.calcite.util.Pair;

class CachingLatticeStatisticProvider
implements LatticeStatisticProvider {
    private final LoadingCache<Pair<Lattice, Lattice.Column>, Integer> cache;

    public CachingLatticeStatisticProvider(final LatticeStatisticProvider provider) {
        this.cache = CacheBuilder.newBuilder().build(new CacheLoader<Pair<Lattice, Lattice.Column>, Integer>(){

            @Override
            public Integer load(Pair<Lattice, Lattice.Column> key) throws Exception {
                return provider.cardinality((Lattice)key.left, (Lattice.Column)key.right);
            }
        });
    }

    @Override
    public int cardinality(Lattice lattice, Lattice.Column column) {
        try {
            return this.cache.get(Pair.of(lattice, column));
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }
}

