/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server;

import com.google.inject.Inject;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.client.CachingClusteredClient;
import org.apache.hive.druid.io.druid.query.FluentQueryRunnerBuilder;
import org.apache.hive.druid.io.druid.query.PostProcessingOperator;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.query.RetryQueryRunner;
import org.apache.hive.druid.io.druid.query.RetryQueryRunnerConfig;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.joda.time.Interval;

public class ClientQuerySegmentWalker
implements QuerySegmentWalker {
    private final ServiceEmitter emitter;
    private final CachingClusteredClient baseClient;
    private final QueryToolChestWarehouse warehouse;
    private final RetryQueryRunnerConfig retryConfig;
    private final ObjectMapper objectMapper;

    @Inject
    public ClientQuerySegmentWalker(ServiceEmitter emitter, CachingClusteredClient baseClient, QueryToolChestWarehouse warehouse, RetryQueryRunnerConfig retryConfig, ObjectMapper objectMapper) {
        this.emitter = emitter;
        this.baseClient = baseClient;
        this.warehouse = warehouse;
        this.retryConfig = retryConfig;
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return this.makeRunner(query);
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        return this.makeRunner(query);
    }

    private <T> QueryRunner<T> makeRunner(Query<T> query) {
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        PostProcessingOperator postProcessing = (PostProcessingOperator)this.objectMapper.convertValue(query.getContextValue("postProcessing"), new TypeReference<PostProcessingOperator<T>>(){});
        return new FluentQueryRunnerBuilder(toolChest).create(new RetryQueryRunner(this.baseClient, toolChest, this.retryConfig, this.objectMapper)).applyPreMergeDecoration().mergeResults().applyPostMergeDecoration().emitCPUTimeMetric(this.emitter).postProcess(postProcessing);
    }
}

