/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public class SegmentIdentifier {
    private final String dataSource;
    private final Interval interval;
    private final String version;
    private final ShardSpec shardSpec;
    private final String asString;

    @JsonCreator
    public SegmentIdentifier(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="shardSpec") ShardSpec shardSpec) {
        this.dataSource = Preconditions.checkNotNull(dataSource, "dataSource");
        this.interval = Preconditions.checkNotNull(interval, "interval");
        this.version = Preconditions.checkNotNull(version, "version");
        this.shardSpec = Preconditions.checkNotNull(shardSpec, "shardSpec");
        this.asString = DataSegment.makeDataSegmentIdentifier(dataSource, interval.getStart(), interval.getEnd(), version, shardSpec);
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    public String getIdentifierAsString() {
        return this.asString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentIdentifier that = (SegmentIdentifier)o;
        return Objects.equals(this.asString, that.asString);
    }

    public int hashCode() {
        return this.asString.hashCode();
    }

    public String toString() {
        return this.asString;
    }

    public static SegmentIdentifier fromDataSegment(DataSegment segment) {
        return new SegmentIdentifier(segment.getDataSource(), segment.getInterval(), segment.getVersion(), segment.getShardSpec());
    }
}

