/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.metamx.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.com.metamx.collections.spatial.ImmutableRTree;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;

public class IndexedRTree
implements Comparable<IndexedRTree> {
    private static Ordering<ImmutableRTree> comparator = new Ordering<ImmutableRTree>(){

        @Override
        public int compare(ImmutableRTree tree, ImmutableRTree tree1) {
            if (tree.size() == 0 && tree1.size() == 0) {
                return 0;
            }
            if (tree.size() == 0) {
                return -1;
            }
            if (tree1.size() == 0) {
                return 1;
            }
            return tree.compareTo(tree1);
        }
    }.nullsFirst();
    private final ImmutableRTree immutableRTree;

    public IndexedRTree(ImmutableRTree immutableRTree) {
        this.immutableRTree = immutableRTree;
    }

    @Override
    public int compareTo(IndexedRTree spatialIndexedInts) {
        return this.immutableRTree.compareTo(spatialIndexedInts.getImmutableRTree());
    }

    public ImmutableRTree getImmutableRTree() {
        return this.immutableRTree;
    }

    public static class ImmutableRTreeObjectStrategy
    implements ObjectStrategy<ImmutableRTree> {
        private final BitmapFactory bitmapFactory;

        public ImmutableRTreeObjectStrategy(BitmapFactory bitmapFactory) {
            this.bitmapFactory = bitmapFactory;
        }

        @Override
        public Class<? extends ImmutableRTree> getClazz() {
            return ImmutableRTree.class;
        }

        @Override
        public ImmutableRTree fromByteBuffer(ByteBuffer buffer, int numBytes) {
            ByteBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
            readOnlyBuffer.limit(readOnlyBuffer.position() + numBytes);
            return new ImmutableRTree(readOnlyBuffer, this.bitmapFactory);
        }

        @Override
        public byte[] toBytes(ImmutableRTree val) {
            if (val == null || val.size() == 0) {
                return new byte[0];
            }
            return val.toBytes();
        }

        @Override
        public int compare(ImmutableRTree o1, ImmutableRTree o2) {
            return comparator.compare(o1, o2);
        }
    }
}

