/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.topn.TopNAlgorithm;
import org.apache.hive.druid.io.druid.query.topn.TopNMetricSpecBuilder;
import org.apache.hive.druid.io.druid.query.topn.TopNParams;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNResultBuilder;
import org.apache.hive.druid.io.druid.segment.Capabilities;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;

public abstract class BaseTopNAlgorithm<DimValSelector, DimValAggregateStore, Parameters extends TopNParams>
implements TopNAlgorithm<DimValSelector, Parameters> {
    private final Capabilities capabilities;

    protected static Aggregator[] makeAggregators(Cursor cursor, List<AggregatorFactory> aggregatorSpecs) {
        Aggregator[] aggregators = new Aggregator[aggregatorSpecs.size()];
        int aggregatorIndex = 0;
        for (AggregatorFactory spec : aggregatorSpecs) {
            aggregators[aggregatorIndex] = spec.factorize(cursor);
            ++aggregatorIndex;
        }
        return aggregators;
    }

    protected static BufferAggregator[] makeBufferAggregators(Cursor cursor, List<AggregatorFactory> aggregatorSpecs) {
        BufferAggregator[] aggregators = new BufferAggregator[aggregatorSpecs.size()];
        int aggregatorIndex = 0;
        for (AggregatorFactory spec : aggregatorSpecs) {
            aggregators[aggregatorIndex] = spec.factorizeBuffered(cursor);
            ++aggregatorIndex;
        }
        return aggregators;
    }

    protected BaseTopNAlgorithm(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public void run(Parameters params, TopNResultBuilder resultBuilder, DimValSelector dimValSelector) {
        int numToProcess;
        boolean hasDimValSelector = dimValSelector != null;
        int cardinality = ((TopNParams)params).getCardinality();
        for (int numProcessed = 0; numProcessed < cardinality; numProcessed += numToProcess) {
            DimValSelector theDimValSelector;
            int maxNumToProcess = Math.min(((TopNParams)params).getNumValuesPerPass(), cardinality - numProcessed);
            if (!hasDimValSelector) {
                numToProcess = maxNumToProcess;
                theDimValSelector = this.makeDimValSelector(params, numProcessed, numToProcess);
            } else {
                numToProcess = this.computeNewLength(dimValSelector, numProcessed, maxNumToProcess);
                theDimValSelector = this.updateDimValSelector(dimValSelector, numProcessed, numToProcess);
            }
            DimValAggregateStore aggregatesStore = this.makeDimValAggregateStore(params);
            this.scanAndAggregate(params, theDimValSelector, aggregatesStore, numProcessed);
            this.updateResults(params, theDimValSelector, aggregatesStore, resultBuilder);
            this.closeAggregators(aggregatesStore);
            ((TopNParams)params).getCursor().reset();
        }
    }

    protected abstract DimValSelector makeDimValSelector(Parameters var1, int var2, int var3);

    protected int computeNewLength(DimValSelector dimValSelector, int numProcessed, int numToProcess) {
        return numToProcess;
    }

    protected abstract DimValSelector updateDimValSelector(DimValSelector var1, int var2, int var3);

    protected abstract DimValAggregateStore makeDimValAggregateStore(Parameters var1);

    protected abstract void scanAndAggregate(Parameters var1, DimValSelector var2, DimValAggregateStore var3, int var4);

    protected abstract void updateResults(Parameters var1, DimValSelector var2, DimValAggregateStore var3, TopNResultBuilder var4);

    protected abstract void closeAggregators(DimValAggregateStore var1);

    public static TopNResultBuilder makeResultBuilder(TopNParams params, TopNQuery query) {
        Comparator comparator = query.getTopNMetricSpec().getComparator(query.getAggregatorSpecs(), query.getPostAggregatorSpecs());
        return query.getTopNMetricSpec().getResultBuilder(params.getCursor().getTime(), query.getDimensionSpec(), query.getThreshold(), comparator, query.getAggregatorSpecs(), query.getPostAggregatorSpecs());
    }

    protected static abstract class BaseArrayProvider<T>
    implements TopNMetricSpecBuilder<T> {
        private volatile String previousStop;
        private volatile boolean ignoreAfterThreshold;
        private volatile int ignoreFirstN;
        private volatile int keepOnlyN;
        private final DimensionSelector dimSelector;
        private final TopNQuery query;
        private final Capabilities capabilities;

        public BaseArrayProvider(DimensionSelector dimSelector, TopNQuery query, Capabilities capabilities) {
            this.dimSelector = dimSelector;
            this.query = query;
            this.capabilities = capabilities;
            this.previousStop = null;
            this.ignoreAfterThreshold = false;
            this.ignoreFirstN = 0;
            this.keepOnlyN = dimSelector.getValueCardinality();
            if (this.keepOnlyN < 0) {
                throw new UnsupportedOperationException("Cannot operate on a dimension with no dictionary");
            }
        }

        @Override
        public void skipTo(String previousStop) {
            if (this.capabilities.dimensionValuesSorted()) {
                this.previousStop = previousStop;
            }
        }

        @Override
        public void ignoreAfterThreshold() {
            this.ignoreAfterThreshold = true;
        }

        @Override
        public void ignoreFirstN(int n) {
            this.ignoreFirstN = n;
        }

        @Override
        public void keepOnlyN(int n) {
            this.keepOnlyN = n;
        }

        protected Pair<Integer, Integer> computeStartEnd(int cardinality) {
            int startIndex = this.ignoreFirstN;
            if (this.previousStop != null) {
                int lookupId = this.dimSelector.lookupId(this.previousStop) + 1;
                if (lookupId < 0) {
                    lookupId *= -1;
                }
                startIndex = lookupId > this.ignoreFirstN + this.keepOnlyN ? this.ignoreFirstN + this.keepOnlyN : Math.max(lookupId, startIndex);
            }
            int endIndex = Math.min(this.ignoreFirstN + this.keepOnlyN, cardinality);
            if (this.ignoreAfterThreshold && this.query.getDimensionsFilter() == null) {
                endIndex = Math.min(endIndex, startIndex + this.query.getThreshold());
            }
            return Pair.of(startIndex, endIndex);
        }
    }

    protected class AggregatorArrayProvider
    extends BaseArrayProvider<Aggregator[][]> {
        Aggregator[][] expansionAggs;
        int cardinality;

        public AggregatorArrayProvider(DimensionSelector dimSelector, TopNQuery query, int cardinality) {
            super(dimSelector, query, BaseTopNAlgorithm.this.capabilities);
            this.expansionAggs = new Aggregator[cardinality][];
            this.cardinality = cardinality;
        }

        @Override
        public Aggregator[][] build() {
            Pair<Integer, Integer> startEnd = this.computeStartEnd(this.cardinality);
            Arrays.fill((Object[])this.expansionAggs, 0, (int)((Integer)startEnd.lhs), TopNAlgorithm.EMPTY_ARRAY);
            Arrays.fill((Object[])this.expansionAggs, (int)((Integer)startEnd.lhs), (int)((Integer)startEnd.rhs), null);
            Arrays.fill((Object[])this.expansionAggs, (int)((Integer)startEnd.rhs), this.expansionAggs.length, TopNAlgorithm.EMPTY_ARRAY);
            return this.expansionAggs;
        }
    }
}

