/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.MappingIterator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.BufferGrouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Groupers;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.TemporaryStorageFullException;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;

public class SpillingGrouper<KeyType extends Comparable<KeyType>>
implements Grouper<KeyType> {
    private static final Logger log = new Logger(SpillingGrouper.class);
    private final BufferGrouper<KeyType> grouper;
    private final Grouper.KeySerde<KeyType> keySerde;
    private final LimitedTemporaryStorage temporaryStorage;
    private final ObjectMapper spillMapper;
    private final AggregatorFactory[] aggregatorFactories;
    private final List<File> files = Lists.newArrayList();
    private final List<Closeable> closeables = Lists.newArrayList();
    private boolean spillingAllowed = false;

    public SpillingGrouper(ByteBuffer buffer, Grouper.KeySerdeFactory<KeyType> keySerdeFactory, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, int bufferGrouperMaxSize, float bufferGrouperMaxLoadFactor, int bufferGrouperInitialBuckets, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, boolean spillingAllowed) {
        this.keySerde = keySerdeFactory.factorize();
        this.grouper = new BufferGrouper<KeyType>(buffer, this.keySerde, columnSelectorFactory, aggregatorFactories, bufferGrouperMaxSize, bufferGrouperMaxLoadFactor, bufferGrouperInitialBuckets);
        this.aggregatorFactories = aggregatorFactories;
        this.temporaryStorage = temporaryStorage;
        this.spillMapper = spillMapper;
        this.spillingAllowed = spillingAllowed;
    }

    @Override
    public boolean aggregate(KeyType key, int keyHash) {
        if (this.grouper.aggregate(key, keyHash)) {
            return true;
        }
        if (this.spillingAllowed) {
            try {
                this.spill();
            }
            catch (TemporaryStorageFullException e) {
                return false;
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
            return this.grouper.aggregate(key, keyHash);
        }
        return false;
    }

    @Override
    public boolean aggregate(KeyType key) {
        return this.aggregate(key, Groupers.hash(key));
    }

    @Override
    public void reset() {
        this.grouper.reset();
        this.deleteFiles();
    }

    @Override
    public void close() {
        this.grouper.close();
        this.deleteFiles();
    }

    public void setSpillingAllowed(boolean spillingAllowed) {
        this.spillingAllowed = spillingAllowed;
    }

    @Override
    public Iterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        ArrayList iterators = new ArrayList(1 + this.files.size());
        iterators.add(this.grouper.iterator(sorted));
        for (File file : this.files) {
            MappingIterator<Grouper.Entry<KeyType>> fileIterator = this.read(file, this.keySerde.keyClazz());
            iterators.add(Iterators.transform(fileIterator, new Function<Grouper.Entry<KeyType>, Grouper.Entry<KeyType>>(){

                @Override
                public Grouper.Entry<KeyType> apply(Grouper.Entry<KeyType> entry) {
                    Object[] deserializedValues = new Object[entry.getValues().length];
                    for (int i = 0; i < deserializedValues.length; ++i) {
                        deserializedValues[i] = SpillingGrouper.this.aggregatorFactories[i].deserialize(entry.getValues()[i]);
                        if (!(deserializedValues[i] instanceof Integer)) continue;
                        deserializedValues[i] = ((Integer)deserializedValues[i]).longValue();
                    }
                    return new Grouper.Entry(entry.getKey(), deserializedValues);
                }
            }));
            this.closeables.add(fileIterator);
        }
        return Groupers.mergeIterators(iterators, sorted);
    }

    private void spill() throws IOException {
        File outFile;
        try (LimitedTemporaryStorage.LimitedOutputStream out = this.temporaryStorage.createFile();
             LZ4BlockOutputStream compressedOut = new LZ4BlockOutputStream(out);
             JsonGenerator jsonGenerator = this.spillMapper.getFactory().createGenerator(compressedOut);){
            outFile = out.getFile();
            Iterator<Grouper.Entry<KeyType>> it = this.grouper.iterator(true);
            while (it.hasNext()) {
                if (Thread.interrupted()) {
                    throw new QueryInterruptedException(new InterruptedException());
                }
                jsonGenerator.writeObject(it.next());
            }
        }
        this.files.add(outFile);
        this.grouper.reset();
    }

    private MappingIterator<Grouper.Entry<KeyType>> read(File file, Class<KeyType> keyClazz) {
        try {
            return this.spillMapper.readValues(this.spillMapper.getFactory().createParser(new LZ4BlockInputStream(new FileInputStream(file))), this.spillMapper.getTypeFactory().constructParametricType(Grouper.Entry.class, keyClazz));
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private void deleteFiles() {
        for (Closeable closeable : this.closeables) {
            CloseQuietly.close(closeable);
        }
        for (File file : this.files) {
            this.temporaryStorage.delete(file);
        }
        this.files.clear();
    }
}

