/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.granularity.AllGranularity;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.ConcurrentGrouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.SpillingGrouper;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategyV2;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.joda.time.DateTime;

public class RowBasedGrouperHelper {
    public static Pair<Grouper<RowBasedKey>, Accumulator<Grouper<RowBasedKey>, Row>> createGrouperAccumulatorPair(final GroupByQuery query, final boolean isInputRaw, GroupByQueryConfig config, ByteBuffer buffer, int concurrencyHint, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, AggregatorFactory[] aggregatorFactories) {
        DimensionSelector[] dimensionSelectors;
        Preconditions.checkArgument(concurrencyHint >= 1 || concurrencyHint == -1, "invalid concurrencyHint");
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        DateTime fudgeTimestamp = GroupByStrategyV2.getUniversalTimestamp(query);
        RowBasedKeySerdeFactory keySerdeFactory = new RowBasedKeySerdeFactory(fudgeTimestamp, query.getDimensions().size(), querySpecificConfig.getMaxMergingDictionarySize() / (long)(concurrencyHint == -1 ? 1 : concurrencyHint));
        final RowBasedColumnSelectorFactory columnSelectorFactory = new RowBasedColumnSelectorFactory();
        Grouper<RowBasedKey> grouper = concurrencyHint == -1 ? new SpillingGrouper<RowBasedKey>(buffer, keySerdeFactory, columnSelectorFactory, aggregatorFactories, querySpecificConfig.getBufferGrouperMaxSize(), querySpecificConfig.getBufferGrouperMaxLoadFactor(), querySpecificConfig.getBufferGrouperInitialBuckets(), temporaryStorage, spillMapper, true) : new ConcurrentGrouper<RowBasedKey>(buffer, keySerdeFactory, columnSelectorFactory, aggregatorFactories, querySpecificConfig.getBufferGrouperMaxSize(), querySpecificConfig.getBufferGrouperMaxLoadFactor(), querySpecificConfig.getBufferGrouperInitialBuckets(), temporaryStorage, spillMapper, concurrencyHint);
        if (isInputRaw) {
            dimensionSelectors = new DimensionSelector[query.getDimensions().size()];
            for (int i = 0; i < dimensionSelectors.length; ++i) {
                dimensionSelectors[i] = columnSelectorFactory.makeDimensionSelector(query.getDimensions().get(i));
            }
        } else {
            dimensionSelectors = null;
        }
        Accumulator<Grouper<RowBasedKey>, Row> accumulator = new Accumulator<Grouper<RowBasedKey>, Row>(){

            @Override
            public Grouper<RowBasedKey> accumulate(Grouper<RowBasedKey> theGrouper, Row row) {
                if (Thread.interrupted()) {
                    throw new QueryInterruptedException(new InterruptedException());
                }
                if (theGrouper == null) {
                    return null;
                }
                long timestamp = row.getTimestampFromEpoch();
                if (isInputRaw) {
                    timestamp = query.getGranularity() instanceof AllGranularity ? query.getIntervals().get(0).getStartMillis() : query.getGranularity().truncate(timestamp);
                }
                columnSelectorFactory.setRow(row);
                String[] dimensions = new String[query.getDimensions().size()];
                for (int i = 0; i < dimensions.length; ++i) {
                    IndexedInts index;
                    String value = isInputRaw ? ((index = dimensionSelectors[i].getRow()).size() == 0 ? "" : dimensionSelectors[i].lookupName(index.get(0))) : (String)row.getRaw(query.getDimensions().get(i).getOutputName());
                    dimensions[i] = Strings.nullToEmpty(value);
                }
                boolean didAggregate = theGrouper.aggregate(new RowBasedKey(timestamp, dimensions));
                if (!didAggregate) {
                    return null;
                }
                columnSelectorFactory.setRow(null);
                return theGrouper;
            }
        };
        return new Pair<Grouper<RowBasedKey>, Accumulator<Grouper<RowBasedKey>, Row>>(grouper, accumulator);
    }

    public static CloseableGrouperIterator<RowBasedKey, Row> makeGrouperIterator(Grouper<RowBasedKey> grouper, final GroupByQuery query, Closeable closeable) {
        return new CloseableGrouperIterator<RowBasedKey, Row>(grouper, true, new Function<Grouper.Entry<RowBasedKey>, Row>(){

            @Override
            public Row apply(Grouper.Entry<RowBasedKey> entry) {
                int i;
                LinkedHashMap<String, Object> theMap = Maps.newLinkedHashMap();
                for (i = 0; i < entry.getKey().getDimensions().length; ++i) {
                    theMap.put(query.getDimensions().get(i).getOutputName(), Strings.emptyToNull(entry.getKey().getDimensions()[i]));
                }
                for (i = 0; i < entry.getValues().length; ++i) {
                    theMap.put(query.getAggregatorSpecs().get(i).getName(), entry.getValues()[i]);
                }
                return new MapBasedRow(query.getGranularity().toDateTime(entry.getKey().getTimestamp()), theMap);
            }
        }, closeable);
    }

    private static class RowBasedColumnSelectorFactory
    implements ColumnSelectorFactory {
        private ThreadLocal<Row> row = new ThreadLocal();

        private RowBasedColumnSelectorFactory() {
        }

        public void setRow(Row row) {
            this.row.set(row);
        }

        @Override
        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
        }

        private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
            final String dimension = dimensionSpec.getDimension();
            final ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
            return new DimensionSelector(){

                @Override
                public IndexedInts getRow() {
                    List<String> dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                    final ArrayList<Integer> vals = Lists.newArrayList();
                    if (dimensionValues != null) {
                        for (int i = 0; i < dimensionValues.size(); ++i) {
                            vals.add(i);
                        }
                    }
                    return new IndexedInts(){

                        @Override
                        public int size() {
                            return vals.size();
                        }

                        @Override
                        public int get(int index) {
                            return (Integer)vals.get(index);
                        }

                        @Override
                        public Iterator<Integer> iterator() {
                            return vals.iterator();
                        }

                        @Override
                        public void close() throws IOException {
                        }

                        @Override
                        public void fill(int index, int[] toFill) {
                            throw new UnsupportedOperationException("fill not supported");
                        }
                    };
                }

                @Override
                public int getValueCardinality() {
                    return -1;
                }

                @Override
                public String lookupName(int id) {
                    String value = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension).get(id);
                    return extractionFn == null ? value : extractionFn.apply(value);
                }

                @Override
                public int lookupId(String name) {
                    if (extractionFn != null) {
                        throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                    }
                    return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension).indexOf(name);
                }
            };
        }

        @Override
        public FloatColumnSelector makeFloatColumnSelector(final String columnName) {
            return new FloatColumnSelector(){

                @Override
                public float get() {
                    return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getFloatMetric(columnName);
                }
            };
        }

        @Override
        public LongColumnSelector makeLongColumnSelector(final String columnName) {
            if (columnName.equals("__time")) {
                return new LongColumnSelector(){

                    @Override
                    public long get() {
                        return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch();
                    }
                };
            }
            return new LongColumnSelector(){

                @Override
                public long get() {
                    return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getLongMetric(columnName);
                }
            };
        }

        @Override
        public ObjectColumnSelector makeObjectColumnSelector(final String columnName) {
            return new ObjectColumnSelector(){

                public Class classOfObject() {
                    return Object.class;
                }

                public Object get() {
                    return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getRaw(columnName);
                }
            };
        }

        @Override
        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return null;
        }
    }

    private static class RowBasedKeySerde
    implements Grouper.KeySerde<RowBasedKey> {
        private static final int ROUGH_OVERHEAD_PER_DICTIONARY_ENTRY = 44;
        private final DateTime fudgeTimestamp;
        private final int dimCount;
        private final int keySize;
        private final ByteBuffer keyBuffer;
        private final List<String> dictionary = Lists.newArrayList();
        private final Map<String, Integer> reverseDictionary = Maps.newHashMap();
        private final long maxDictionarySize;
        private long currentEstimatedSize = 0L;
        private int[] sortableIds = null;

        public RowBasedKeySerde(DateTime fudgeTimestamp, int dimCount, long maxDictionarySize) {
            this.fudgeTimestamp = fudgeTimestamp;
            this.dimCount = dimCount;
            this.maxDictionarySize = maxDictionarySize;
            this.keySize = (fudgeTimestamp == null ? 8 : 0) + dimCount * 4;
            this.keyBuffer = ByteBuffer.allocate(this.keySize);
        }

        @Override
        public int keySize() {
            return this.keySize;
        }

        @Override
        public Class<RowBasedKey> keyClazz() {
            return RowBasedKey.class;
        }

        @Override
        public ByteBuffer toByteBuffer(RowBasedKey key) {
            this.keyBuffer.rewind();
            if (this.fudgeTimestamp == null) {
                this.keyBuffer.putLong(key.getTimestamp());
            }
            for (int i = 0; i < key.getDimensions().length; ++i) {
                int id = this.addToDictionary(key.getDimensions()[i]);
                if (id < 0) {
                    return null;
                }
                this.keyBuffer.putInt(id);
            }
            this.keyBuffer.flip();
            return this.keyBuffer;
        }

        @Override
        public RowBasedKey fromByteBuffer(ByteBuffer buffer, int position) {
            long timestamp = this.fudgeTimestamp == null ? buffer.getLong(position) : this.fudgeTimestamp.getMillis();
            String[] dimensions = new String[this.dimCount];
            int dimsPosition = this.fudgeTimestamp == null ? position + 8 : position;
            for (int i = 0; i < dimensions.length; ++i) {
                dimensions[i] = this.dictionary.get(buffer.getInt(dimsPosition + 4 * i));
            }
            return new RowBasedKey(timestamp, dimensions);
        }

        @Override
        public Grouper.KeyComparator comparator() {
            if (this.sortableIds == null) {
                TreeMap<String, Integer> sortedMap = Maps.newTreeMap();
                for (int id = 0; id < this.dictionary.size(); ++id) {
                    sortedMap.put(this.dictionary.get(id), id);
                }
                this.sortableIds = new int[this.dictionary.size()];
                int index = 0;
                for (Integer id : sortedMap.values()) {
                    this.sortableIds[id.intValue()] = index++;
                }
            }
            if (this.fudgeTimestamp == null) {
                return new Grouper.KeyComparator(){

                    @Override
                    public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                        int timeCompare = Longs.compare(lhsBuffer.getLong(lhsPosition), rhsBuffer.getLong(rhsPosition));
                        if (timeCompare != 0) {
                            return timeCompare;
                        }
                        for (int i = 0; i < RowBasedKeySerde.this.dimCount; ++i) {
                            int cmp = Ints.compare(RowBasedKeySerde.this.sortableIds[lhsBuffer.getInt(lhsPosition + 8 + 4 * i)], RowBasedKeySerde.this.sortableIds[rhsBuffer.getInt(rhsPosition + 8 + 4 * i)]);
                            if (cmp == 0) continue;
                            return cmp;
                        }
                        return 0;
                    }
                };
            }
            return new Grouper.KeyComparator(){

                @Override
                public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                    for (int i = 0; i < RowBasedKeySerde.this.dimCount; ++i) {
                        int cmp = Ints.compare(RowBasedKeySerde.this.sortableIds[lhsBuffer.getInt(lhsPosition + 4 * i)], RowBasedKeySerde.this.sortableIds[rhsBuffer.getInt(rhsPosition + 4 * i)]);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
            };
        }

        @Override
        public void reset() {
            this.dictionary.clear();
            this.reverseDictionary.clear();
            this.sortableIds = null;
            this.currentEstimatedSize = 0L;
        }

        private int addToDictionary(String s) {
            Integer idx = this.reverseDictionary.get(s);
            if (idx == null) {
                long additionalEstimatedSize = (long)s.length() * 2L + 44L;
                if (this.currentEstimatedSize + additionalEstimatedSize > this.maxDictionarySize) {
                    return -1;
                }
                idx = this.dictionary.size();
                this.reverseDictionary.put(s, idx);
                this.dictionary.add(s);
                this.currentEstimatedSize += additionalEstimatedSize;
            }
            return idx;
        }
    }

    private static class RowBasedKeySerdeFactory
    implements Grouper.KeySerdeFactory<RowBasedKey> {
        private final DateTime fudgeTimestamp;
        private final int dimCount;
        private final long maxDictionarySize;

        public RowBasedKeySerdeFactory(DateTime fudgeTimestamp, int dimCount, long maxDictionarySize) {
            this.fudgeTimestamp = fudgeTimestamp;
            this.dimCount = dimCount;
            this.maxDictionarySize = maxDictionarySize;
        }

        @Override
        public Grouper.KeySerde<RowBasedKey> factorize() {
            return new RowBasedKeySerde(this.fudgeTimestamp, this.dimCount, this.maxDictionarySize);
        }
    }

    static class RowBasedKey
    implements Comparable<RowBasedKey> {
        private final long timestamp;
        private final String[] dimensions;

        @JsonCreator
        public RowBasedKey(@JsonProperty(value="t") long timestamp, @JsonProperty(value="d") String[] dimensions) {
            this.timestamp = timestamp;
            this.dimensions = dimensions;
        }

        @JsonProperty(value="t")
        public long getTimestamp() {
            return this.timestamp;
        }

        @JsonProperty(value="d")
        public String[] getDimensions() {
            return this.dimensions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowBasedKey that = (RowBasedKey)o;
            if (this.timestamp != that.timestamp) {
                return false;
            }
            return Arrays.equals(this.dimensions, that.dimensions);
        }

        public int hashCode() {
            int result = (int)(this.timestamp ^ this.timestamp >>> 32);
            result = 31 * result + Arrays.hashCode(this.dimensions);
            return result;
        }

        @Override
        public int compareTo(RowBasedKey other) {
            int timeCompare = Longs.compare(this.timestamp, other.getTimestamp());
            if (timeCompare != 0) {
                return timeCompare;
            }
            for (int i = 0; i < this.dimensions.length; ++i) {
                int cmp = this.dimensions[i].compareTo(other.getDimensions()[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        public String toString() {
            return "RowBasedKey{timestamp=" + this.timestamp + ", dimensions=" + Arrays.toString(this.dimensions) + '}';
        }
    }
}

