/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;

public class MetricValueExtractor {
    private final Map<String, Object> value;

    @JsonCreator
    public MetricValueExtractor(Map<String, Object> value) {
        this.value = value;
    }

    @JsonValue
    public Map<String, Object> getBaseObject() {
        return this.value;
    }

    public Float getFloatMetric(String name) {
        Object retVal = this.value.get(name);
        return retVal == null ? null : Float.valueOf(((Number)retVal).floatValue());
    }

    public Double getDoubleMetric(String name) {
        Object retVal = this.value.get(name);
        return retVal == null ? null : Double.valueOf(((Number)retVal).doubleValue());
    }

    public Long getLongMetric(String name) {
        Object retVal = this.value.get(name);
        return retVal == null ? null : Long.valueOf(((Number)retVal).longValue());
    }

    public Object getMetric(String name) {
        return this.value.get(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricValueExtractor that = (MetricValueExtractor)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "MetricValueExtractor{value=" + this.value + '}';
    }
}

