/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.wrappers.matrix;

import it.uniroma3.mat.extendedset.wrappers.matrix.Pair;
import it.uniroma3.mat.extendedset.wrappers.matrix.PairSet;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PairMap<T, I, V>
extends AbstractMap<Pair<T, I>, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4699094886888004702L;
    private final PairSet<T, I> keys;
    private final ArrayList<V> values;

    public PairMap(PairSet<T, I> keys) {
        this.keys = keys;
        this.values = new ArrayList(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            this.values.add(null);
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public V get(Object key) {
        if (key == null || !(key instanceof Pair)) {
            return null;
        }
        int index = this.keys.indexOf((Pair)key);
        if (index < 0) {
            return null;
        }
        return this.values.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public V put(Pair<T, I> key, V value) {
        boolean isNew = this.keys.add(key);
        int index = this.keys.indexOf(key);
        V old = null;
        if (isNew) {
            this.values.add(index, value);
        } else {
            old = this.values.set(index, value);
        }
        return old;
    }

    @Override
    public V remove(Object key) {
        if (key == null || !(key instanceof Pair)) {
            return null;
        }
        int index = this.keys.indexOf((Pair)key);
        if (index < 0) {
            return null;
        }
        this.keys.remove(key);
        return this.values.remove(index);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public PairMap<T, I, V> clone() {
        PairMap<T, I, V> cloned = new PairMap<T, I, V>(this.keys.clone());
        cloned.values.clear();
        cloned.values.addAll(this.values);
        return cloned;
    }

    @Override
    public Set<Pair<T, I>> keySet() {
        return new AbstractSet<Pair<T, I>>(){

            @Override
            public boolean add(Pair<T, I> e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                PairMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                return PairMap.this.keys.contains(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return PairMap.this.keys.containsAll(c);
            }

            @Override
            public boolean isEmpty() {
                return PairMap.this.keys.isEmpty();
            }

            @Override
            public Iterator<Pair<T, I>> iterator() {
                return new Iterator<Pair<T, I>>(){
                    Iterator<Pair<T, I>> itr;
                    {
                        this.itr = PairMap.this.keys.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.itr.hasNext();
                    }

                    @Override
                    public Pair<T, I> next() {
                        return this.itr.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return PairMap.this.keys.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public boolean add(V e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                PairMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                return PairMap.this.values.contains(o);
            }

            @Override
            public boolean isEmpty() {
                return PairMap.this.keys.isEmpty();
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<V> itr;
                    {
                        this.itr = PairMap.this.values.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.itr.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.itr.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return PairMap.this.values.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<Pair<T, I>, V>> entrySet() {
        return new AbstractSet<Map.Entry<Pair<T, I>, V>>(){

            @Override
            public boolean add(Map.Entry<Pair<T, I>, V> e) {
                Object res = PairMap.this.put(e.getKey(), e.getValue());
                return res != e.getValue();
            }

            @Override
            public void clear() {
                PairMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                return o != null && o instanceof Map.Entry && PairMap.this.containsKey(((Map.Entry)o).getKey()) && PairMap.this.containsValue(((Map.Entry)o).getValue());
            }

            @Override
            public boolean isEmpty() {
                return PairMap.this.keys.isEmpty();
            }

            @Override
            public Iterator<Map.Entry<Pair<T, I>, V>> iterator() {
                return new Iterator<Map.Entry<Pair<T, I>, V>>(){
                    final Iterator<Pair<T, I>> keyItr;
                    int valueIndex;
                    {
                        this.keyItr = PairMap.this.keys.iterator();
                        this.valueIndex = -1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyItr.hasNext();
                    }

                    @Override
                    public Map.Entry<Pair<T, I>, V> next() {
                        final Pair key = this.keyItr.next();
                        ++this.valueIndex;
                        return new Map.Entry<Pair<T, I>, V>(){

                            @Override
                            public Pair<T, I> getKey() {
                                return key;
                            }

                            @Override
                            public V getValue() {
                                return PairMap.this.values.get(valueIndex);
                            }

                            @Override
                            public V setValue(V value) {
                                return PairMap.this.values.set(valueIndex, value);
                            }

                            public String toString() {
                                return "{" + this.getKey() + "=" + this.getValue() + "}";
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return PairMap.this.keys.size();
            }
        };
    }
}

