/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.common.util.RetryUtilities;
import org.junit.Assert;
import org.junit.Test;

public class TestRetryUtilities {
    @Test(expected=IllegalArgumentException.class)
    public void testZeroBatchSize() {
        new DummyExponentiallyDecayingBatchWork(0, 2, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeBatchSize() {
        new DummyExponentiallyDecayingBatchWork(-1, 2, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroDecayingFactor() {
        new DummyExponentiallyDecayingBatchWork(5, 0, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOneDecayingFactor() {
        new DummyExponentiallyDecayingBatchWork(10, 1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeMaxRetries() {
        new DummyExponentiallyDecayingBatchWork(10, 2, 0, -1);
    }

    @Test
    public void testNumberOfAttempts() throws Exception {
        DummyExponentiallyDecayingBatchWork dummy = new DummyExponentiallyDecayingBatchWork(10, 2, 0);
        dummy.run();
        Assert.assertEquals((String)"Unexpected number of executions of execute method", (long)1L, (long)dummy.getCount());
        Assert.assertArrayEquals((int[])new int[]{10}, (int[])dummy.getBatchSizes());
        dummy = new DummyExponentiallyDecayingBatchWork(11, 2, 0);
        dummy.run();
        Assert.assertEquals((String)"Unexpected number of executions of execute method", (long)1L, (long)dummy.getCount());
        Assert.assertArrayEquals((int[])new int[]{11}, (int[])dummy.getBatchSizes());
        dummy = new DummyExponentiallyDecayingBatchWork(11, 3, 1);
        dummy.run();
        Assert.assertEquals((String)"Unexpected number of executions of execute method", (long)2L, (long)dummy.getCount());
        Assert.assertArrayEquals((int[])new int[]{11, 3}, (int[])dummy.getBatchSizes());
        dummy = new DummyExponentiallyDecayingBatchWork(11, 3, 2);
        dummy.run();
        Assert.assertEquals((String)"Unexpected number of executions of execute method", (long)3L, (long)dummy.getCount());
        Assert.assertArrayEquals((int[])new int[]{11, 3, 1}, (int[])dummy.getBatchSizes());
        dummy = new DummyExponentiallyDecayingBatchWork(12, 3, 2);
        dummy.run();
        Assert.assertEquals((String)"Unexpected number of executions of execute method", (long)3L, (long)dummy.getCount());
        Assert.assertArrayEquals((int[])new int[]{12, 4, 1}, (int[])dummy.getBatchSizes());
    }

    @Test
    public void testZeroMaxRetriesValue() throws Exception {
        DummyExponentiallyDecayingBatchWork dummy = new DummyExponentiallyDecayingBatchWork(10, 2, 3, 0);
        dummy.run();
        Assert.assertEquals((String)"Unexpected number of executions of execute method", (long)4L, (long)dummy.getCount());
        Assert.assertArrayEquals((int[])new int[]{10, 5, 2, 1}, (int[])dummy.getBatchSizes());
        dummy = new DummyExponentiallyDecayingBatchWork(17, 2, 4, 0);
        dummy.run();
        Assert.assertEquals((String)"Unexpected number of executions of execute method", (long)5L, (long)dummy.getCount());
        Assert.assertArrayEquals((int[])new int[]{17, 8, 4, 2, 1}, (int[])dummy.getBatchSizes());
    }

    @Test(expected=RetryUtilities.RetryException.class)
    public void testRetriesExhausted() throws Exception {
        DummyExponentiallyDecayingBatchWork dummy = new DummyExponentiallyDecayingBatchWork(11, 3, 3);
        dummy.run();
    }

    private class DummyExponentiallyDecayingBatchWork
    extends RetryUtilities.ExponentiallyDecayingBatchWork<Void> {
        final List<Integer> batchSizes;
        int exceptionCount;

        public DummyExponentiallyDecayingBatchWork(int batchSize, int reducingFactor, int throwException) {
            super(batchSize, reducingFactor, 0);
            this.batchSizes = new ArrayList<Integer>();
            this.exceptionCount = 0;
            this.exceptionCount = throwException;
        }

        public DummyExponentiallyDecayingBatchWork(int batchSize, int reducingFactor, int throwException, int maxRetries) {
            super(batchSize, reducingFactor, maxRetries);
            this.batchSizes = new ArrayList<Integer>();
            this.exceptionCount = 0;
            this.exceptionCount = throwException;
        }

        public Void execute(int size) throws Exception {
            this.batchSizes.add(size);
            if (this.exceptionCount > 0) {
                --this.exceptionCount;
                throw new Exception("Dummy exception");
            }
            return null;
        }

        public int getCount() {
            return this.batchSizes.size();
        }

        public int[] getBatchSizes() {
            int[] ret = new int[this.batchSizes.size()];
            int i = 0;
            for (int b : this.batchSizes) {
                ret[i++] = b;
            }
            return ret;
        }
    }
}

