/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHiveConfUtil {
    private HiveConf conf = new HiveConf();

    @Before
    public void init() {
        this.conf.setBoolean("dummyBoolean", true);
        this.conf.set("dummy", "aaa");
        this.conf.set("dummy2", "aaa");
        this.conf.set("3dummy", "aaa");
    }

    @Test
    public void testHideNonStringVar() throws Exception {
        Assert.assertTrue((boolean)this.conf.getBoolean("dummyBoolean", false));
        Assert.assertEquals((Object)"true", (Object)this.conf.get("dummyBoolean"));
        HiveConfUtil.stripConfigurations((Configuration)this.conf, (Set)Sets.newHashSet((Object[])new String[]{"dummyBoolean"}));
        Assert.assertFalse((boolean)this.conf.getBoolean("dummyBoolean", false));
        Assert.assertEquals((Object)"", (Object)this.conf.get("dummyBoolean"));
    }

    @Test
    public void testHideStringVar() throws Exception {
        Assert.assertEquals((Object)"aaa", (Object)this.conf.get("dummy"));
        HiveConfUtil.stripConfigurations((Configuration)this.conf, (Set)Sets.newHashSet((Object[])new String[]{"dummy"}));
        Assert.assertEquals((Object)"", (Object)this.conf.get("dummy"));
    }

    @Test
    public void testHideMultipleVars() throws Exception {
        Assert.assertEquals((Object)"aaa", (Object)this.conf.get("dummy"));
        Assert.assertEquals((Object)"aaa", (Object)this.conf.get("dummy2"));
        Assert.assertEquals((Object)"aaa", (Object)this.conf.get("3dummy"));
        HiveConfUtil.stripConfigurations((Configuration)this.conf, (Set)Sets.newHashSet((Object[])new String[]{"dummy"}));
        Assert.assertEquals((Object)"", (Object)this.conf.get("dummy"));
        Assert.assertEquals((Object)"", (Object)this.conf.get("dummy2"));
        Assert.assertEquals((Object)"aaa", (Object)this.conf.get("3dummy"));
    }
}

