/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.TimeZone;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestTimestampTZ {
    @Test
    public void testConvertToUTC() {
        String s = "2017-04-14 18:00:00 Asia/Shanghai";
        TimestampTZ timestampTZ = TimestampTZUtil.parse((String)s, (ZoneId)ZoneId.of("UTC"));
        Assert.assertEquals((Object)"2017-04-14 10:00:00.0 UTC", (Object)timestampTZ.toString());
    }

    @Test
    public void testComparison() {
        String s1 = "2017-04-14 18:00:00 Asia/Shanghai";
        String s2 = "2017-04-14 10:00:00.00 GMT";
        String s3 = "2017-04-14 18:00:00 UTC+08:00";
        String s4 = "2017-04-14 18:00:00 Europe/London";
        TimestampTZ tstz1 = TimestampTZUtil.parse((String)s1);
        TimestampTZ tstz2 = TimestampTZUtil.parse((String)s2);
        TimestampTZ tstz3 = TimestampTZUtil.parse((String)s3);
        TimestampTZ tstz4 = TimestampTZUtil.parse((String)s4);
        Assert.assertEquals((Object)tstz1, (Object)tstz2);
        Assert.assertEquals((Object)tstz1, (Object)tstz3);
        Assert.assertEquals((long)tstz1.hashCode(), (long)tstz2.hashCode());
        Assert.assertEquals((long)tstz1.hashCode(), (long)tstz3.hashCode());
        Assert.assertTrue((tstz1.compareTo(tstz4) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDST() {
        String s1 = "2005-04-03 02:01:00 America/Los_Angeles";
        String s2 = "2005-04-03 03:01:00 America/Los_Angeles";
        Assert.assertEquals((Object)TimestampTZUtil.parse((String)s1), (Object)TimestampTZUtil.parse((String)s2));
    }

    @Test
    public void testFromToInstant() {
        String s1 = "2017-04-14 18:00:00 UTC";
        TimestampTZ tstz = TimestampTZUtil.parse((String)s1);
        long seconds = tstz.getEpochSecond();
        int nanos = tstz.getNanos();
        Assert.assertEquals((Object)tstz, (Object)new TimestampTZ(seconds, nanos, ZoneId.of("UTC")));
        Assert.assertEquals((Object)"2017-04-14 18:00:00.123 UTC", (Object)new TimestampTZ(seconds, nanos += 123000000, ZoneId.of("UTC")).toString());
        Assert.assertEquals((Object)"2017-04-14 17:59:57.123 UTC", (Object)new TimestampTZ(seconds -= 3L, nanos, ZoneId.of("UTC")).toString());
    }

    @Test
    public void testVariations() {
        TimestampTZUtil.parse((String)"2017-01-01 13:33:00", (ZoneId)ZoneId.of("UTC"));
        TimestampTZUtil.parse((String)"2017-11-08 Europe/London");
        TimestampTZUtil.parse((String)"2017-05-20", (ZoneId)ZoneId.of("UTC"));
        TimestampTZUtil.parse((String)"2017-11-08GMT");
        TimestampTZUtil.parse((String)"2017-10-11 GMT+8:00");
        TimestampTZUtil.parse((String)"2017-05-08 07:45:00-3:00");
    }

    @Test
    public void testInvalidStrings() {
        try {
            TimestampTZUtil.parse((String)"2017-01-01 13:33:00 foo");
            Assert.fail((String)"Invalid timezone ID should cause exception");
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        try {
            TimestampTZUtil.parse((String)"2017-01-01 13:33:61");
            Assert.fail((String)"Invalid time should cause exception");
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConvertFromTimestamp() {
        TimeZone defaultZone = TimeZone.getDefault();
        try {
            String s = "2017-06-12 23:12:56.34";
            TimestampTZ tstz1 = TimestampTZUtil.convert((Timestamp)Timestamp.valueOf((String)s), (ZoneId)TimeZone.getTimeZone("Europe/London").toZoneId());
            TimestampTZ tstz2 = TimestampTZUtil.convert((Timestamp)Timestamp.valueOf((String)s), (ZoneId)TimeZone.getTimeZone("America/Los_Angeles").toZoneId());
            Assert.assertTrue((tstz1.compareTo(tstz2) < 0 ? 1 : 0) != 0);
        }
        finally {
            TimeZone.setDefault(defaultZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConvertFromTimestamp2() {
        TimeZone defaultZone = TimeZone.getDefault();
        try {
            String s = "2017-06-12 23:12:56.34";
            TimestampTZ tstz1 = TimestampTZUtil.parse((String)(s + " " + TimeZone.getTimeZone("Europe/London").getID()));
            TimestampTZ tstz2 = TimestampTZUtil.parse((String)(s + " " + TimeZone.getTimeZone("America/Los_Angeles").getID()));
            Assert.assertTrue((tstz1.compareTo(tstz2) < 0 ? 1 : 0) != 0);
        }
        finally {
            TimeZone.setDefault(defaultZone);
        }
    }
}

