/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.hadoop.hive.common.jsonexplain.Connection;
import org.apache.hadoop.hive.common.jsonexplain.DagJsonParser;
import org.apache.hadoop.hive.common.jsonexplain.Op;
import org.apache.hadoop.hive.common.jsonexplain.Stage;
import org.apache.hadoop.hive.common.jsonexplain.Vertex;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParser;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStage {
    private Stage uut;
    private Stage stageA;
    private Stage stageB;
    private TezJsonParser tezJsonParser;

    @Before
    public void setUp() {
        this.tezJsonParser = new TezJsonParser();
        this.uut = new Stage("uut", (DagJsonParser)this.tezJsonParser);
        this.stageA = new Stage("stage-a", (DagJsonParser)this.tezJsonParser);
        this.stageB = new Stage("stage-b", (DagJsonParser)this.tezJsonParser);
    }

    @Test
    public void testAddDependencyNonRoot() throws Exception {
        LinkedHashMap<String, Stage> children = new LinkedHashMap<String, Stage>();
        children.put("a", this.stageA);
        children.put("b", this.stageB);
        String jsonString = "{\"DEPENDENT STAGES\":\"a,b\"}";
        JSONObject names = new JSONObject(jsonString);
        this.uut.addDependency(names, children);
        Assert.assertEquals((long)2L, (long)this.uut.parentStages.size());
        Assert.assertEquals((Object)this.stageA, this.uut.parentStages.get(0));
        Assert.assertEquals((Object)this.stageB, this.uut.parentStages.get(1));
        Assert.assertEquals((long)1L, (long)this.stageA.childStages.size());
        Assert.assertEquals((Object)this.uut, this.stageA.childStages.get(0));
        Assert.assertEquals((long)1L, (long)this.stageB.childStages.size());
        Assert.assertEquals((Object)this.uut, this.stageB.childStages.get(0));
    }

    @Test
    public void testAddDependencyRoot() throws Exception {
        LinkedHashMap<String, Stage> children = new LinkedHashMap<String, Stage>();
        children.put("a", this.stageA);
        children.put("b", this.stageB);
        String jsonString = "{\"ROOT STAGE\":\"X\",\"DEPENDENT STAGES\":\"a,b\"}";
        JSONObject names = new JSONObject(jsonString);
        this.uut.addDependency(names, children);
        Assert.assertEquals((long)2L, (long)this.uut.parentStages.size());
        Assert.assertEquals((long)1L, (long)this.stageA.childStages.size());
        Assert.assertEquals((long)1L, (long)this.stageB.childStages.size());
    }

    @Test
    public void testExtractVertexNonTez() throws Exception {
        String jsonString = "{\"OperatorName\":{\"a\":\"A\",\"b\":\"B\"},\"attr1\":\"ATTR1\"}";
        JSONObject object = new JSONObject(jsonString);
        this.uut.extractVertex(object);
        Assert.assertEquals((Object)"OperatorName", (Object)this.uut.op.name);
        Assert.assertEquals((long)1L, (long)this.uut.attrs.size());
        Assert.assertEquals((Object)"ATTR1", this.uut.attrs.get("attr1"));
    }

    @Test
    public void testExtractVertexTezNoEdges() throws Exception {
        String jsonString = "{\"Tez\":{\"a\":\"A\",\"Vertices:\":{\"v1\":{}}}}";
        JSONObject object = new JSONObject(jsonString);
        this.uut.extractVertex(object);
        Assert.assertEquals((long)1L, (long)this.uut.vertexs.size());
        Assert.assertTrue((boolean)this.uut.vertexs.containsKey("v1"));
    }

    @Test
    public void testExtractVertexTezWithOneEdge() throws Exception {
        String jsonString = "{\"Tez\":{\"a\":\"A\",\"Vertices:\":{\"v1\":{},\"v2\":{}},\"Edges:\":{\"v2\":{\"parent\":\"v1\",\"type\":\"TYPE\"}}}}";
        JSONObject object = new JSONObject(jsonString);
        this.uut.extractVertex(object);
        Assert.assertEquals((long)2L, (long)this.uut.vertexs.size());
        Assert.assertTrue((boolean)this.uut.vertexs.containsKey("v1"));
        Assert.assertTrue((boolean)this.uut.vertexs.containsKey("v2"));
        Assert.assertEquals((long)0L, (long)((Vertex)this.uut.vertexs.get((Object)"v1")).parentConnections.size());
        Assert.assertEquals((long)1L, (long)((Vertex)this.uut.vertexs.get((Object)"v2")).parentConnections.size());
        Assert.assertEquals((Object)"v1", (Object)((Connection)((Vertex)this.uut.vertexs.get((Object)"v2")).parentConnections.get((int)0)).from.name);
        Assert.assertEquals((Object)"TYPE", (Object)((Connection)((Vertex)this.uut.vertexs.get((Object)"v2")).parentConnections.get((int)0)).type);
    }

    @Test
    public void testExtractVertexTezWithOneToManyEdge() throws Exception {
        String jsonString = "{\"Tez\":{\"a\":\"A\",\"Vertices:\":{\"v1\":{},\"v2\":{},\"v3\":{}},\"Edges:\":{\"v1\":[{\"parent\":\"v2\",\"type\":\"TYPE1\"},{\"parent\":\"v3\",\"type\":\"TYPE2\"}]}}}";
        JSONObject object = new JSONObject(jsonString);
        this.uut.extractVertex(object);
        Assert.assertEquals((long)3L, (long)this.uut.vertexs.size());
        Assert.assertTrue((boolean)this.uut.vertexs.containsKey("v1"));
        Assert.assertTrue((boolean)this.uut.vertexs.containsKey("v2"));
        Assert.assertTrue((boolean)this.uut.vertexs.containsKey("v3"));
        Assert.assertEquals((long)2L, (long)((Vertex)this.uut.vertexs.get((Object)"v1")).parentConnections.size());
        Assert.assertEquals((long)1L, (long)((Vertex)this.uut.vertexs.get((Object)"v2")).children.size());
        Assert.assertEquals((long)1L, (long)((Vertex)this.uut.vertexs.get((Object)"v3")).children.size());
        Assert.assertEquals((Object)"v1", (Object)((Vertex)((Vertex)this.uut.vertexs.get((Object)"v2")).children.get((int)0)).name);
        Assert.assertEquals((Object)"v1", (Object)((Vertex)((Vertex)this.uut.vertexs.get((Object)"v3")).children.get((int)0)).name);
        Assert.assertEquals((Object)"TYPE1", (Object)((Connection)((Vertex)this.uut.vertexs.get((Object)"v1")).parentConnections.get((int)0)).type);
        Assert.assertEquals((Object)"TYPE2", (Object)((Connection)((Vertex)this.uut.vertexs.get((Object)"v1")).parentConnections.get((int)1)).type);
    }

    @Test
    public void testExtractOpEmptyObject() throws Exception {
        JSONObject object = new JSONObject();
        Op result = this.uut.extractOp("op-name", object);
        Assert.assertEquals((Object)"op-name", (Object)result.name);
        Assert.assertEquals((long)0L, (long)result.attrs.size());
        Assert.assertNull((Object)result.vertex);
    }

    @Test
    public void testExtractOpSimple() throws Exception {
        String jsonString = "{\"a\":\"A\",\"b\":\"B\"}";
        JSONObject object = new JSONObject(jsonString);
        Op result = this.uut.extractOp("op-name", object);
        Assert.assertEquals((Object)"op-name", (Object)result.name);
        Assert.assertEquals((long)2L, (long)result.attrs.size());
        Assert.assertNull((Object)result.vertex);
    }

    @Test
    public void testExtract() throws Exception {
        String jsonString = "{\"b\":{\"b2\":\"B2\",\"b1\":\"B1\"},\"Processor Tree:\":{\"a1\":{\"t1\":\"T1\"}}}";
        JSONObject object = new JSONObject(jsonString);
        Op result = this.uut.extractOp("op-name", object);
        Assert.assertEquals((Object)"op-name", (Object)result.name);
        Assert.assertEquals((long)2L, (long)result.attrs.size());
        ArrayList attrs = new ArrayList();
        Assert.assertEquals((Object)"B1", result.attrs.get("b1"));
        Assert.assertEquals((Object)"B2", result.attrs.get("b2"));
        Assert.assertNotNull((Object)result.vertex);
    }
}

