/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.http.CustomHeadersFilter;
import org.apache.hive.http.TestFileHelper;
import org.apache.hive.http.TestFilterConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class TestCustomHeadersFilter {
    private ServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private FilterChain filterChain;
    private ArgumentCaptor<String> value = ArgumentCaptor.forClass(String.class);
    private ArgumentCaptor<String> key = ArgumentCaptor.forClass(String.class);

    public TestCustomHeadersFilter() {
        this.servletRequest = (ServletRequest)Mockito.mock(ServletRequest.class);
        this.servletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        ((HttpServletResponse)Mockito.doNothing().when((Object)this.servletResponse)).addHeader((String)this.key.capture(), (String)this.value.capture());
    }

    @Test
    public void testDoCustomFilter() throws ServletException, IOException {
        CustomHeadersFilter filter = new CustomHeadersFilter();
        TestFilterConfig filterConfig = new TestFilterConfig();
        filterConfig.setHeaders(TestFileHelper.getPath("headers.xml"));
        filter.init((FilterConfig)filterConfig);
        filter.doFilter(this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        List actualKeys = this.key.getAllValues();
        List actualValues = this.value.getAllValues();
        MatcherAssert.assertThat((Object)actualKeys, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Content-Security-Policy", "X-XSS-Protection", "X-Content-Type-Options", "Strict-Transport-Security", "Custom-Header"}));
        MatcherAssert.assertThat((Object)actualValues, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"nosniff", "1; mode=block", "max-age=31536000", "default-src https:", "custom-value"}));
    }

    @Test
    public void testNoCustomFilter() throws ServletException, IOException {
        CustomHeadersFilter filter = new CustomHeadersFilter();
        filter.init(null);
        filter.doFilter(this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        List actualKeys = this.key.getAllValues();
        List actualValues = this.value.getAllValues();
        MatcherAssert.assertThat((Object)actualKeys, (Matcher)IsNot.not((Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Content-Security-Policy", "X-XSS-Protection", "X-Content-Type-Options", "Strict-Transport-Security", "Custom-Header"})));
        MatcherAssert.assertThat((Object)actualValues, (Matcher)IsNot.not((Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"nosniff", "1; mode=block", "max-age=31536000", "default-src https:", "custom-value"})));
    }
}

