/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.BlobStorageUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBlobStorageUtils {
    private static final Configuration conf = new Configuration();

    @Before
    public void setUp() {
        conf.set(HiveConf.ConfVars.HIVE_BLOBSTORE_SUPPORTED_SCHEMES.varname, "s3a,swift");
        conf.setBoolean(HiveConf.ConfVars.HIVE_BLOBSTORE_USE_BLOBSTORE_AS_SCRATCHDIR.varname, false);
    }

    @Test
    public void testValidAndInvalidPaths() throws IOException {
        Assert.assertTrue((boolean)BlobStorageUtils.isBlobStoragePath((Configuration)conf, (Path)new Path("s3a://bucket/path")));
        Assert.assertTrue((boolean)BlobStorageUtils.isBlobStoragePath((Configuration)conf, (Path)new Path("swift://bucket/path")));
        Assert.assertFalse((boolean)BlobStorageUtils.isBlobStoragePath((Configuration)conf, (Path)new Path("/tmp/a-path")));
        Assert.assertFalse((boolean)BlobStorageUtils.isBlobStoragePath((Configuration)conf, (Path)new Path("s3fs://tmp/file")));
        Assert.assertFalse((boolean)BlobStorageUtils.isBlobStoragePath((Configuration)conf, null));
        Assert.assertFalse((boolean)BlobStorageUtils.isBlobStorageFileSystem((Configuration)conf, null));
        Assert.assertFalse((boolean)BlobStorageUtils.isBlobStoragePath((Configuration)conf, (Path)new Path(URI.create(""))));
    }

    @Test
    public void testValidAndInvalidFileSystems() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doReturn((Object)URI.create("s3a:///")).when((Object)fs)).getUri();
        Assert.assertTrue((boolean)BlobStorageUtils.isBlobStorageFileSystem((Configuration)conf, (FileSystem)fs));
        ((FileSystem)Mockito.doReturn((Object)URI.create("swift:///")).when((Object)fs)).getUri();
        Assert.assertTrue((boolean)BlobStorageUtils.isBlobStorageFileSystem((Configuration)conf, (FileSystem)fs));
        ((FileSystem)Mockito.doReturn((Object)URI.create("hdfs:///")).when((Object)fs)).getUri();
        Assert.assertFalse((boolean)BlobStorageUtils.isBlobStorageFileSystem((Configuration)conf, (FileSystem)fs));
        ((FileSystem)Mockito.doReturn((Object)URI.create("")).when((Object)fs)).getUri();
        Assert.assertFalse((boolean)BlobStorageUtils.isBlobStorageFileSystem((Configuration)conf, (FileSystem)fs));
        Assert.assertFalse((boolean)BlobStorageUtils.isBlobStorageFileSystem((Configuration)conf, null));
    }

    @Test
    public void testValidAndInvalidSchemes() {
        Assert.assertTrue((boolean)BlobStorageUtils.isBlobStorageScheme((Configuration)conf, (String)"s3a"));
        Assert.assertTrue((boolean)BlobStorageUtils.isBlobStorageScheme((Configuration)conf, (String)"swift"));
        Assert.assertFalse((boolean)BlobStorageUtils.isBlobStorageScheme((Configuration)conf, (String)"hdfs"));
        Assert.assertFalse((boolean)BlobStorageUtils.isBlobStorageScheme((Configuration)conf, (String)""));
        Assert.assertFalse((boolean)BlobStorageUtils.isBlobStorageScheme((Configuration)conf, null));
    }
}

