/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.common.util.HiveTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestBeelineArgParsing {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestBeelineArgParsing.class.getName());
    private static final String dummyDriverClazzName = "DummyDriver";
    private String connectionString;
    private String driverClazzName;
    private String driverJarFileName;
    private boolean defaultSupported;

    public TestBeelineArgParsing(String connectionString, String driverClazzName, String driverJarFileName, boolean defaultSupported) {
        this.connectionString = connectionString;
        this.driverClazzName = driverClazzName;
        this.driverJarFileName = driverJarFileName;
        this.defaultSupported = defaultSupported;
    }

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() throws IOException, InterruptedException {
        String u = HiveTestUtils.getFileFromClasspath((String)"DummyDriver.txt");
        HashMap<File, String> extraContent = new HashMap<File, String>();
        extraContent.put(new File("META-INF/services/java.sql.Driver"), dummyDriverClazzName);
        File jarFile = HiveTestUtils.genLocalJarForTest((String)u, (String)dummyDriverClazzName, extraContent);
        String pathToDummyDriver = jarFile.getAbsolutePath();
        return Arrays.asList({"jdbc:postgresql://host:5432/testdb", "org.postgresql.Driver", System.getProperty("maven.local.repository") + File.separator + "postgresql" + File.separator + "postgresql" + File.separator + "9.1-901.jdbc4" + File.separator + "postgresql-9.1-901.jdbc4.jar", true}, {"jdbc:dummy://host:5432/testdb", dummyDriverClazzName, pathToDummyDriver, false});
    }

    @Test
    public void testSimpleArgs() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "-a", "authType"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.getOpts().getAuthType().equals("authType"));
    }

    @Test
    public void testPasswordFileArgs() throws Exception {
        TestBeeline bl = new TestBeeline();
        File passFile = new File("file.password");
        passFile.deleteOnExit();
        FileOutputStream passFileOut = new FileOutputStream(passFile);
        passFileOut.write("mypass\n".getBytes());
        passFileOut.close();
        String[] args = new String[]{"-u", "url", "-n", "name", "-w", "file.password", "-p", "not-taken-if-w-is-present", "-d", "driver", "-a", "authType"};
        bl.initArgs(args);
        System.out.println(bl.connectArgs);
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name mypass driver"));
        Assert.assertTrue((boolean)bl.getOpts().getAuthType().equals("authType"));
        passFile.delete();
    }

    @Test
    public void testDuplicateArgs() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-u", "url2", "-n", "name", "-p", "password", "-d", "driver"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
    }

    @Test
    public void testQueryScripts() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "-e", "select1", "-e", "select2"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.queries.contains("select1"));
        Assert.assertTrue((boolean)bl.queries.contains("select2"));
    }

    @Test
    public void testHiveConfAndVars() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "--hiveconf", "a=avalue", "--hiveconf", "b=bvalue", "--hivevar", "c=cvalue", "--hivevar", "d=dvalue"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveConfVariables().get("a")).equals("avalue"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveConfVariables().get("b")).equals("bvalue"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveVariables().get("c")).equals("cvalue"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveVariables().get("d")).equals("dvalue"));
    }

    @Test
    public void testBeelineOpts() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "--autoCommit=true", "--verbose", "--truncateTable"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.getOpts().getAutoCommit());
        Assert.assertTrue((boolean)bl.getOpts().getVerbose());
        Assert.assertTrue((boolean)bl.getOpts().getTruncateTable());
    }

    @Test
    public void testBeelineAutoCommit() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{};
        bl.initArgs(args);
        Assert.assertTrue((boolean)bl.getOpts().getAutoCommit());
        args = new String[]{"--autoCommit=false"};
        bl.initArgs(args);
        Assert.assertFalse((boolean)bl.getOpts().getAutoCommit());
        args = new String[]{"--autoCommit=true"};
        bl.initArgs(args);
        Assert.assertTrue((boolean)bl.getOpts().getAutoCommit());
        bl.close();
    }

    @Test
    public void testBeelineShowDbInPromptOptsDefault() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertFalse((boolean)bl.getOpts().getShowDbInPrompt());
        Assert.assertEquals((Object)"", (Object)bl.getFormattedDb());
    }

    @Test
    public void testBeelineShowDbInPromptOptsTrue() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "--showDbInPrompt=true"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.getOpts().getShowDbInPrompt());
        Assert.assertEquals((Object)" (default)", (Object)bl.getFormattedDb());
    }

    @Test
    public void testScriptFile() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "-f", "myscript"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.getOpts().getScriptFile().equals("myscript"));
    }

    @Test
    public void testCommandAndFileSimultaneously() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-e", "myselect", "-f", "myscript"};
        Assert.assertEquals((long)1L, (long)bl.initArgs(args));
    }

    @Test
    public void testMultipleInitFiles() {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-i", "/url/to/file1", "-i", "/url/to/file2"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        String[] files = bl.getOpts().getInitFiles();
        Assert.assertEquals((Object)"/url/to/file1", (Object)files[0]);
        Assert.assertEquals((Object)"/url/to/file2", (Object)files[1]);
    }

    @Test
    public void testHelp() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"--help"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertEquals((Object)true, (Object)bl.getOpts().isHelpAsked());
    }

    @Test
    public void testUnmatchedArgs() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n"};
        Assert.assertEquals((long)-1L, (long)bl.initArgs(args));
    }

    @Test
    public void testAddLocalJar() throws Exception {
        TestBeeline bl = new TestBeeline();
        Assert.assertNull((Object)bl.findLocalDriver(this.connectionString));
        LOG.info("Add " + this.driverJarFileName + " for the driver class " + this.driverClazzName);
        bl.addLocalJar(this.driverJarFileName);
        bl.addlocaldrivername(this.driverClazzName);
        Assert.assertEquals((Object)bl.findLocalDriver(this.connectionString).getClass().getName(), (Object)this.driverClazzName);
    }

    @Test
    public void testAddLocalJarWithoutAddDriverClazz() throws Exception {
        TestBeeline bl = new TestBeeline();
        LOG.info("Add " + this.driverJarFileName + " for the driver class " + this.driverClazzName);
        Assert.assertTrue((String)("expected to exists: " + this.driverJarFileName), (boolean)new File(this.driverJarFileName).exists());
        bl.addLocalJar(this.driverJarFileName);
        if (!this.defaultSupported) {
            Assert.assertNull((Object)bl.findLocalDriver(this.connectionString));
        } else {
            Assert.assertNotNull((Object)bl.findLocalDriver(this.connectionString));
            Assert.assertEquals((Object)bl.findLocalDriver(this.connectionString).getClass().getName(), (Object)this.driverClazzName);
        }
    }

    @Test
    public void testBeelinePasswordMask() throws Exception {
        TestBeeline bl = new TestBeeline();
        File errFile = File.createTempFile("test", "tmp");
        bl.setErrorStream(new PrintStream(new FileOutputStream(errFile)));
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "--autoCommit=true", "--verbose", "--truncateTable"};
        bl.initArgs(args);
        bl.close();
        String errContents = new String(Files.readAllBytes(Paths.get(errFile.toString(), new String[0])));
        Assert.assertTrue((boolean)errContents.contains("[passwd stripped]"));
    }

    @Test
    public void testPropertyFile() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"--property-file", "props"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.properties.get(0).equals("props"));
        bl.close();
    }

    @Test
    public void testMaxHistoryRows() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"--maxHistoryRows=100"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((bl.getOpts().getMaxHistoryRows() == 100 ? 1 : 0) != 0);
        bl.close();
    }

    public class TestBeeline
    extends BeeLine {
        String connectArgs = null;
        List<String> properties = new ArrayList<String>();
        List<String> queries = new ArrayList<String>();

        boolean dispatch(String command) {
            String connectCommand = "!connect";
            String propertyCommand = "!properties";
            if (command.startsWith(connectCommand)) {
                this.connectArgs = command.substring(connectCommand.length() + 1, command.length());
            } else if (command.startsWith(propertyCommand)) {
                this.properties.add(command.substring(propertyCommand.length() + 1, command.length()));
            } else {
                this.queries.add(command);
            }
            return true;
        }

        public boolean addlocaldrivername(String driverName) {
            String line = "addlocaldrivername " + driverName;
            return this.getCommands().addlocaldrivername(line);
        }

        public boolean addLocalJar(String url) {
            String line = "addlocaldriverjar " + url;
            return this.getCommands().addlocaldriverjar(line);
        }
    }
}

