/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.apache.hive.beeline.BeeLine;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBeeLineHistory {
    private static final String fileName = System.getProperty("test.tmp.dir") + "/history";

    @BeforeClass
    public static void beforeTests() throws Exception {
        PrintWriter writer = new PrintWriter(fileName);
        writer.println("select 1;");
        writer.println("select 2;");
        writer.println("select 3;");
        writer.println("select 4;");
        writer.println("select 5;");
        writer.println("select 6;");
        writer.println("select 7;");
        writer.println("select 8;");
        writer.println("select 9;");
        writer.println("select 10;");
        writer.close();
    }

    @Test
    public void testNumHistories() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ops = new PrintStream(os);
        BeeLine beeline = new BeeLine();
        beeline.getOpts().setHistoryFile(fileName);
        beeline.setOutputStream(ops);
        Method method = beeline.getClass().getDeclaredMethod("setupHistory", new Class[0]);
        method.setAccessible(true);
        method.invoke((Object)beeline, new Object[0]);
        beeline.initializeConsoleReader(null);
        beeline.dispatch("!history");
        String output = os.toString("UTF-8");
        int numHistories = output.split("\n").length;
        Assert.assertEquals((long)10L, (long)numHistories);
        beeline.close();
    }

    @Test
    public void testHistory() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ops = new PrintStream(os);
        BeeLine beeline = new BeeLine();
        beeline.getOpts().setHistoryFile(fileName);
        beeline.setOutputStream(ops);
        Method method = beeline.getClass().getDeclaredMethod("setupHistory", new Class[0]);
        method.setAccessible(true);
        method.invoke((Object)beeline, new Object[0]);
        beeline.initializeConsoleReader(null);
        beeline.dispatch("!history");
        String output = os.toString("UTF-8");
        String[] tmp = output.split("\n");
        Assert.assertTrue((boolean)tmp[0].equals("1     : select 1;"));
        Assert.assertTrue((boolean)tmp[9].equals("10    : select 10;"));
        beeline.close();
    }

    @AfterClass
    public static void afterTests() throws Exception {
        File file = new File(fileName);
        file.delete();
    }
}

