/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.BufferedRows;
import org.apache.hive.beeline.ColorBuffer;
import org.apache.hive.beeline.Rows;
import org.apache.hive.beeline.TableOutputFormat;
import org.apache.hive.beeline.TestBufferedRows;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestTableOutputFormat {
    private final String[][] mockRowData = new String[][]{{"key1", "aaa"}, {"key2", "bbbbb"}, {"key3", "ccccccccccccccccccccccccccc"}, {"key4", "ddddddddddddddd"}};
    private BeelineMock mockBeeline;
    private ResultSet mockResultSet;
    private TestBufferedRows.MockRow mockRow;

    @Test
    public final void testPrint() throws SQLException {
        this.setupMockData();
        BufferedRows bfRows = new BufferedRows((BeeLine)this.mockBeeline, this.mockResultSet);
        TableOutputFormat instance = new TableOutputFormat((BeeLine)this.mockBeeline);
        String expResult = "+-------+------------------------------+";
        instance.print((Rows)bfRows);
        String outPutResults = this.mockBeeline.getLastPrintedLine();
        Assert.assertEquals((Object)expResult, (Object)outPutResults);
    }

    private void setupMockData() throws SQLException {
        this.mockBeeline = new BeelineMock();
        this.mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData mockResultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)mockResultSetMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(1)).thenReturn((Object)"Key");
        Mockito.when((Object)mockResultSetMetaData.getColumnLabel(2)).thenReturn((Object)"Value");
        Mockito.when((Object)this.mockResultSet.getMetaData()).thenReturn((Object)mockResultSetMetaData);
        this.mockRow = new TestBufferedRows.MockRow();
        Mockito.when((Object)this.mockResultSet.next()).thenAnswer((Answer)new Answer<Boolean>(){
            private int mockRowDataIndex = 0;

            public Boolean answer(InvocationOnMock invocation) {
                if (this.mockRowDataIndex < TestTableOutputFormat.this.mockRowData.length) {
                    TestTableOutputFormat.this.mockRow.setCurrentRowData(TestTableOutputFormat.this.mockRowData[this.mockRowDataIndex]);
                    ++this.mockRowDataIndex;
                    return true;
                }
                return false;
            }
        });
        Mockito.when((Object)this.mockResultSet.getString(Matchers.anyInt())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                int index = (Integer)args[0];
                return TestTableOutputFormat.this.mockRow.getColumn(index);
            }
        });
    }

    public class BeelineMock
    extends BeeLine {
        private String lastPrintedLine;

        final void output(ColorBuffer msg, boolean newline, PrintStream out) {
            this.lastPrintedLine = msg.getMono();
            super.output(msg, newline, out);
        }

        private String getLastPrintedLine() {
            return this.lastPrintedLine;
        }
    }
}

