/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.lexicoder.BigIntegerLexicoder;
import org.apache.accumulo.core.client.lexicoder.DoubleLexicoder;
import org.apache.accumulo.core.client.lexicoder.IntegerLexicoder;
import org.apache.hadoop.hive.accumulo.AccumuloIndexLexicoder;
import org.junit.Assert;
import org.junit.Test;

public class TestAccumuloIndexLexicoder {
    @Test
    public void testBooleanString() {
        byte[] value = Boolean.TRUE.toString().getBytes(StandardCharsets.UTF_8);
        Assert.assertArrayEquals((byte[])AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"boolean", (boolean)true), (byte[])value);
    }

    @Test
    public void testBooleanBinary() {
        byte[] value = new byte[]{1};
        Assert.assertArrayEquals((byte[])AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"boolean", (boolean)false), (byte[])Boolean.TRUE.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Test
    public void testIntString() {
        byte[] value = "10".getBytes(StandardCharsets.UTF_8);
        byte[] encoded = new IntegerLexicoder().encode(Integer.valueOf(10));
        byte[] lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"int", (boolean)true);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
        lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"smallint", (boolean)true);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
        lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"tinyint", (boolean)true);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
    }

    @Test
    public void testIntBinary() {
        byte[] value = ByteBuffer.allocate(4).putInt(10).array();
        byte[] encoded = new IntegerLexicoder().encode(Integer.valueOf(10));
        byte[] lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"int", (boolean)false);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
        value = ByteBuffer.allocate(2).putShort((short)10).array();
        lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"smallint", (boolean)false);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
        value = ByteBuffer.allocate(1).put((byte)10).array();
        lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"tinyint", (boolean)false);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
    }

    @Test
    public void testFloatBinary() {
        byte[] value = ByteBuffer.allocate(4).putFloat(10.55f).array();
        byte[] encoded = new DoubleLexicoder().encode(Double.valueOf(10.55f));
        String val = new String(encoded);
        byte[] lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"float", (boolean)false);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
        value = ByteBuffer.allocate(8).putDouble(10.55).array();
        encoded = new DoubleLexicoder().encode(Double.valueOf(10.55));
        lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"double", (boolean)false);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
    }

    @Test
    public void testFloatString() {
        byte[] value = "10.55".getBytes(StandardCharsets.UTF_8);
        byte[] encoded = new DoubleLexicoder().encode(Double.valueOf(10.55));
        byte[] lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"float", (boolean)true);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
        lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"double", (boolean)true);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
    }

    @Test
    public void testBigIntBinary() {
        byte[] value = new String("1232322323").getBytes(StandardCharsets.UTF_8);
        byte[] encoded = new BigIntegerLexicoder().encode(new BigInteger("1232322323", 10));
        byte[] lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"bigint", (boolean)true);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
        value = new BigInteger("1232322323", 10).toByteArray();
        encoded = new BigIntegerLexicoder().encode(new BigInteger("1232322323", 10));
        lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"bigint", (boolean)false);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
    }

    @Test
    public void testDecimalString() {
        String strVal = "12323232233434";
        byte[] value = strVal.getBytes(StandardCharsets.UTF_8);
        byte[] encoded = strVal.getBytes(StandardCharsets.UTF_8);
        byte[] lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"decimal", (boolean)true);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
        lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"DECIMAL (10,3)", (boolean)true);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
    }

    @Test
    public void testDecimalBinary() {
        byte[] value = new BigInteger("12323232233434", 10).toString().getBytes(StandardCharsets.UTF_8);
        byte[] encoded = new String(value).getBytes(StandardCharsets.UTF_8);
        byte[] lex = AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"decimal", (boolean)false);
        Assert.assertArrayEquals((byte[])lex, (byte[])encoded);
    }

    @Test
    public void testDateString() {
        String date = "2016-02-22";
        byte[] value = date.getBytes(StandardCharsets.UTF_8);
        Assert.assertArrayEquals((byte[])AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"date", (boolean)true), (byte[])value);
    }

    @Test
    public void testDateTimeString() {
        String timestamp = "2016-02-22 12:12:06.000000005";
        byte[] value = timestamp.getBytes(StandardCharsets.UTF_8);
        Assert.assertArrayEquals((byte[])AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"timestamp", (boolean)true), (byte[])value);
    }

    @Test
    public void testString() {
        String strVal = "The quick brown fox";
        byte[] value = strVal.getBytes(StandardCharsets.UTF_8);
        Assert.assertArrayEquals((byte[])AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"string", (boolean)true), (byte[])value);
        Assert.assertArrayEquals((byte[])AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"varChar(20)", (boolean)true), (byte[])value);
        Assert.assertArrayEquals((byte[])AccumuloIndexLexicoder.encodeValue((byte[])value, (String)"CHAR (20)", (boolean)true), (byte[])value);
    }
}

