/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate.compare;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.accumulo.predicate.compare.Equal;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.Like;
import org.apache.hadoop.hive.accumulo.predicate.compare.LongCompare;
import org.apache.hadoop.hive.accumulo.predicate.compare.NotEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.PrimitiveComparison;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLongComparison {
    private LongCompare longComp;

    @Before
    public void setup() {
        byte[] lBytes = new byte[8];
        ByteBuffer.wrap(lBytes).putLong(10L);
        this.longComp = new LongCompare();
        this.longComp.init(lBytes);
    }

    public byte[] getBytes(long val) {
        byte[] lonBytes = new byte[8];
        ByteBuffer.wrap(lonBytes).putLong(val);
        long lon = this.longComp.serialize(lonBytes);
        Assert.assertEquals((long)lon, (long)val);
        return lonBytes;
    }

    @Test
    public void equal() {
        Equal equalObj = new Equal((PrimitiveComparison)this.longComp);
        byte[] val = this.getBytes(10L);
        Assert.assertTrue((boolean)equalObj.accept(val));
    }

    @Test
    public void notEqual() {
        NotEqual notEqualObj = new NotEqual((PrimitiveComparison)this.longComp);
        byte[] val = this.getBytes(11L);
        Assert.assertTrue((boolean)notEqualObj.accept(val));
        val = this.getBytes(10L);
        Assert.assertFalse((boolean)notEqualObj.accept(val));
    }

    @Test
    public void greaterThan() {
        GreaterThan greaterThanObj = new GreaterThan((PrimitiveComparison)this.longComp);
        byte[] val = this.getBytes(11L);
        Assert.assertTrue((boolean)greaterThanObj.accept(val));
        val = this.getBytes(4L);
        Assert.assertFalse((boolean)greaterThanObj.accept(val));
        val = this.getBytes(10L);
        Assert.assertFalse((boolean)greaterThanObj.accept(val));
    }

    @Test
    public void greaterThanOrEqual() {
        GreaterThanOrEqual greaterThanOrEqualObj = new GreaterThanOrEqual((PrimitiveComparison)this.longComp);
        byte[] val = this.getBytes(11L);
        Assert.assertTrue((boolean)greaterThanOrEqualObj.accept(val));
        val = this.getBytes(4L);
        Assert.assertFalse((boolean)greaterThanOrEqualObj.accept(val));
        val = this.getBytes(10L);
        Assert.assertTrue((boolean)greaterThanOrEqualObj.accept(val));
    }

    @Test
    public void lessThan() {
        LessThan lessThanObj = new LessThan((PrimitiveComparison)this.longComp);
        byte[] val = this.getBytes(11L);
        Assert.assertFalse((boolean)lessThanObj.accept(val));
        val = this.getBytes(4L);
        Assert.assertTrue((boolean)lessThanObj.accept(val));
        val = this.getBytes(10L);
        Assert.assertFalse((boolean)lessThanObj.accept(val));
    }

    @Test
    public void lessThanOrEqual() {
        LessThanOrEqual lessThanOrEqualObj = new LessThanOrEqual((PrimitiveComparison)this.longComp);
        byte[] val = this.getBytes(11L);
        Assert.assertFalse((boolean)lessThanOrEqualObj.accept(val));
        val = this.getBytes(4L);
        Assert.assertTrue((boolean)lessThanOrEqualObj.accept(val));
        val = this.getBytes(10L);
        Assert.assertTrue((boolean)lessThanOrEqualObj.accept(val));
    }

    @Test
    public void like() {
        try {
            Like likeObj = new Like((PrimitiveComparison)this.longComp);
            Assert.assertTrue((boolean)likeObj.accept(new byte[0]));
            Assert.fail((String)"should not accept");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Like not supported for " + this.longComp.getClass().getName()));
        }
    }

    @Test
    public void invalidSerialization() {
        try {
            byte[] badVal = new byte[4];
            ByteBuffer.wrap(badVal).putInt(1);
            this.longComp.serialize(badVal);
            Assert.fail((String)"Should fail");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(" occurred trying to build long value"));
        }
    }
}

