/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.util.HashMap;
import java.util.Properties;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.AccumuloStorageHandler;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;

public class TestAccumuloStorageHandler {
    private AccumuloStorageHandler storageHandler;
    private Configuration conf;
    @Rule
    public TestName test = new TestName();

    @Before
    public void setup() {
        this.conf = new Configuration();
        this.storageHandler = new AccumuloStorageHandler();
        this.storageHandler.setConf(this.conf);
    }

    @Test
    public void testTablePropertiesPassedToOutputJobProperties() {
        TableDesc tableDesc = (TableDesc)Mockito.mock(TableDesc.class);
        Properties props = new Properties();
        HashMap jobProperties = new HashMap();
        props.setProperty("accumulo.columns.mapping", "cf:cq1,cf:cq2,cf:cq3");
        props.setProperty("columns.types", "string:int:string");
        props.setProperty("columns", "name,age,email");
        props.setProperty("accumulo.table.name", "table");
        props.setProperty("accumulo.visibility.label", "foo");
        Mockito.when((Object)tableDesc.getProperties()).thenReturn((Object)props);
        this.storageHandler.configureOutputJobProperties(tableDesc, jobProperties);
        Assert.assertEquals((long)3L, (long)jobProperties.size());
        Assert.assertTrue((String)"Job properties did not contain column mappings", (boolean)jobProperties.containsKey("accumulo.columns.mapping"));
        Assert.assertEquals((Object)props.getProperty("accumulo.columns.mapping"), jobProperties.get("accumulo.columns.mapping"));
        Assert.assertTrue((String)"Job properties did not contain accumulo table name", (boolean)jobProperties.containsKey("accumulo.table.name"));
        Assert.assertEquals((Object)props.getProperty("accumulo.table.name"), jobProperties.get("accumulo.table.name"));
        Assert.assertTrue((String)"Job properties did not contain visibility label", (boolean)jobProperties.containsKey("accumulo.visibility.label"));
        Assert.assertEquals((Object)props.getProperty("accumulo.visibility.label"), jobProperties.get("accumulo.visibility.label"));
    }

    @Test
    public void testTablePropertiesPassedToInputJobProperties() {
        TableDesc tableDesc = (TableDesc)Mockito.mock(TableDesc.class);
        Properties props = new Properties();
        HashMap jobProperties = new HashMap();
        props.setProperty("accumulo.columns.mapping", "cf:cq1,cf:cq2,cf:cq3");
        props.setProperty("accumulo.table.name", "table");
        props.setProperty("accumulo.iterator.pushdown", "true");
        props.setProperty("accumulo.default.storage", ColumnEncoding.BINARY.getName());
        props.setProperty("accumulo.authorizations", "foo,bar");
        Mockito.when((Object)tableDesc.getProperties()).thenReturn((Object)props);
        this.storageHandler.configureInputJobProperties(tableDesc, jobProperties);
        Assert.assertEquals((long)5L, (long)jobProperties.size());
        Assert.assertTrue((boolean)jobProperties.containsKey("accumulo.columns.mapping"));
        Assert.assertEquals((Object)props.getProperty("accumulo.columns.mapping"), jobProperties.get("accumulo.columns.mapping"));
        Assert.assertTrue((boolean)jobProperties.containsKey("accumulo.table.name"));
        Assert.assertEquals((Object)props.getProperty("accumulo.table.name"), jobProperties.get("accumulo.table.name"));
        Assert.assertTrue((boolean)jobProperties.containsKey("accumulo.iterator.pushdown"));
        Assert.assertEquals((Object)props.getProperty("accumulo.iterator.pushdown"), jobProperties.get("accumulo.iterator.pushdown"));
        Assert.assertTrue((boolean)jobProperties.containsKey("accumulo.default.storage"));
        Assert.assertEquals((Object)props.getProperty("accumulo.default.storage"), jobProperties.get("accumulo.default.storage"));
        Assert.assertTrue((boolean)jobProperties.containsKey("accumulo.authorizations"));
        Assert.assertEquals((Object)props.getProperty("accumulo.authorizations"), jobProperties.get("accumulo.authorizations"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonBooleanIteratorPushdownValue() {
        TableDesc tableDesc = (TableDesc)Mockito.mock(TableDesc.class);
        Properties props = new Properties();
        HashMap jobProperties = new HashMap();
        props.setProperty("accumulo.columns.mapping", "cf:cq1,cf:cq2,cf:cq3");
        props.setProperty("accumulo.table.name", "table");
        props.setProperty("accumulo.iterator.pushdown", "foo");
        Mockito.when((Object)tableDesc.getProperties()).thenReturn((Object)props);
        this.storageHandler.configureInputJobProperties(tableDesc, jobProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyIteratorPushdownValue() {
        TableDesc tableDesc = (TableDesc)Mockito.mock(TableDesc.class);
        Properties props = new Properties();
        HashMap jobProperties = new HashMap();
        props.setProperty("accumulo.columns.mapping", "cf:cq1,cf:cq2,cf:cq3");
        props.setProperty("accumulo.table.name", "table");
        props.setProperty("accumulo.iterator.pushdown", "");
        Mockito.when((Object)tableDesc.getProperties()).thenReturn((Object)props);
        this.storageHandler.configureInputJobProperties(tableDesc, jobProperties);
    }

    @Test
    public void testTableJobPropertiesCallsInputAndOutputMethods() {
        AccumuloStorageHandler mockStorageHandler = (AccumuloStorageHandler)Mockito.mock(AccumuloStorageHandler.class);
        TableDesc tableDesc = (TableDesc)Mockito.mock(TableDesc.class);
        HashMap jobProperties = new HashMap();
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)mockStorageHandler)).configureTableJobProperties(tableDesc, jobProperties);
        mockStorageHandler.configureTableJobProperties(tableDesc, jobProperties);
        ((AccumuloStorageHandler)Mockito.verify((Object)mockStorageHandler)).configureInputJobProperties(tableDesc, jobProperties);
        ((AccumuloStorageHandler)Mockito.verify((Object)mockStorageHandler)).configureOutputJobProperties(tableDesc, jobProperties);
    }

    @Test
    public void testPreCreateTable() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        String tableName = "table";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accumulo.columns.mapping", "cf:cq");
        AccumuloConnectionParameters connectionParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        AccumuloStorageHandler storageHandler = (AccumuloStorageHandler)Mockito.mock(AccumuloStorageHandler.class);
        StorageDescriptor sd = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Table table = (Table)Mockito.mock(Table.class);
        SerDeInfo serDeInfo = (SerDeInfo)Mockito.mock(SerDeInfo.class);
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)storageHandler)).preCreateTable(table);
        Mockito.when((Object)storageHandler.getTableName(table)).thenReturn((Object)tableName);
        Mockito.when((Object)storageHandler.isExternalTable(table)).thenReturn((Object)false);
        Mockito.when((Object)table.getSd()).thenReturn((Object)sd);
        Mockito.when((Object)sd.getLocation()).thenReturn(null);
        Mockito.when((Object)sd.getSerdeInfo()).thenReturn((Object)serDeInfo);
        Mockito.when((Object)serDeInfo.getParameters()).thenReturn(params);
        Mockito.when((Object)connectionParams.getConnector()).thenReturn((Object)conn);
        storageHandler.connectionParams = connectionParams;
        storageHandler.preCreateTable(table);
        Assert.assertTrue((String)"Table does not exist when we expect it to", (boolean)conn.tableOperations().exists(tableName));
    }

    @Test(expected=MetaException.class)
    public void testMissingColumnMappingFails() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        String tableName = "table";
        HashMap params = new HashMap();
        AccumuloConnectionParameters connectionParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        AccumuloStorageHandler storageHandler = (AccumuloStorageHandler)Mockito.mock(AccumuloStorageHandler.class);
        StorageDescriptor sd = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Table table = (Table)Mockito.mock(Table.class);
        SerDeInfo serDeInfo = (SerDeInfo)Mockito.mock(SerDeInfo.class);
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)storageHandler)).preCreateTable(table);
        Mockito.when((Object)storageHandler.getTableName(table)).thenReturn((Object)tableName);
        Mockito.when((Object)storageHandler.isExternalTable(table)).thenReturn((Object)false);
        Mockito.when((Object)table.getSd()).thenReturn((Object)sd);
        Mockito.when((Object)sd.getLocation()).thenReturn(null);
        Mockito.when((Object)sd.getSerdeInfo()).thenReturn((Object)serDeInfo);
        Mockito.when((Object)serDeInfo.getParameters()).thenReturn(params);
        Mockito.when((Object)connectionParams.getConnector()).thenReturn((Object)conn);
        storageHandler.connectionParams = connectionParams;
        storageHandler.preCreateTable(table);
    }

    @Test(expected=MetaException.class)
    public void testNonNullLocation() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        String tableName = "table";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accumulo.columns.mapping", "cf:cq");
        AccumuloConnectionParameters connectionParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        AccumuloStorageHandler storageHandler = (AccumuloStorageHandler)Mockito.mock(AccumuloStorageHandler.class);
        StorageDescriptor sd = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Table table = (Table)Mockito.mock(Table.class);
        SerDeInfo serDeInfo = (SerDeInfo)Mockito.mock(SerDeInfo.class);
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)storageHandler)).preCreateTable(table);
        Mockito.when((Object)storageHandler.getTableName(table)).thenReturn((Object)tableName);
        Mockito.when((Object)storageHandler.isExternalTable(table)).thenReturn((Object)false);
        Mockito.when((Object)table.getSd()).thenReturn((Object)sd);
        Mockito.when((Object)sd.getLocation()).thenReturn((Object)"foobar");
        Mockito.when((Object)sd.getSerdeInfo()).thenReturn((Object)serDeInfo);
        Mockito.when((Object)serDeInfo.getParameters()).thenReturn(params);
        Mockito.when((Object)connectionParams.getConnector()).thenReturn((Object)conn);
        storageHandler.connectionParams = connectionParams;
        storageHandler.preCreateTable(table);
    }

    @Test(expected=MetaException.class)
    public void testExternalNonExistentTableFails() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        String tableName = "table";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accumulo.columns.mapping", "cf:cq");
        AccumuloConnectionParameters connectionParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        AccumuloStorageHandler storageHandler = (AccumuloStorageHandler)Mockito.mock(AccumuloStorageHandler.class);
        StorageDescriptor sd = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Table table = (Table)Mockito.mock(Table.class);
        SerDeInfo serDeInfo = (SerDeInfo)Mockito.mock(SerDeInfo.class);
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)storageHandler)).preCreateTable(table);
        Mockito.when((Object)storageHandler.getTableName(table)).thenReturn((Object)tableName);
        Mockito.when((Object)storageHandler.isExternalTable(table)).thenReturn((Object)true);
        Mockito.when((Object)table.getSd()).thenReturn((Object)sd);
        Mockito.when((Object)sd.getLocation()).thenReturn(null);
        Mockito.when((Object)sd.getSerdeInfo()).thenReturn((Object)serDeInfo);
        Mockito.when((Object)serDeInfo.getParameters()).thenReturn(params);
        Mockito.when((Object)connectionParams.getConnector()).thenReturn((Object)conn);
        storageHandler.connectionParams = connectionParams;
        storageHandler.preCreateTable(table);
    }

    @Test(expected=MetaException.class)
    public void testNonExternalExistentTable() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        String tableName = "table";
        conn.tableOperations().create(tableName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accumulo.columns.mapping", "cf:cq");
        AccumuloConnectionParameters connectionParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        AccumuloStorageHandler storageHandler = (AccumuloStorageHandler)Mockito.mock(AccumuloStorageHandler.class);
        StorageDescriptor sd = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Table table = (Table)Mockito.mock(Table.class);
        SerDeInfo serDeInfo = (SerDeInfo)Mockito.mock(SerDeInfo.class);
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)storageHandler)).preCreateTable(table);
        Mockito.when((Object)storageHandler.getTableName(table)).thenReturn((Object)tableName);
        Mockito.when((Object)storageHandler.isExternalTable(table)).thenReturn((Object)false);
        Mockito.when((Object)table.getSd()).thenReturn((Object)sd);
        Mockito.when((Object)sd.getLocation()).thenReturn(null);
        Mockito.when((Object)sd.getSerdeInfo()).thenReturn((Object)serDeInfo);
        Mockito.when((Object)serDeInfo.getParameters()).thenReturn(params);
        Mockito.when((Object)connectionParams.getConnector()).thenReturn((Object)conn);
        storageHandler.connectionParams = connectionParams;
        storageHandler.preCreateTable(table);
    }

    @Test
    public void testRollbackCreateTableOnNonExistentTable() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        AccumuloStorageHandler storageHandler = (AccumuloStorageHandler)Mockito.mock(AccumuloStorageHandler.class);
        String tableName = "table";
        AccumuloConnectionParameters connectionParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        Table table = (Table)Mockito.mock(Table.class);
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)storageHandler)).rollbackCreateTable(table);
        Mockito.when((Object)storageHandler.getTableName(table)).thenReturn((Object)tableName);
        Mockito.when((Object)storageHandler.isExternalTable(table)).thenReturn((Object)false);
        Mockito.when((Object)connectionParams.getConnector()).thenReturn((Object)conn);
        storageHandler.connectionParams = connectionParams;
        storageHandler.rollbackCreateTable(table);
    }

    @Test
    public void testRollbackCreateTableDeletesExistentTable() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        AccumuloStorageHandler storageHandler = (AccumuloStorageHandler)Mockito.mock(AccumuloStorageHandler.class);
        String tableName = "table";
        conn.tableOperations().create(tableName);
        AccumuloConnectionParameters connectionParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        Table table = (Table)Mockito.mock(Table.class);
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)storageHandler)).rollbackCreateTable(table);
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)storageHandler)).commitDropTable(table, true);
        Mockito.when((Object)storageHandler.getTableName(table)).thenReturn((Object)tableName);
        Mockito.when((Object)storageHandler.isExternalTable(table)).thenReturn((Object)false);
        Mockito.when((Object)connectionParams.getConnector()).thenReturn((Object)conn);
        storageHandler.connectionParams = connectionParams;
        storageHandler.rollbackCreateTable(table);
        Assert.assertFalse((boolean)conn.tableOperations().exists(tableName));
    }

    @Test
    public void testRollbackCreateTableDoesntDeleteExternalExistentTable() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        AccumuloStorageHandler storageHandler = (AccumuloStorageHandler)Mockito.mock(AccumuloStorageHandler.class);
        String tableName = "table";
        conn.tableOperations().create(tableName);
        AccumuloConnectionParameters connectionParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        Table table = (Table)Mockito.mock(Table.class);
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)storageHandler)).rollbackCreateTable(table);
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)storageHandler)).commitDropTable(table, true);
        Mockito.when((Object)storageHandler.getTableName(table)).thenReturn((Object)tableName);
        Mockito.when((Object)storageHandler.isExternalTable(table)).thenReturn((Object)true);
        Mockito.when((Object)connectionParams.getConnector()).thenReturn((Object)conn);
        storageHandler.connectionParams = connectionParams;
        storageHandler.rollbackCreateTable(table);
        Assert.assertTrue((boolean)conn.tableOperations().exists(tableName));
    }

    @Test
    public void testDropTableWithoutDeleteLeavesTableIntact() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        AccumuloStorageHandler storageHandler = (AccumuloStorageHandler)Mockito.mock(AccumuloStorageHandler.class);
        String tableName = "table";
        conn.tableOperations().create(tableName);
        AccumuloConnectionParameters connectionParams = (AccumuloConnectionParameters)Mockito.mock(AccumuloConnectionParameters.class);
        Table table = (Table)Mockito.mock(Table.class);
        ((AccumuloStorageHandler)Mockito.doCallRealMethod().when((Object)storageHandler)).commitDropTable(table, false);
        Mockito.when((Object)storageHandler.getTableName(table)).thenReturn((Object)tableName);
        Mockito.when((Object)storageHandler.isExternalTable(table)).thenReturn((Object)false);
        Mockito.when((Object)connectionParams.getConnector()).thenReturn((Object)conn);
        storageHandler.connectionParams = connectionParams;
        storageHandler.rollbackCreateTable(table);
        Assert.assertTrue((boolean)conn.tableOperations().exists(tableName));
    }
}

