/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapred.AccumuloOutputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.impl.InputConfigurator;
import org.apache.accumulo.core.client.mapreduce.lib.impl.OutputConfigurator;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.fate.Fate;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.HiveAccumuloHelper;
import org.apache.hadoop.hive.accumulo.Utils;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloTableInputFormat;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloTableOutputFormat;
import org.apache.hadoop.hive.accumulo.predicate.AccumuloPredicateHandler;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDe;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloStorageHandler
extends DefaultStorageHandler
implements HiveMetaHook,
HiveStoragePredicateHandler {
    private static final Logger log = LoggerFactory.getLogger(AccumuloStorageHandler.class);
    private static final String DEFAULT_PREFIX = "default";
    protected AccumuloPredicateHandler predicateHandler = AccumuloPredicateHandler.getInstance();
    protected AccumuloConnectionParameters connectionParams;
    protected Configuration conf;
    protected HiveAccumuloHelper helper = new HiveAccumuloHelper();

    public void configureTableJobProperties(TableDesc desc, Map<String, String> jobProps) {
        this.configureInputJobProperties(desc, jobProps);
        this.configureOutputJobProperties(desc, jobProps);
    }

    protected String getTableName(Table table) throws MetaException {
        String tableName = (String)table.getParameters().get("accumulo.table.name");
        if (null != tableName) {
            return tableName;
        }
        tableName = (String)table.getSd().getSerdeInfo().getParameters().get("accumulo.table.name");
        if (null != tableName) {
            return tableName;
        }
        if (DEFAULT_PREFIX.equals(table.getDbName())) {
            return table.getTableName();
        }
        return table.getDbName() + "." + table.getTableName();
    }

    protected String getTableName(TableDesc tableDesc) {
        Properties props = tableDesc.getProperties();
        String tableName = props.getProperty("accumulo.table.name");
        if (null != tableName) {
            return tableName;
        }
        tableName = props.getProperty("name");
        if (tableName.startsWith("default.")) {
            return tableName.substring(DEFAULT_PREFIX.length() + 1);
        }
        return tableName;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.connectionParams = new AccumuloConnectionParameters(conf);
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return AccumuloSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        String authValue;
        String storageType;
        Properties props = tableDesc.getProperties();
        jobProperties.put("accumulo.columns.mapping", props.getProperty("accumulo.columns.mapping"));
        String tableName = props.getProperty("accumulo.table.name");
        if (null == tableName) {
            tableName = this.getTableName(tableDesc);
        }
        jobProperties.put("accumulo.table.name", tableName);
        String useIterators = props.getProperty("accumulo.iterator.pushdown");
        if (useIterators != null) {
            if (!useIterators.equalsIgnoreCase("true") && !useIterators.equalsIgnoreCase("false")) {
                throw new IllegalArgumentException("Expected value of true or false for accumulo.iterator.pushdown");
            }
            jobProperties.put("accumulo.iterator.pushdown", useIterators);
        }
        if (null != (storageType = props.getProperty("accumulo.default.storage"))) {
            jobProperties.put("accumulo.default.storage", storageType);
        }
        if (null != (authValue = props.getProperty("accumulo.authorizations"))) {
            jobProperties.put("accumulo.authorizations", authValue);
        }
        log.info("Computed input job properties of " + jobProperties);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties props = tableDesc.getProperties();
        jobProperties.put("accumulo.columns.mapping", props.getProperty("accumulo.columns.mapping"));
        String tableName = props.getProperty("accumulo.table.name");
        if (null == tableName) {
            tableName = this.getTableName(tableDesc);
        }
        jobProperties.put("accumulo.table.name", tableName);
        if (props.containsKey("accumulo.default.storage")) {
            jobProperties.put("accumulo.default.storage", props.getProperty("accumulo.default.storage"));
        }
        if (props.containsKey("accumulo.visibility.label")) {
            jobProperties.put("accumulo.visibility.label", props.getProperty("accumulo.visibility.label"));
        }
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveAccumuloTableInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveAccumuloTableOutputFormat.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preCreateTable(Table table) throws MetaException {
        boolean isExternal = this.isExternalTable(table);
        if (table.getSd().getLocation() != null) {
            throw new MetaException("Location can't be specified for Accumulo");
        }
        Map serdeParams = table.getSd().getSerdeInfo().getParameters();
        String columnMapping = (String)serdeParams.get("accumulo.columns.mapping");
        if (columnMapping == null) {
            throw new MetaException("accumulo.columns.mapping missing from SERDEPROPERTIES");
        }
        try {
            String tblName = this.getTableName(table);
            Connector connector = this.connectionParams.getConnector();
            TableOperations tableOpts = connector.tableOperations();
            if (!tableOpts.exists(tblName)) {
                if (isExternal) throw new MetaException("Accumulo table " + tblName + " doesn't exist even though declared external");
                tableOpts.create(tblName);
                return;
            } else {
                if (isExternal) return;
                throw new MetaException("Table " + tblName + " already exists in Accumulo. Use CREATE EXTERNAL TABLE to register with Hive.");
            }
        }
        catch (AccumuloSecurityException e) {
            throw new MetaException(StringUtils.stringifyException((Throwable)e));
        }
        catch (TableExistsException e) {
            throw new MetaException(StringUtils.stringifyException((Throwable)e));
        }
        catch (AccumuloException e) {
            throw new MetaException(StringUtils.stringifyException((Throwable)e));
        }
    }

    protected boolean isExternalTable(Table table) {
        return MetaStoreUtils.isExternalTable((Table)table);
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        this.commitDropTable(table, true);
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table table, boolean deleteData) throws MetaException {
        String tblName = this.getTableName(table);
        if (!this.isExternalTable(table)) {
            try {
                TableOperations tblOpts;
                if (deleteData && (tblOpts = this.connectionParams.getConnector().tableOperations()).exists(tblName)) {
                    tblOpts.delete(tblName);
                }
            }
            catch (AccumuloException e) {
                throw new MetaException(StringUtils.stringifyException((Throwable)e));
            }
            catch (AccumuloSecurityException e) {
                throw new MetaException(StringUtils.stringifyException((Throwable)e));
            }
            catch (TableNotFoundException e) {
                throw new MetaException(StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf conf, Deserializer deserializer, ExprNodeDesc desc) {
        if (!(deserializer instanceof AccumuloSerDe)) {
            throw new RuntimeException("Expected an AccumuloSerDe but got " + deserializer.getClass().getName());
        }
        AccumuloSerDe serDe = (AccumuloSerDe)deserializer;
        if (serDe.getIteratorPushdown()) {
            return this.predicateHandler.decompose((Configuration)conf, desc);
        }
        log.info("Set to ignore Accumulo iterator pushdown, skipping predicate handler.");
        return null;
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        try {
            Utils.addDependencyJars((Configuration)jobConf, Tracer.class, Fate.class, Connector.class, Main.class, ZooKeeper.class, AccumuloStorageHandler.class);
        }
        catch (IOException e) {
            log.error("Could not add necessary Accumulo dependencies to classpath", (Throwable)e);
        }
        Properties tblProperties = tableDesc.getProperties();
        AccumuloSerDeParameters serDeParams = null;
        try {
            serDeParams = new AccumuloSerDeParameters((Configuration)jobConf, tblProperties, AccumuloSerDe.class.getName());
        }
        catch (SerDeException e) {
            log.error("Could not instantiate AccumuloSerDeParameters", (Throwable)e);
            return;
        }
        try {
            serDeParams.getRowIdFactory().addDependencyJars((Configuration)jobConf);
        }
        catch (IOException e) {
            log.error("Could not add necessary dependencies for " + serDeParams.getRowIdFactory().getClass(), (Throwable)e);
        }
        if (this.connectionParams.useSasl()) {
            try {
                Connector conn = this.connectionParams.getConnector();
                AuthenticationToken token = this.helper.getDelegationToken(conn);
                try {
                    InputConfigurator.setConnectorInfo(AccumuloInputFormat.class, (Configuration)jobConf, (String)this.connectionParams.getAccumuloUserName(), (AuthenticationToken)token);
                }
                catch (IllegalStateException e) {
                    log.debug("Ignoring IllegalArgumentException about re-setting connector information");
                }
                try {
                    OutputConfigurator.setConnectorInfo(AccumuloOutputFormat.class, (Configuration)jobConf, (String)this.connectionParams.getAccumuloUserName(), (AuthenticationToken)token);
                }
                catch (IllegalStateException e) {
                    log.debug("Ignoring IllegalArgumentException about re-setting connector information");
                }
                Token<? extends TokenIdentifier> accumuloToken = this.helper.getHadoopToken(token);
                log.info("Adding Hadoop Token for Accumulo to Job's Credentials");
                this.helper.mergeTokenIntoJobConf(jobConf, accumuloToken);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to obtain DelegationToken for " + this.connectionParams.getAccumuloUserName(), e);
            }
        }
    }
}

