/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.DeleteDelegator;
import org.apache.hive.hcatalog.templeton.EnqueueBean;
import org.apache.hive.hcatalog.templeton.JobCallable;
import org.apache.hive.hcatalog.templeton.JobRequestExecutor;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueException;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;
import org.apache.hive.hcatalog.templeton.TooManyRequestsException;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.apache.hive.hcatalog.templeton.tool.JobState;
import org.apache.hive.hcatalog.templeton.tool.TempletonControllerJob;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LauncherDelegator
extends TempletonDelegator {
    private static final Logger LOG = LoggerFactory.getLogger(LauncherDelegator.class);
    protected String runAs = null;
    private boolean secureMeatastoreAccess = false;
    private final String HIVE_SHIMS_FILENAME_PATTERN = ".*hive-shims.*";
    private final String JOB_SUBMIT_EXECUTE_THREAD_PREFIX = "JobSubmitExecute";
    private final int jobTimeoutTaskRetryCount;
    private final int jobTimeoutTaskRetryIntervalInSec;
    private final String submitThreadId = Thread.currentThread().getName();
    private static JobRequestExecutor<EnqueueBean> jobRequest = new JobRequestExecutor(JobRequestExecutor.JobRequestType.Submit, "templeton.parallellism.job.submit", "templeton.job.submit.timeout", false);

    public LauncherDelegator(AppConfig appConf) {
        super(appConf);
        this.jobTimeoutTaskRetryCount = appConf.getInt("templeton.job.timeout.task.retry.count", 0);
        this.jobTimeoutTaskRetryIntervalInSec = appConf.getInt("templeton.job.timeout.task.retry.interval", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJob(String id, String user, String callback, Map<String, Object> userArgs) throws IOException {
        try (JobState state = null;){
            state = new JobState(id, Main.getAppConfigInstance());
            state.setUser(user);
            state.setCallback(callback);
            state.setUserArgs(userArgs);
        }
    }

    public EnqueueBean enqueueController(String user, Map<String, Object> userArgs, String callback, List<String> args) throws NotAuthorizedException, BusyException, IOException, QueueException, TooManyRequestsException {
        EnqueueBean bean = null;
        TempletonControllerJob controllerJob = this.getTempletonController();
        if (jobRequest.isThreadPoolEnabled()) {
            JobCallable<EnqueueBean> jobExecuteCallable = this.getJobSubmitTask(user, userArgs, callback, args, controllerJob);
            try {
                bean = jobRequest.execute(jobExecuteCallable);
            }
            catch (TimeoutException ex) {
                throw new QueueException(ex.getMessage());
            }
            catch (InterruptedException ex) {
                throw new QueueException(ex.getMessage());
            }
            catch (ExecutionException ex) {
                throw new QueueException(ex.getMessage());
            }
        } else {
            LOG.info("No thread pool configured for submit job request. Executing the job request in current thread.");
            bean = this.enqueueJob(user, userArgs, callback, args, controllerJob);
        }
        return bean;
    }

    private JobCallable<EnqueueBean> getJobSubmitTask(final String user, final Map<String, Object> userArgs, final String callback, final List<String> args, final TempletonControllerJob controllerJob) {
        return new JobCallable<EnqueueBean>(){

            @Override
            public EnqueueBean execute() throws NotAuthorizedException, BusyException, IOException, QueueException {
                Thread.currentThread().setName(String.format("%s-%s-%s", "JobSubmitExecute", LauncherDelegator.this.submitThreadId, Thread.currentThread().getId()));
                return LauncherDelegator.this.enqueueJob(user, userArgs, callback, args, controllerJob);
            }

            @Override
            public void cleanup() {
                LOG.info("Job kill not done by main thread. Trying to kill now.");
                LauncherDelegator.this.killTempletonJobWithRetry(user, controllerJob.getSubmittedId());
            }
        };
    }

    public EnqueueBean enqueueJob(String user, Map<String, Object> userArgs, String callback, List<String> args, TempletonControllerJob controllerJob) throws NotAuthorizedException, BusyException, IOException, QueueException {
        UserGroupInformation ugi = null;
        try {
            ugi = UgiFactory.getUgi(user);
            long startTime = System.nanoTime();
            String id = this.queueAsUser(ugi, args, controllerJob);
            long elapsed = (System.nanoTime() - startTime) / 1000000L;
            LOG.debug("queued job " + id + " in " + elapsed + " ms");
            if (id == null) {
                throw new QueueException("Unable to get job id");
            }
            this.registerJob(id, user, callback, userArgs);
            EnqueueBean enqueueBean = new EnqueueBean(id);
            return enqueueBean;
        }
        catch (InterruptedException e) {
            throw new QueueException("Unable to launch job " + e);
        }
        finally {
            if (ugi != null) {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
        }
    }

    private String queueAsUser(UserGroupInformation ugi, final List<String> args, final TempletonControllerJob controllerJob) throws IOException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Launching job: " + args);
        }
        return (String)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                LauncherDelegator.this.runTempletonControllerJob(controllerJob, args);
                return controllerJob.getSubmittedId();
            }
        });
    }

    private boolean killTempletonJobWithRetry(String user, String jobId) {
        if (StringUtils.startsWith((CharSequence)jobId, (CharSequence)"job_")) {
            LOG.info("Started killing the job " + jobId);
            boolean success = false;
            int count = 0;
            do {
                try {
                    ++count;
                    this.killJob(user, jobId);
                    success = true;
                    LOG.info("Kill job attempt succeeded.");
                }
                catch (Exception e) {
                    LOG.info("Failed to kill the job due to exception: " + e.getMessage());
                    LOG.info("Waiting for " + this.jobTimeoutTaskRetryIntervalInSec + "s before retrying the operation. Iteration: " + count);
                    try {
                        Thread.sleep(this.jobTimeoutTaskRetryIntervalInSec * 1000);
                    }
                    catch (InterruptedException ex) {
                        LOG.info("Got interrupted while waiting for next retry.");
                    }
                }
            } while (!success && count < this.jobTimeoutTaskRetryCount);
            return success;
        }
        LOG.info("Couldn't find a valid job id after job request is timed out.");
        return false;
    }

    protected TempletonControllerJob getTempletonController() {
        return new TempletonControllerJob(this.secureMeatastoreAccess, this.appConf);
    }

    protected int runTempletonControllerJob(TempletonControllerJob controllerJob, List<String> args) throws IOException, InterruptedException, TimeoutException, Exception {
        String[] array = new String[args.size()];
        return ToolRunner.run((Tool)controllerJob, (String[])args.toArray(array));
    }

    protected void killJob(String user, String jobId) throws NotAuthorizedException, BadParam, IOException, InterruptedException {
        DeleteDelegator d = new DeleteDelegator(this.appConf);
        d.run(user, jobId);
    }

    public List<String> makeLauncherArgs(AppConfig appConf, String statusdir, String completedUrl, List<String> copyFiles, boolean enablelog, Boolean enableJobReconnect, JobType jobType) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-libjars");
        String libJars = String.format("%s,%s", this.getShimLibjars(), appConf.libJars());
        args.add(libJars);
        LauncherDelegator.addCacheFiles(args, appConf);
        LauncherDelegator.addDef(args, "user.name", this.runAs);
        LauncherDelegator.addDef(args, "mapred.map.tasks.speculative.execution", "false");
        LauncherDelegator.addDef(args, "mapred.child.java.opts", appConf.controllerMRChildOpts());
        LauncherDelegator.addDef(args, "templeton.statusdir", statusdir);
        LauncherDelegator.addDef(args, "templeton.copy", TempletonUtils.encodeArray(copyFiles));
        LauncherDelegator.addDef(args, "templeton.override-classpath", LauncherDelegator.makeOverrideClasspath(appConf));
        LauncherDelegator.addDef(args, "templeton.enablelog", Boolean.toString(enablelog));
        LauncherDelegator.addDef(args, "templeton.jobtype", jobType.toString());
        LauncherDelegator.addDef(args, "templeton.job.launch.time", Long.toString(System.currentTimeMillis()));
        if (enableJobReconnect == null) {
            enableJobReconnect = appConf.enableJobReconnectDefault() != null ? Boolean.valueOf(Boolean.parseBoolean(appConf.enableJobReconnectDefault())) : Boolean.valueOf(false);
        }
        LauncherDelegator.addDef(args, "templeton.enablejobreconnect", Boolean.toString(enableJobReconnect));
        LauncherDelegator.addDef(args, "mapred.job.queue.name", appConf.hadoopQueueName());
        this.addStorageVars(args);
        this.addCompletionVars(args, completedUrl);
        return args;
    }

    private String getShimLibjars() {
        HadoopShims.WebHCatJTShim shim = null;
        UserGroupInformation ugi = null;
        try {
            ugi = UserGroupInformation.getCurrentUser();
            shim = ShimLoader.getHadoopShims().getWebHCatShim((Configuration)this.appConf, ugi);
            Path shimCommonJar = new Path(TempletonUtils.findContainingJar(ShimLoader.class, ".*hive-shims.*"));
            Path shimCommonSecureJar = new Path(TempletonUtils.findContainingJar(HadoopShimsSecure.class, ".*hive-shims.*"));
            Path shimJar = new Path(TempletonUtils.findContainingJar(shim.getClass(), ".*hive-shims.*"));
            String string = String.format("%s,%s,%s", shimCommonJar.toString(), shimCommonSecureJar.toString(), shimJar.toString());
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get shimLibJars", e);
        }
        finally {
            try {
                if (ugi != null) {
                    FileSystem.closeAllForUGI((UserGroupInformation)ugi);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to closeAllForUGI", e);
            }
        }
    }

    private void addStorageVars(List<String> args) {
        LauncherDelegator.addDef(args, "templeton.storage.class", this.appConf.get("templeton.storage.class"));
        LauncherDelegator.addDef(args, "templeton.storage.root", this.appConf.get("templeton.storage.root"));
        LauncherDelegator.addDef(args, "templeton.zookeeper.hosts", this.appConf.get("templeton.zookeeper.hosts"));
        LauncherDelegator.addDef(args, "templeton.zookeeper.session-timeout", this.appConf.get("templeton.zookeeper.session-timeout"));
    }

    private void addCompletionVars(List<String> args, String completedUrl) {
        LauncherDelegator.addDef(args, "job.end.retry.attempts", this.appConf.get("templeton.callback.retry.attempts"));
        LauncherDelegator.addDef(args, "job.end.retry.interval", this.appConf.get("templeton.callback.retry.interval"));
        LauncherDelegator.addDef(args, "job.end.notification.url", completedUrl);
    }

    public static void addCacheFiles(List<String> args, AppConfig appConf) {
        String overrides = appConf.overrideJarsString();
        if (overrides != null) {
            args.add("-files");
            args.add(overrides);
        }
    }

    public static String makeOverrideClasspath(AppConfig appConf) {
        String[] overrides = appConf.overrideJars();
        if (overrides == null) {
            return null;
        }
        ArrayList<String> cp = new ArrayList<String>();
        for (String fname : overrides) {
            Path p = new Path(fname);
            cp.add(p.getName());
        }
        return StringUtils.join((Object[])new Serializable[]{":", cp});
    }

    public static void addDef(List<String> args, String name, String val) {
        if (val != null) {
            args.add("-D");
            args.add(name + "=" + val);
        }
    }

    void addHiveMetaStoreTokenArg() {
        HiveConf hiveConf = new HiveConf();
        if (!hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL)) {
            return;
        }
        this.secureMeatastoreAccess = true;
    }

    public static enum JobType {
        JAR,
        STREAMING,
        PIG,
        HIVE,
        SQOOP;

    }
}

