/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.hive.hcatalog.templeton.SimpleWebException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class CatchallExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(CatchallExceptionMapper.class);

    public Response toResponse(Exception e) {
        LOG.error(e.getMessage(), (Throwable)e);
        if (e instanceof NotFoundException) {
            return SimpleWebException.buildMessage(404, null, e.getMessage());
        }
        return SimpleWebException.buildMessage(500, null, e.getMessage());
    }
}

