/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureProxySupport {
    private Path tokenPath;
    public static final String HCAT_SERVICE = "hcat";
    private final boolean isEnabled = UserGroupInformation.isSecurityEnabled();
    private String user;
    private static final Logger LOG = LoggerFactory.getLogger(SecureProxySupport.class);

    public Path getTokenPath() {
        return this.tokenPath;
    }

    public String getHcatServiceStr() {
        return HCAT_SERVICE;
    }

    public Path open(String user, Configuration conf) throws IOException, InterruptedException {
        this.close();
        if (this.isEnabled) {
            String hcatTokenStr;
            this.user = user;
            File t = File.createTempFile("templeton", null);
            this.tokenPath = new Path(t.toURI());
            Token<?>[] fsToken = this.getFSDelegationToken(user, conf);
            try {
                hcatTokenStr = this.buildHcatDelegationToken(user);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (hcatTokenStr == null) {
                LOG.error("open(" + user + ") token=null");
            }
            Token msToken = new Token();
            msToken.decodeFromUrlString(hcatTokenStr);
            msToken.setService(new Text(HCAT_SERVICE));
            this.writeProxyDelegationTokens(fsToken, msToken, conf, user, this.tokenPath);
        }
        return this.tokenPath;
    }

    public void close() {
        if (this.tokenPath != null) {
            new File(this.tokenPath.toUri()).delete();
            String checksumStr = this.tokenPath.getParent() + File.separator + "." + this.tokenPath.getName() + ".crc";
            File checksumFile = null;
            try {
                checksumFile = new File(new URI(checksumStr));
                if (checksumFile.exists()) {
                    checksumFile.delete();
                }
            }
            catch (URISyntaxException e) {
                LOG.error("Failed to delete token crc file.", (Throwable)e);
            }
            this.tokenPath = null;
        }
    }

    public void addEnv(Map<String, String> env) {
        if (this.isEnabled) {
            env.put("HADOOP_TOKEN_FILE_LOCATION", this.getTokenPath().toUri().getPath());
        }
    }

    public void addArgs(List<String> args) {
        if (this.isEnabled) {
            args.add("-D");
            args.add(HiveConf.ConfVars.METASTORE_TOKEN_SIGNATURE + "=" + this.getHcatServiceStr());
            args.add("-D");
            args.add("proxy.user.name=" + this.user);
        }
    }

    private Token<?>[] getFSDelegationToken(String user, final Configuration conf) throws IOException, InterruptedException {
        LOG.info("user: " + user + " loginUser: " + UserGroupInformation.getLoginUser().getUserName());
        final UserGroupInformation ugi = UgiFactory.getUgi(user);
        final TokenWrapper twrapper = new TokenWrapper();
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException, URISyntaxException {
                Credentials creds = new Credentials();
                SecureProxySupport.collectTokens(FileSystem.get((Configuration)conf), twrapper, creds, ugi.getShortUserName());
                Collection URIs = conf.getStringCollection("mapreduce.job.hdfs-servers");
                for (String uri : URIs) {
                    LOG.debug("Getting tokens for " + uri);
                    SecureProxySupport.collectTokens(FileSystem.get((URI)new URI(uri), (Configuration)conf), twrapper, creds, ugi.getShortUserName());
                }
                return null;
            }
        });
        FileSystem.closeAllForUGI((UserGroupInformation)ugi);
        return twrapper.tokens;
    }

    private static void collectTokens(FileSystem fs, TokenWrapper twrapper, Credentials creds, String userName) throws IOException {
        Object[] tokens = fs.addDelegationTokens(userName, creds);
        if (tokens != null && tokens.length > 0) {
            twrapper.tokens = (Token[])ArrayUtils.addAll((Object[])twrapper.tokens, (Object[])tokens);
        }
    }

    private void writeProxyDelegationTokens(final Token<?>[] fsTokens, final Token<?> msToken, final Configuration conf, String user, final Path tokenPath) throws IOException, InterruptedException {
        LOG.info("user: " + user + " loginUser: " + UserGroupInformation.getLoginUser().getUserName());
        UserGroupInformation ugi = UgiFactory.getUgi(user);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                Credentials cred = new Credentials();
                for (Token fsToken : fsTokens) {
                    cred.addToken(fsToken.getService(), fsToken);
                }
                cred.addToken(msToken.getService(), msToken);
                cred.writeTokenStorageFile(tokenPath, conf);
                return null;
            }
        });
        FileSystem.closeAllForUGI((UserGroupInformation)ugi);
    }

    private String buildHcatDelegationToken(String user) throws IOException, InterruptedException, TException {
        final HiveConf c = new HiveConf();
        final IMetaStoreClient client = HCatUtil.getHiveMetastoreClient((HiveConf)c);
        LOG.info("user: " + user + " loginUser: " + UserGroupInformation.getLoginUser().getUserName());
        final UserGroupInformation ugi = UgiFactory.getUgi(user);
        String s = (String)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws IOException, MetaException, TException {
                String u = ugi.getUserName();
                return client.getDelegationToken(c.getUser(), u);
            }
        });
        FileSystem.closeAllForUGI((UserGroupInformation)ugi);
        return s;
    }

    private static class TokenWrapper {
        Token<?>[] tokens = new Token[0];

        private TokenWrapper() {
        }
    }
}

