/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.CallbackFailedException;
import org.apache.hive.hcatalog.templeton.CompleteBean;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.apache.hive.hcatalog.templeton.tool.DelegationTokenCache;
import org.apache.hive.hcatalog.templeton.tool.JobState;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CompleteDelegator
extends TempletonDelegator {
    private static final Logger LOG = LoggerFactory.getLogger(CompleteDelegator.class);

    public CompleteDelegator(AppConfig appConf) {
        super(appConf);
    }

    public CompleteBean run(String user, final String id, final String jobStatus) throws CallbackFailedException, IOException, InterruptedException {
        if (id == null) {
            CompleteDelegator.acceptWithError("No jobid given");
        }
        if (user == null) {
            CompleteDelegator.acceptWithError("No user id given");
        }
        UserGroupInformation ugi = UgiFactory.getUgi(user);
        return (CompleteBean)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<CompleteBean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public CompleteBean run() throws Exception {
                JobState state = null;
                boolean cancelMetastoreToken = false;
                try {
                    Long notified;
                    state = new JobState(id, Main.getAppConfigInstance());
                    if (state.getCompleteStatus() == null) {
                        CompleteDelegator.failed("Job not yet complete. jobId=" + id + " Status from JobTracker=" + jobStatus, null);
                    }
                    if ((notified = state.getNotifiedTime()) != null) {
                        cancelMetastoreToken = true;
                        CompleteBean completeBean = CompleteDelegator.acceptWithError("Callback already run for jobId=" + id + " at " + new Date(notified));
                        return completeBean;
                    }
                    String callback = state.getCallback();
                    if (callback == null) {
                        cancelMetastoreToken = true;
                        CompleteBean client = new CompleteBean("No callback registered");
                        return client;
                    }
                    try {
                        CompleteDelegator.doCallback(state.getId(), callback);
                        cancelMetastoreToken = true;
                    }
                    catch (Exception e) {
                        CompleteDelegator.failed("Callback failed " + callback + " for " + id, e);
                    }
                    state.setNotifiedTime(System.currentTimeMillis());
                    CompleteBean completeBean = new CompleteBean("Callback sent");
                    return completeBean;
                }
                catch (CallbackFailedException ex) {
                    throw new Exception(ex);
                }
                finally {
                    state.close();
                    HiveMetaStoreClient client = null;
                    try {
                        String metastoreTokenStrForm;
                        if (cancelMetastoreToken && (metastoreTokenStrForm = DelegationTokenCache.getStringFormTokenCache().getDelegationToken(id)) != null) {
                            client = HCatUtil.getHiveClient((HiveConf)new HiveConf());
                            client.cancelDelegationToken(metastoreTokenStrForm);
                            LOG.debug("Cancelled token for jobId=" + id + " status from JT=" + jobStatus);
                            DelegationTokenCache.getStringFormTokenCache().removeDelegationToken(id);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Failed to cancel metastore delegation token for jobId=" + id, (Throwable)ex);
                    }
                    finally {
                        HCatUtil.closeHiveClientQuietly(client);
                    }
                }
            }
        });
    }

    public static void doCallback(String jobid, String url) throws IOException {
        if (url.contains("$jobId")) {
            url = url.replace("$jobId", jobid);
        }
        TempletonUtils.fetchUrl(new URL(url));
    }

    private static void failed(String msg, Exception e) throws CallbackFailedException {
        if (e != null) {
            LOG.error(msg, (Throwable)e);
        } else {
            LOG.error(msg);
        }
        throw new CallbackFailedException(msg);
    }

    private static CompleteBean acceptWithError(String msg) {
        LOG.error(msg);
        return new CompleteBean(msg);
    }
}

