/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.JobCallable;
import org.apache.hive.hcatalog.templeton.JobItemBean;
import org.apache.hive.hcatalog.templeton.JobRequestExecutor;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueStatusBean;
import org.apache.hive.hcatalog.templeton.StatusDelegator;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;
import org.apache.hive.hcatalog.templeton.TooManyRequestsException;
import org.apache.hive.hcatalog.templeton.UgiFactory;

public class ListDelegator
extends TempletonDelegator {
    private static final Log LOG = LogFactory.getLog(ListDelegator.class);
    private final String JOB_LIST_EXECUTE_THREAD_PREFIX = "JobListExecute";
    private final String listThreadId = Thread.currentThread().getName();
    private static JobRequestExecutor<List<JobItemBean>> jobRequest = new JobRequestExecutor(JobRequestExecutor.JobRequestType.List, "templeton.parallellism.job.list", "templeton.job.list.timeout");

    public ListDelegator(AppConfig appConf) {
        super(appConf);
    }

    public List<JobItemBean> run(String user, boolean showall, String jobId, int numRecords, boolean showDetails) throws NotAuthorizedException, BadParam, IOException, InterruptedException, BusyException, TimeoutException, ExecutionException, TooManyRequestsException {
        if (jobRequest.isThreadPoolEnabled()) {
            return jobRequest.execute(this.getJobListTask(user, showall, jobId, numRecords, showDetails));
        }
        return this.listJobs(user, showall, jobId, numRecords, showDetails);
    }

    private JobCallable<List<JobItemBean>> getJobListTask(final String user, final boolean showall, final String jobId, final int numRecords, final boolean showDetails) {
        return new JobCallable<List<JobItemBean>>(){

            @Override
            public List<JobItemBean> execute() throws NotAuthorizedException, BadParam, IOException, InterruptedException {
                Thread.currentThread().setName(String.format("%s-%s-%s", "JobListExecute", ListDelegator.this.listThreadId, Thread.currentThread().getId()));
                return ListDelegator.this.listJobs(user, showall, jobId, numRecords, showDetails);
            }
        };
    }

    public List<JobItemBean> listJobs(String user, boolean showall, String jobId, int numRecords, boolean showDetails) throws NotAuthorizedException, BadParam, IOException, InterruptedException {
        UserGroupInformation ugi = UgiFactory.getUgi(user);
        ArrayList<String> ids = new ArrayList<String>();
        try (HadoopShims.WebHCatJTShim tracker = null;){
            tracker = ShimLoader.getHadoopShims().getWebHCatShim((Configuration)this.appConf, ugi);
            JobStatus[] jobs = tracker.getAllJobs();
            if (jobs != null) {
                for (JobStatus job : jobs) {
                    String id = job.getJobID().toString();
                    if (!showall && !user.equals(job.getUsername())) continue;
                    ids.add(id);
                }
            }
        }
        return this.getJobStatus(ids, user, showall, jobId, numRecords, showDetails);
    }

    public List<JobItemBean> getJobStatus(ArrayList<String> jobIds, String user, boolean showall, String jobId, int numRecords, boolean showDetails) throws IOException, InterruptedException {
        ArrayList<JobItemBean> detailList = new ArrayList<JobItemBean>();
        int currRecord = 0;
        boolean isAscendingOrder = true;
        switch (this.appConf.getListJobsOrder()) {
            case lexicographicaldesc: {
                Collections.sort(jobIds, Collections.reverseOrder());
                isAscendingOrder = false;
                break;
            }
            default: {
                Collections.sort(jobIds);
            }
        }
        for (String job : jobIds) {
            if (numRecords != -1) {
                if (currRecord >= numRecords) break;
                if (jobId == null || jobId.trim().length() == 0) {
                    ++currRecord;
                } else {
                    if ((!isAscendingOrder || job.compareTo(jobId) <= 0) && (isAscendingOrder || job.compareTo(jobId) >= 0)) continue;
                    ++currRecord;
                }
            }
            JobItemBean jobItem = new JobItemBean();
            jobItem.id = job;
            if (showDetails) {
                StatusDelegator sd = new StatusDelegator(this.appConf);
                try {
                    jobItem.detail = sd.run(user, job, false);
                }
                catch (Exception ex) {
                    LOG.info((Object)("Failed to get status detail for jobId='" + job + "'"), (Throwable)ex);
                    jobItem.detail = new QueueStatusBean(job, "Failed to retrieve status; see WebHCat logs");
                }
            }
            detailList.add(jobItem);
        }
        return detailList;
    }
}

